/*
	WARNING: This file was generated by dkct.
	Changes you make here will be lost if dkct is run again!
	You should modify the original source and run dkct on it.
	Original source: DkClockView.cpt
*/

/*
Copyright (C) 2013, Dirk Krause

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:

* Redistributions of source code must retain the above copyright notice,
  this list of conditions and the following disclaimer.
* Redistributions in binary form must reproduce the above opyright notice,
  this list of conditions and the following disclaimer in the documentation
  and/or other materials provided with the distribution.
* Neither the name of the author nor the names of contributors may be used
  to endorse or promote products derived from this software without specific
  prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED.
IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY
DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/

/**	@file DkClockView.cpp The DkClockView module.
*/


#line 161 "DkClockView.cpt"


#include "wxdkclock.h"




#line 167 "DkClockView.cpt"

IMPLEMENT_DYNAMIC_CLASS(DkClockView, DkWxBufferedControl)

/**	Event handler table.
*/
BEGIN_EVENT_TABLE(DkClockView, DkWxBufferedControl)
	EVT_LEFT_DOWN(DkClockView::OnLeftDown)
END_EVENT_TABLE()



wxChar const DkClockView::windowtypename[] = { wxT("DkClockView") };



DkClockView::DkClockView()
:
cBlack(0, 0, 0),
#if defined(__WXMSW__)
cRed(127, 0, 0)
#else
cRed(191, 0, 0)
#endif
{
  bUseRed = false;
  cld = NULL;
}



DkClockView::DkClockView(
  wxWindow		*wParent,
  wxWindowID		 wid,
  DkClockData		*clockData,
  const wxPoint &	 pos,
  const wxSize  &	 size,
  long		 	 style
) : DkWxBufferedControl(
  wParent,
  wid,
  pos,
  size,
  (style | wxFULL_REPAINT_ON_RESIZE),
  wxDefaultValidator,
  wxString(windowtypename)
),
cBlack(0, 0, 0),
#if defined(__WXMSW__)
cRed(127, 0, 0)
#else
cRed(191, 0, 0)
#endif
{
  

#line 221 "DkClockView.cpt"
  bUseRed = false;
  cld = clockData;
  

#line 224 "DkClockView.cpt"
}



bool
DkClockView::Create(
  wxWindow		*wParent,
  wxWindowID		 wid,
  DkClockData		*clockData,
  const wxPoint &	 pos,
  const wxSize  &	 size,
  long		 	 style
)
{
  bool back;
  back = DkWxBufferedControl::Create(
    wParent, wid, pos, size, (style | wxFULL_REPAINT_ON_RESIZE),
    wxDefaultValidator, wxString(windowtypename)
  );
  bUseRed = false;
  cld = clockData;
  return back;
}



void
DkClockView::PaintOperation(
  wxDC & pdc, wxPaintEvent & event, bool buffered, int clWidth, int clHeight
)
{
  clockview_data_t	clvdata;		/* Clock data. */
  double		alpha;			/* Current angle in radians. */
  int			cx;			/* Center x. */
  int			cy;			/* Center y. */
  int			ro;			/* Outer radius. */
  int			rd;			/* Radius 5-minutes dot. */
  int			rc;			/* Center points radius. */
  int			ri;			/* Inner radius. */
  int			lw;			/* Line width of minute dots. */
  int			r1;			/* Inner radius minute dots. */
  int			r2;			/* Outer radius minute dots. */
  int			rs;			/* Radius seconds arrow. */
  int			rm;			/* Radius minuts arrow. */
  int			rh;			/* Radius hours arrow. */
  int			aw;			/* Width minutes and hours. */
  int			i;			/* Current index. */
  int			x;			/* Current x. */
  int			y;			/* Current y. */
  

#line 274 "DkClockView.cpt"
  pdc.SetBackground(*wxWHITE_BRUSH);
  pdc.Clear();
  cld->getData(&clvdata);
  if(clvdata.a) {
    bUseRed = ((bUseRed) ? false : true);
  } else {
    bUseRed = false;
  }
  cx = clWidth / 2;
  cy = clHeight / 2;
  ro = cx; if(cy < ro) { ro = cy; }
  ro = (int)(0.95 * (double)ro);
  rd = (int)(0.0497331 * (double)ro);
  if(rd < 1) { rd = 1; }
  rc = ro - rd;
  if(rc < 0) { rc = 0; }
  ri = ro - (2 * rd);
  if(ri < 0) { ri = 0; }
  lw = rd / 2;
  if(lw < 1) { lw = 1; }
  r1 = ri + (lw / 2);
  r2 = ro - (lw / 2);
  rs = ri - rd - (lw / 2);
  if(rs < 1) { rs = 1; }
  aw = rd;
  rm = ri - (2 * rd) - (aw / 2);
  if(rm < 1) { rm = 1; }
  rh = (int)(0.75 * (double)rm);
  if(rm < 1) { rh = 1; }
  /*
  	5-minute dots.
  */
  pdc.SetPen(*wxTRANSPARENT_PEN);
  if(bUseRed) {
    pdc.SetBrush(cRed);
  } else {
    pdc.SetBrush(cBlack);
  }
  for(i = 0; i < 12; i++) {
    alpha = (2.0 * M_PI * (double)i) / 12.0;
    x = cx + (int)((double)rc * cos(alpha));
    y = cy + (int)((double)rc * sin(alpha));
    pdc.DrawCircle(x, y, rd);
  }
  /*
  	Other minute ticks.
  */
  pdc.SetBrush(wxNullBrush);
  if(bUseRed) {
    pdc.SetPen(wxPen(cRed, lw));
  } else{
    pdc.SetPen(wxPen(cBlack, lw));
  }
  for(i = 0; i < 60; i++) {
    if(i % 5) {
      alpha = (2.0 * M_PI * (double)i) / 60.0;
      pdc.DrawLine(
        (cx + (int)((double)r1 * cos(alpha))),
	(cy + (int)((double)r1 * sin(alpha))),
	(cx + (int)((double)r2 * cos(alpha))),
	(cy + (int)((double)r2 * sin(alpha)))
      );
    }
  }
  /*
  	Hours arrow.
  */
  pdc.SetBrush(wxNullBrush);
  if(bUseRed) {
    pdc.SetPen(wxPen(cRed, aw));
  } else{
    pdc.SetPen(wxPen(cBlack, aw));
  }
  alpha = M_PI_2 - ((4.0 * M_PI * (double)(clvdata.h)) / 24.0);
  alpha = alpha - ((M_PI * (double)(clvdata.m)) / 360.0);
  pdc.DrawLine(
    cx, cy,
    (cx + (int)((double)rh * cos(alpha))),
    (cy - (int)((double)rh * sin(alpha)))
  );
  /*
  	Minutes arrow.
  */
  alpha = M_PI_2 - ((2.0 * M_PI * (double)(clvdata.m)) / 60.0);
  pdc.DrawLine(
    cx, cy,
    (cx + (int)((double)rm * cos(alpha))),
    (cy - (int)((double)rm * sin(alpha)))
  );
  /*
  	Seconds arrow.
  */
  pdc.SetBrush(wxNullBrush);
  if(bUseRed) {
    pdc.SetPen(wxPen(cRed, lw));
  } else{
    pdc.SetPen(wxPen(cBlack, lw));
  }
  alpha = M_PI_2 - ((2.0 * M_PI * (int)(clvdata.s)) / 60.0);
  pdc.DrawLine(
    cx, cy,
    (cx + (int)((double)rs * cos(alpha))),
    (cy - (int)((double)rs * sin(alpha)))
  );
  /*
  	Before leaving the function choose stock objects.
  */
  pdc.SetBrush(wxNullBrush);
  pdc.SetBackground(wxNullBrush);
  pdc.SetPen(wxNullPen);
  

#line 385 "DkClockView.cpt"
}



void
DkClockView::OnLeftDown(wxMouseEvent & event)
{
  

#line 393 "DkClockView.cpt"
  if(cld) {
    cld->endAlert();
    SetMustUpdate();
    Refresh();
    Update();
  } 

#line 399 "DkClockView.cpt"
}

    
    
int
DkClockView::getNormalRed(void) const
{
  int back;
  back = cBlack.Red();
  if(back < 0) { back = back + 256; }
  return back;
}



int
DkClockView::getNormalGreen(void) const
{
  int back;
  back = cBlack.Green();
  if(back < 0) { back = back + 256; }
  return back;
}



int
DkClockView::getNormalBlue(void) const
{
  int back;
  back = cBlack.Blue();
  if(back < 0) { back = back + 256; }
  return back;
}



int
DkClockView::getAlertRed(void) const
{
  int back;
  back = cRed.Red();
  if(back < 0) { back = back + 256; }
  return back;
}



int
DkClockView::getAlertGreen(void) const
{
  int back;
  back = cRed.Green();
  if(back < 0) { back = back + 256; }
  return back;
}



int
DkClockView::getAlertBlue(void) const
{
  int back;
  back = cRed.Blue();
  if(back < 0) { back = back + 256; }
  return back;
}



void
DkClockView::setNormal(int r, int g, int b)
{
  cBlack.Set((unsigned char)r, (unsigned char)g, (unsigned char)b);
}



void
DkClockView::setAlert(int r, int g, int b)
{
  cRed.Set((unsigned char)r, (unsigned char)g, (unsigned char)b);
}

