/*
	WARNING: This file was generated by dkct.
	Changes you make here will be lost if dkct is run again!
	You should modify the original source and run dkct on it.
	Original source: DkClockData.cpt
*/

/**	@file DkClockData.h Header file for the DkClockData module.
*/

#ifndef DKCLOCKDATA_H_INCLUDED
/** Avoid multiple inclusions. */
#define DKCLOCKDATA_H_INCLUDED 1


#line 4 "DkClockData.cpt"

/**	Data of interest for the DkClockView class.
*/
typedef struct {
  int		h;	/**< Current hour. */
  int		m;	/**< Current minute. */
  int		s;	/**< Current second. */
  int		a;	/**< Flag: In alert. */
} clockview_data_t;

/**	Data for DkClock.
*/
class DkClockData
{
  protected:

    /**	Protect data against concurrent access.
    */
    wxMutex		mxProtectData;

    /**	Current time.
    */
    dk3_tm_t		tmCurrent;

    /**	Output data structure.
    */
    clockview_data_t	clvd;

    /**	Hour of alert.
    */
    int			iAlertHour;

    /**	Minute of alert.
    */
    int			iAlertMinute;

    /**	Flag: Alert enabled.
    */
    int			iAlertEnabled;

    /**	Alert state (0=before alert, 1=in alert, 2=after alert).
    */
    int			iAlertState;

  public:

    /**	Constructor.
    */
    DkClockData();

    /**	Retrieve data from object into buffer.
    	@param	dptr	Buffer pointer.
    */
    void getData(clockview_data_t *dptr);

    /**	Get alert settings.
    	@param	en	Pointer to enabled variable.
	@param	h	Pointer to hour variable.
	@param	m	Pointer to minute variable.
    */
    void getAlertData(int *en, int *h, int *m);

    /**	Set new current time.
    	@param	ct	Current time.
	@return	1 to maximize and raise the window, 0 to do nothing.
    */
    int setTime(dk3_time_t *ct);

    /**	Enable or disable alert, set time when enabling.
    	@param	flag	Flag to enable or disable alert.
	@param	hour	Hour of alert.
	@param	min	Minute of alert.
    */
    void setAlert(bool flag, int hour, int min);

    /**	End a running alert.
    */
    void	endAlert(void);
};


#endif
