@echo off
perl -x -S %0.bat %1 %2 %3 %4 %5 %6 %7 %8 %9
goto endofperl
#! /usr/bin/perl
# For DOS perl 5 the previous comment is REQUIRED!  This comment may be deleted.

# Copyright 1991 by Norman Ramsey.  All rights reserved.
# See file COPYRIGHT for more information.
#
# These perl scripts were written by Phil Miller by directly
# copying Norman's shell scripts.  I, Phil Miller, relinquish all rights
# to Norman, and I also take no responsibility.
$NOLIB = $ENV{'NOLIB'};
$DIRSEP = $ENV{'DIRSEP'};
$LIB = "";
if ( $DIRSEP eq "/" && $NOLIB ne "" ) { 
   $LIB = $NOLIB . $DIRSEP;
   $ENV{'PATH'} = $ENV{'PATH'} . ":" . $NOLIB;
}
if ( $NOLIB eq "" ) {
   print STDERR "noweave:  trying to proceed with ENV{'NOLIB'} undefined.\n";
}
if ( $DIRSEP eq "" ) {
   print STDERR "noweave:  trying to proceed with ENV{'DIRSEP'} undefined.\n";
}
$markup = "markup";
$backend = "totex";
$noquote = "-noquote";
$noindex = "-noindex";
@pass2args = @ARGV;
while ( $ARGV[0] ) {
   $argin = $ARGV[0];
   shift;
   if    ( $argin eq "-latex" && $wrapper ne "none" ) { $wrapper = "latex"; }
   elsif ( $argin eq "-tex" && $wrapper ne "none" ) { $wrapper = "tex"; }
   elsif ( $argin eq "-html" ) {
      if ( $wrapper ne "none" ) { $wrapper = "html"; }
      $backend = "$LIB" . "tohtml -localindex";        
      $noquote = ""; 
      $docanchor = "-docanchor 10" ;
   }
   elsif ( $argin eq "-latex+html" ) {
      if ( $wrapper ne "nonw" ) { $wrapper = "latex"; }
      $backend = $LIB . "tohtml -localindex -raw";
      $noquote = "";
      $docanchor = "-docanchor 10";
   }   
   elsif ( $argin eq "-n" ) { $wrapper = "none"; }
   elsif ( $argin eq "-backend" ) { $backend = $ARGV[0]; shift; }
   elsif ( $argin eq "-markup"  ) { $markup =  $ARGV[0]; shift; }

   elsif ( $argin eq "-filter" ) { shift; }
   elsif ( $argin eq "-x" ) {; }
   elsif ( $argin eq "-index" ) { $noindex = ""; }
   elsif ( $argin eq "-indexfrom" ) { $noindex = ""; shift; }
   elsif ( $argin eq "-autodefs" ) {
         if ( $DIRSEP = "\\" ) {
            $filters = "$filters | $LIB" . "$ARGV[0]" . "defs"; shift;
         }
         else {
            $filters = "$filters | $LIB" . "autodefs." . $ARGV[0]; shift;
         }
   }
   elsif ( $argin eq "-showautodefs" ) { 
      if ( $DIRSEP eq "\\" ) {
         $lscmd = "ls $LIB" . "*defs.exe";
      }
      else {
         $lscmd = "ls $LIB" . "autodefs.*";
      }
      print STDERR "noweave:  executing $lscmd\n";
      $foundautodefs = `$lscmd`;
      print $foundautodefs;
      if ( $foundautodefs eq "" ) { 
         print STDERR "This `basename $0` does not support -autodefs\n";
      }; die("");
   }
   elsif( $argin eq "-option" ) { 
      $newopt = $ARGV[0]; 
      shift;
      if ($noweboptions eq "" ) {
         $noweboptions = $newopt;
      }
      else {
         $noweboptions="$noweboptions,$newopt";
      }
   }
   elsif ( $argin eq "-delay" ) { $delay = "-delay"; $wrapper = "none"; }
   elsif ( $argin =~ /-t.*/ ) { $markopts = "$markopts $argin"; }
   elsif( $argin eq "-v" ) { $verbose = 1; }
   elsif ( $argin =~ /-.*/ ) {
      print STDERR "$0: Unrecognized option $argin\n";
      print STDERR "Usage: $^X [options] [files]\n" ;
      print STDERR "Options recognized are:\n";
print STDERR "-latex            Use LaTeX headers and trailers (default).\n";
print STDERR "-tex              Use TeX headers and trailers.\n" ;
print STDERR "-html             Use HTML headers and trailers.\n" ;
print STDERR "-latex+html       Assume LaTeX in documentation, but use HTML in code.\n";
print STDERR " -n               Don't use any header or trailer.\n" ;
print STDERR "-markup frontend  Parse input with frontend (e.g., numarkup).\n";
print STDERR "-x                Use the default cross-referencer (needs LaTeX or HTML).\n";
print STDERR "-index            Create index using identifiers defined in input files.\n";
print STDERR "-indexfrom defs   Create index of identifers listed in file defs.\n"; 
print STDERR "-filter cmd       Filter through 'cmd' before weaving; cmd could prettyprint\n";
print STDERR "                  or perform other functions.\n";
print STDERR "-autodefs lang    Source is in language 'lang'; find definitions automatically.\n";
print STDERR "-showautodefs     List languages that can be used with -autodefs\n" ;
print STDERR "-option opt       Add \noweboptions{opt} to header (latex only)\n";
print STDERR "-delay            Delay markup until after first documentation chunk.\n";
print STDERR "-tk               Expand tab stops every k columns\n" ;
print STDERR "-t                Copy tabs to the output\n"; 
print STDERR "-v                Print pipeline on standard error\n";
      die("bad option $argin");
   }
   else { $arg = "$arg $argin"; }
}

if ($wrapper eq "" ) { $wrapper = "latex"; }

@ARGV = @pass2args;
while ( $ARGV[0] )  {
  $argin = $ARGV[0];
  shift;
  if ( $argin eq "-filter" ) {
     $newfilter = $ARGV[0]; shift;
     if ( $newfilter ne "" ) { $filters = "$filters | $newfilter "; }
  }
  elsif ( $argin eq "-x" ) {
     $filters = "$filters | $LIB" . "noidx $docanchor $delay";
  }
  elsif ( $argin eq "-index" ) {
     $filters = "$filters | $LIB" . "finduses $noquote";
     $filters = "$filters | $LIB" . "noidx $docanchor $delay";
  }
  elsif ( $argin eq "-indexfrom" ) {
      $newfilter="$LIB" . "finduses $noquote $ARGV[0]"; shift;    
      $filters = "$filters | $newfilter"; 
      $filters = "$filters | $LIB" . "noidx $docanchor $delay";
  }
}

$markupcmd = "$markup $markopts $arg $filters";
$backendcmd = "$backend $noindex $delay";

if ($wrapper eq "none" ) { $header = ""; }
elsif ( $wrapper eq "latex" ) {
   $header = "\@header $wrapper $noweboptions\n";
}   
else {
   $header = "\@header $wrapper $arg\n";
}   

if ( $verbose ) {  print STDERR "noweave:  $markupcmd\n"; }

if ( $wrapper ne "none" ) { 
   $trailer = "\@trailer $wrapper"; 
}
# these print statements should really only be called if verbose is set
print STDERR "noweave  markup:   $markupcmd\n";
print STDERR "noweave backend:  $backendcmd\n";
if ( $DIRSEP eq "\\" ) {
   open( MARKUPFILE, "> nwtmp.tmp" );
   print MARKUPFILE $header;
   print STDERR "noweave:  marking up\n";
   $markedoutput = `$markupcmd`;
   print MARKUPFILE $markedoutput;
   print MARKUPFILE $trailer;
   close( MARKUPFILE );
   print STDERR "noweave:  running backend\n";
   print `$backendcmd < nwtmp.tmp`
}
else {
   open( MARKUPFILE, "| $backendcmd" );
   print MARKUPFILE "$header `markupcmd` $trailer";
}
__END__
:endofperl


