The requirements, features, and problems of this version are:

* A 386, 486, or Pentium CPU is required.  This version will NOT work
  with anything else.

* 4MB or more of RAM is required.

* It is strongly recommended that a memory management program like
  HIMEM/EMM386 or QEMM be used.  NOTE: with older versions of the dos
  extender, machines with 64MB or more RAM should use use either QEMM or
  no memory manager; supposedly, on these machines, HIMEM/EMM386 and the
  dos extender may not work well together.  It is unknown if the current
  version of the dos extender has this requirement.

* Virtual memory is supported.  By using a swapfile on your hard disk,
  this version can access up to 32MB of memory, even though you may not
  have this much physical RAM.  However, you must explicitly enable
  virtual memory by setting an enviroment variable (see the section
  called, "The DOS/4GW DOS extender", for more details).  Interestingly
  enough, if you have more than 32MB of physical RAM, you can use all of
  it (more than 32MB) with this version of Perl; the 32MB limitation
  applies to virtual memory only.

  Note that this virtual memory is supported only outside of Windows
  3.1; when run inside Windows 3.1, perl uses the virtual memory
  provided by Windows.  This means that the amount of virtual memory
  under Windows becomes the limitation.  Further note that a Windows 3.1
  DOS window does not allow you to control/limit the amount of virtual
  memory used, as this mechanism bypasses the expanded/extended memory
  controls in a PIF file.

* This version will work under enhanced mode Windows 3.1 (it will not
  work in standard mode, though).  With this version, perl can now
  spawn another copy of perl.

  Note that people without a numeric coprocessor will have to manually
  add a Windows driver to their SYSTEM.INI file, in order to make perl
  work properly within a DOS window.  See the installation instructions
  for details.

* The size of the stack is fixed at 256K (previous versions were fixed
  at 192K).  To change this requires relinking perl.

* This version does not support entering scripts on the command line via
  the -e option.  While nothing has been done to prevent it, the MSDOS
  128-byte command-line-length limitation and the fact that MSDOS shells
  do not generally support quoted arguments will probably frustrate any
  attempts at using -e.

* The distributed perlglob.exe will perform filename globbing on
  directories.  For example:

	@files = <*>;

  will return a SORTED list of all normal+directory files, including
  read-only files.  Hidden & system files will not be returned.

  **** IMPORTANT NOTE *****
  Filename globbing (wildcards) are now done using a unix-like syntax.
  For example, "*" returns a list of *ALL* normal, read-only, and
  directory files.  The pattern "*.*" will return ONLY those files or
  directories with an extension; files and directories without an
  extension are not returned.  This is quite different from regular
  MSDOS wildcard expansion, where "*.*" will return a list of all files.

  Also note that wildcards can be used for the drive letter, e.g.:

	*:/foo.[ch]
	[c-f]:/foo*[xyz].*

  In perl, the wildcard expansion routines can be turned off by setting
  the "NOWILDEXPAND" environment variable.  You can set this variable to
  any value; all that matters is that it be set.  Note that this works
  only with the perl.exe program; the perlglob.exe program will always
  do unix-like filename globbing.

* The perl debugger works.

* Temporary files (ones created via the MSDOS popen()) are created in
  the root directory of the current drive.  The directory that is used
  can be overridden by setting any of the following enviroment
  variables: "TMP", "TEMP", or "TMPDIR".  The first variable found with
  a valid directory, in the order listed, is the one that is used.  Perl
  now verifies that "TMP", "TEMP", or "TEMPDIR" contains a valid
  directory before using it.  However, no check is made to verify that
  files can actually be created in the directory (e.g., the directory
  may be on a read-only network drive).  If none of these variables are
  set, or none contain a valid/existing directory name, the root
  directory of the current drive will be used (actually, the current
  drive *WHEN* the first temp file is created will be used -- this is an
  important distinction for those programs that switch between drives).
  Once a directory is chosen, that directory will continue to be used
  until perl terminates.

* Added a "-M" option to print out memory statistics at the end of a
  perl run.  Note that the statistics are printed to stderr, which,
  unfortunately, cannot be redirected to a file with many MSDOS shells
  (command.com included).  The most useful statistic is the last line,
  "Estimated incremental memory usage"; this is an estimate of the
  amount of memory malloc()'d by perl during its execution.  Outside of
  Windows, this amount of memory very likely includes the memory
  allocated for the runtime stack (default: 256KB).  However, inside a
  Windows DOS box, the amount probably doesn't include the stack memory.

  However, there are many things that can cause the estimated
  incremental memory usage statistic to be grossly incorrect inside
  Windows.  In particular, running other programs *BEFORE* or while perl
  is running can cause a wildly incorrect statistic.  For this
  statistic, perl just displays the difference between the first block
  of memory allocated and the last block allocated.  Within Windows,
  programs can coexist within the same 32-bit address space.  While a
  given memory block can only belong to a single program, adjacent
  blocks can be owned by different programs, and this fact can greatly
  distort the statistic.

  Also note that most of the statistics may not always make sense when
  perl is run within a Windows DOS box.  For some reason, Windows 3.1
  likes to tell perl that more memory can be allocated than is
  available.

  Further note that this option is subject to change; if a newer version
  of perl should use the "-M" switch for some purpose, this option will
  be moved to some other location.

* The exec() and ioctl() functions are not supported.  The exec()
  function is not supported because the DOS extender doesn't support it,
  and ioctl() is not supported because of problems translating data
  structures between real and protected modes.

* To avoid a bug in perl or the DOS extender, this version of perl turns
  control-break checking off (it does the equivalent of typing "break
  off" at the DOS prompt).  This was done because pressing Ctrl-C or
  Ctrl-Break very rapidly while perl is running would crash the system
  (pressing it only once would work, but pressing it rapidly could cause
  a crash).  The problem with this is that this version of perl can now
  only be interrupted while it is doing console I/O.  I don't know if
  this will ever be fixed.

  Note that the original state of the control-break checking flag is
  saved at startup, and will be restored if perl terminates normally
  (pressing control-break will NOT cause the original state to be
  restored, however).

* The most of the perl library files (in perl-5.000/lib/*.*) have not
  been tested.  They may or may not work with MSDOS.  The ones which are
  known to work are "pwd.pl" and "find.pl".

* The default location for the perl library support files is
  "c:\perl5\lib".  This can be changed through the use of the PERLLIB
  environment variable, or by recompiling perl.

* The perl documentation can be found as "pod" ("plain old
  documentation") files in the "pod" subdirectory.

* This version of perl says that it is version "5.0M5".  This was done
  to provide a means of identifying which MSDOS version of perl this is.

* The perlglob.exe program is now compiled using the 16-bit WATCOM
  compiler.  Borland compilers are now superfluous.  The compact memory
  model (64K code, >64K data) is still being used, to handle large
  directories.

* The a2p and s2p programs have been ported.  Check out the "x2p"
  subdirectory.  The "s2p" program is really "s2p.bat"; however, in
  order for this to work, perl must have been properly installed (be
  somewhere in %PATH).  Both a2p.exe and s2p.bat produce MSDOS batch
  file syntax; the output can be placed directly into a .BAT file and
  immediately executed as such.  This means that the output will have to
  be edited if you want to use it on some other platform, like Unix.
  Doing this is simple: a few lines at the beginning and end of the .BAT
  file need to be deleted.

* Note that the output of s2p.bat is completely unindented.  This is a
  side-effect of the simple C preprocessor used ("perlcpp.exe"), which
  is based upon the very ancient DECUS C preprocessor, and which deletes
  leading whitespace on a line.  If you don't like this, edit the code
  using Emacs' perl-mode, and use the indent-region feature.

* While a perlcpp.exe exists, perl's -E option has not (yet?) been
  implemented.

* NOTE: with Perl 5, the following trick to encapsulate Perl inside .BAT
  files NO LONGER WORK:

	@rem = '
	@echo off
	perl -S %0.bat %1 %2 %3 %4 %5 %6 %7 %8 %9 
	goto endofperl
	';
	# Insert your perl script here.  Your perl script goes here, and only
	# here.
	__END__
	:endofperl

  Perl complains about "@echo" needing to be quoted.  Use the following
  form instead:

	@echo off
	perl -x -S %0.bat %1 %2 %3 %4 %5 %6 %7 %8 %9 
	goto endofperl
	#! /usr/bin/perl
	# The previous comment is REQUIRED!  This comment, and the following
	# ones, can be deleted.
	# Insert your perl script here.  Your perl script goes here, and only
	# here.
	__END__
	:endofperl

  Note that the above DEPENDS on having a line that begins with "#!" and
  contains "perl".

* When executing files via system() or pipes opened via open(), any
  forward slashes ("/") in the executable program name are changed to
  backslashes.  You can now use statements like:

	open(IN, "./perl /a/b/fooscr |");

  This gets changed internally to:

	open(IN, ".\perl /a/b/fooscr |");

  Before, this would not work because MSDOS tried to execute the command
  "." with the option "/perl".

* Extra periods (".") in a filename are changed to underscores ("_"), to
  make it slightly easier to port Unix perl scripts (however, this can
  cause other problems).  This allows the use of filenames such as
  "a.b.c.d", which gets translated into "a_b_c.d".  However, note that
  this translation is done ONLY to files accessed directly by perl (via
  stat() or open()); NOTHING is done to filenames used in, for example:

	open(IN, "cat a.b.c.d|");
	system("type a.b.c.d");
	system("mycmd > a.b.c.d");

  Also, the translation is done only for the actual BASE filename.  Any
  directory specification up to the base file name is NOT translated.
  Repeat: directory names are *NOT* translated.  For example, the
  following names get properly translated:

	    This name			    Becomes
	-----------------		-----------------
	/a/b/c/d/e.f.g.h		/a/b/c/d/e_f_g.h
	/a/b/c.d/e.f.g.h		/a/b/c.d/e_f_g.h
	/a/b/c.d/.e.f			/a/b/c.d/_e.f

  But these do not:

	    This name			    Becomes (illegal)
	-----------------		-------------------------
	/a.b/.c.d/.e.f			/a.b/.c.d/_e.f
	/a.b.c.d/e.f.g			/a.b.c.d/e_f.g

* The filename "/dev/null" is now auto-translated into "nul", the MSDOS
  equivalent of the null device.


*******************************************************************************
***** Here is a list of perl regression tests in Perl 5.0 pl0, and
      whether or not they pass.

     Note: there is a perl script, called "t/test.dos", that runs all
tests that are known to pass 100% (which is 60-70% of the tests).

===============================================================================
base/cond.t	-- Passes
base/if.t	-- Passes
base/lex.t	-- Mostly passes.  There is a single failure (test #12), due
		   to differences between Unix and MSDOS.  (Under Unix, 'sh
		   -c "echo ok 12\n"' produces only one line of output.  Two
		   lines are output with MSDOS.)
base/pat.t	-- Passes
base/term.t	-- Mostly passes, if references to "/dev/null" are
		   changed to "nul".  Test #2 fails because command.com
		   does strange things with:
			echo hi there > foo
		   The file "foo" will contain "hi there " (note the
		   extra space at the end).  Using a shell such as 4DOS
		   makes this test pass.
cmd/elsif.t	-- Passes
cmd/for.t	-- Passes
cmd/mod.t	-- Passes
cmd/subval.t	-- Passes
cmd/switch.t	-- Passes
cmd/while.t	-- Passes, if references to the file "Cmd.while.tmp" are
		   changed to reference "Cmd_while.tmp".
comp/cmdopt.t	-- Passes
comp/cpp.t	-- Fails (cpp is not implemented)
comp/decl.t	-- Passes
comp/multilin.t	-- Passes, if references to "rm" and "cat" are changed to
		   "del" and "type".
comp/package.t	-- Passes
comp/script.t	-- Fails, due to differences between Unix and MSDOS.
		   (Testing under MSDOS would require adding code to properly
		   parse quoted command-line arguments.)
comp/term.t	-- Passes
io/argv.t	-- Fails, due to differences between Unix and MSDOS.
		   (Testing under MSDOS would require adding code to properly
		   parse quoted command-line arguments.)
io/dup.t	-- Mostly passes.  Test #5 fails because MSDOS can't handle
		   redirection of stderr.
io/fs.t		-- Fails, due to differences between Unix and MSDOS.
		   (Unix has the concept of a multiple file access
		   permissions: user, group, other.  MSDOS has no such
		   concepts.)
io/inplace.t	-- Not tested.
io/pipe.t	-- Fails.  Needs a working exec(), which is not supported
		   with this version of MSDOS perl.
io/print.t	-- Passes
io/tell.t	-- Passes
lib/big.t	-- Passes
op/append.t	-- Passes
op/array.t	-- Passes
op/auto.t	-- Passes
op/chop.t	-- Passes
op/cond.t	-- Passes
op/dbm.t	-- Mostly passes with GNU dbm, if the following is done:
			1. At the beginning of the test, the lines that test
			   to see if /usr/include/dbm.h or /usr/include/ndbm.h
			   exist are deleted.
			2. References to the file "Op.dbmx" are changed to
			   "Op_dbmx".
			3. References to the file "Op.dbmx.pag" are changed to
			   "Op_dbmx".
		   Test #2 fails due to file permission differences between
		   Unix and MSDOS.
op/delete.t	-- Passes
op/do.t		-- Passes
op/each.t	-- Passes
op/eval.t	-- Passes
op/exec.t	-- Fails (exec() not implemented)
op/exp.t	-- Passes
op/flip.t	-- Passes
op/fork.t	-- Fails (fork() not implemented)
op/glob.t	-- Passes, if a patch is applied to glob.t (this patch is
		   listed at the end of this list).  This patch may be
		   questionable.
op/goto.t	-- Mostly passes.  Test #3 fails due to differences between
		   Unix and MSDOS.  (Testing under MSDOS would require
		   adding code to properly parse quoted command-line
		   arguments.)
op/groups.t	-- Fails.  MSDOS has no concept of "groups".
op/index.t	-- Passes
op/int.t	-- Passes
op/join.t	-- Passes
op/list.t	-- Passes
op/local.t	-- Passes
op/magic.t	-- Fails, due to differences between Unix and MSDOS.
		   (Testing under MSDOS would require adding code to
		   properly parse quoted command-line arguments.)
op/mkdir.t	-- Mostly passes.  Parts fail due to different error
		   messages output by Unix and MSDOS.
op/oct.t	-- Passes
op/ord.t	-- Passes
op/pack.t	-- Passes
op/pat.t	-- Passes
op/push.t	-- Passes
op/range.t	-- Passes
op/read.t	-- Passes
op/readdir.t	-- Passes
op/regexp.t	-- Passes
op/repeat.t	-- Passes
op/s.t		-- Passes
op/sleep.t	-- Passes
op/sort.t	-- Passes
op/split.t	-- Mostly passes.  Test #11 fails due to differences between
		   Unix and MSDOS.  (Testing under MSDOS would require
		   adding code to properly parse quoted command-line
		   arguments.)
op/sprintf.t	-- Passes
op/stat.t	-- Fails (contains numerous Unix-isms, like "ls -l /dev",
		   "/usr/bin", "/dev/null", "/dev/tty", etc.)
op/study.t	-- Passes
op/substr.t	-- Passes
op/time.t	-- Fails ("times" not implemented)
op/undef.t	-- Passes
op/unshift.t	-- Passes
op/vec.t	-- Passes
op/write.t	-- Passes
