proc PrintDlg {geometry file params opt} {
  global prd
  upvar $params pr

  toplevel .prd
  wm geometry .prd $geometry
  wm transient .prd .
  wm title .prd "Print parameters"

  set prd(first) $pr(pr_first)
  set prd(last)  $pr(pr_last)
  set prd(copies) $pr(pr_copies)
  set prd(xopt) $pr(pr_xopt)
  if {$pr(pr_pages) == ""} { 
    set prd(pages) "all" 
  } else {
    set prd(pages) $pr(pr_pages) 
  } 
  if {$pr(pr_orientation) == ""} {
    set prd(orientation) "portrait" 
  } else { 
    set prd(orientation) $pr(pr_orientation)
  }
  label .prd.lt -text "Print parameters for $file"  \
    -width 35 -anchor w
  pack .prd.lt -side top -expand 1

  frame .prd.r1 -height 2 -bd 1 -relief sunken
  pack .prd.r1 -side top -fill x -pady 2

  frame .prd.sel
  pack .prd.sel -fill x -expand 1

  label .prd.sel.lf -text "First page:" -width 15  -anchor w
  entry .prd.sel.ef -relief sunken -font fixed -width 4 \
    -textvariable prd(first)

  label .prd.sel.ll -text "Last page:" -width 15  -anchor w
  entry .prd.sel.el -relief sunken -font fixed -width 4 \
    -textvariable prd(last)
  label .prd.sel.lc -text "Number of copies:" -width 15  -anchor w
  entry .prd.sel.ec -relief sunken -font fixed -width 4 \
    -textvariable prd(copies) 
  label .prd.sel.lx -text "Extra Options:" -width 15  -anchor w
  entry .prd.sel.ex -relief sunken -font fixed -width 20 \
    -textvariable prd(xopt) 
  if [regexp {!0} $opt] {
    grid .prd.sel.lf -row 0 -column 0 -sticky w
    grid .prd.sel.ef -row 0 -column 1 -sticky w
  } else {
    .prd.sel.ef configure -takefocus 0
  }
  if [regexp {!9} $opt] {
    grid .prd.sel.ll -row 1 -column 0 -sticky w
    grid .prd.sel.el -row 1 -column 1 -sticky w
  } else {
    .prd.sel.el configure -takefocus 0
  }
  if [regexp {!c} $opt] {
    grid .prd.sel.lc -row 2 -column 0 -sticky w
    grid .prd.sel.ec -row 2 -column 1 -sticky w
  } else {
    .prd.sel.ec configure -takefocus 0
  }
  if [regexp {!x} $opt] {
    grid .prd.sel.lx -row 3 -column 0 -sticky w
    grid .prd.sel.ex -row 3 -column 1 -sticky w
  } else {
    .prd.sel.ex configure -takefocus 0
  }
  grid columnconfigure .prd.sel 2 -weight 1

  frame .prd.r2 -height 2 -bd 1 -relief sunken
  pack .prd.r2 -fill x -pady 2

  frame .prd.fbu
  pack .prd.fbu -fill x -expand 1
  
  label .prd.fbu.lp -text "Page selection" -anchor w 
  radiobutton .prd.fbu.rall -text "All pages" -underline 0 -anchor w \
    -font fixed -variable prd(pages) -value "all"
  radiobutton .prd.fbu.rodd -text "Odd pages" -underline 0 -anchor w \
    -font fixed -variable prd(pages) -value odd
  radiobutton .prd.fbu.reven -text "Even pages" -underline 0 -anchor w \
    -font fixed -variable prd(pages) -value even
  
  label .prd.fbu.lo -text "Orientation" -anchor w 
  radiobutton .prd.fbu.rp -text "Portrait" -underline 0 -anchor w -font fixed \
    -variable prd(orientation) -value "portrait"
  radiobutton .prd.fbu.rl -text "Landscape" -underline 0 -anchor w -font fixed \
    -variable prd(orientation) -value landscape

  grid .prd.fbu.lp -row 0 -column 0
  grid .prd.fbu.rall -row 1 -column 0
  if [regexp {!o} $opt] {
    grid .prd.fbu.rodd -row 2 -column 0
  } else {
    .prd.fbu.rodd configure -takefocus 0
  }
  if [regexp {!e} $opt] {
    grid .prd.fbu.reven -row 3 -column 0
  } else {
    .prd.fbu.reven configure -takefocus 0
  }
  grid .prd.fbu.lo -row 0 -column 2
  if [regexp {!l} $opt] {
    grid .prd.fbu.rp -row 1 -column 2
    grid .prd.fbu.rl -row 2 -column 2
  } else {
    .prd.fbu.rp configure -takefocus 0
    .prd.fbu.rl configure -takefocus 0
  }
  grid columnconfigure .prd.fbu 1 -weight 1

  frame .prd.r3 -height 2 -bd 1 -relief sunken
  pack .prd.r3 -fill x -pady 2

  frame .prd.fb
  pack .prd.fb -fill x
  button .prd.fb.ok -text OK  -command {set prd(ok) 1} -default active
  button .prd.fb.cancel -text Cancel  \
    -command {set prd(ok) 0}
  pack .prd.fb.ok -side left -padx 5 -pady 2
  pack .prd.fb.cancel -padx 10 -pady 2 -side left

  set elist [list .prd.sel.ef .prd.sel.el .prd.sel.ec .prd.sel.ex]
  for {set i 0} {$i < 4} {incr i} {
    set w [lindex $elist $i]
    if {$i > 0} {
      set wp [lindex $elist [expr $i - 1]]
    } else {set wp .prd.sel.ec}
    if {$i < 3} {
      set wn [lindex $elist [expr $i + 1]]
    } else {set wn .prd.sel.ef}
#    bind $w <Return>         "focus $wn"
#    bind $w <Tab>            "focus $wn"
#    bind $w <Shift-Tab>      "focus $wp"
#    bind $w <Control-Return> "set prd(ok) 1"
#    bind $w <Escape>         "set prd(ok) 0" 
    bind $w <Alt-Any-a>	     "set prd(pages) all"
    bind $w <Alt-Any-o>	     "set prd(pages) odd"
    bind $w <Alt-Any-e>	     "set prd(pages) even"
    bind $w <Alt-Any-p>	     "set prd(orientation) portrait"
    bind $w <Alt-Any-l>	     "set prd(orientation) landscape"
  }
  bind .prd <Control-Return> "set prd(ok) 1"
  bind .prd <Escape>         "set prd(ok) 0" 
  set old_focus [focus]
  focus .prd.sel.ef
  grab .prd
  tkwait variable prd(ok)
  grab release .prd
  if {$prd(ok)} {
    set pr(pr_first) $prd(first)
    set pr(pr_last)  $prd(last)
    set pr(pr_copies) $prd(copies)
    set pr(pr_xopt) $prd(xopt)
    if {$prd(pages) == "all"} { 
      set pr(pr_pages) "" 
    } else {
      set pr(pr_pages) $prd(pages) 
    } 
    if {$prd(orientation) == "portrait"} {
      set pr(pr_orientation) "" 
    } else { 
      set pr(pr_orientation) $prd(orientation)
    }
  }
  focus $old_focus
  destroy .prd
  return $prd(ok)
}
