# Construct IDE interface

proc utilmenu {name} {
  global params

# Add dummy for correct deleting
  $name add separator
  $name delete 1 last
  if {$params(Util) != {}} {
    $name add separator
    set i 1
    foreach l $params(Util) {
      $name add command -label "$i [lindex $l 0]" -underline 0 \
        -command "Util [expr $i -1]"
      incr i
    }
  }
}

proc SetPos {} {
  global params

  set x [expr [winfo rootx .]+10]
  set y [winfo rooty .]
  set params(dlg_geom) +$x+$y
  set params(x0) $x
  set params(y0) $y
  set params(default_geom) +$params(x0)+0
  debug $params(dlg_geom)
}

proc ButtonHint {w s} {
  global params

  if {$params(hint_active) == 0} return
  if {![winfo exists $w]} return
  set x [winfo rootx $w]
  set y [expr [winfo rooty $w]+[winfo height $w]]
  catch {destroy .hint}
  menu .hint -tearoff 0 -bg yellow -bd 1 -relief flat
  .hint add command -label $s
  .hint post $x $y
}

proc DelButtonHint {} {
  global params

  set params(hint_active) 0
  catch {
    after cancel $params(af_post)
    after cancel $params(af_unpost)
    .hint unpost
    destroy .hint
  }
}

proc BindButtonHint {w s} {
  global params

  set params(hint_$w) $s
  bind $w <Enter> {
    set params(hint_active) 1
    set params(af_post) [after 1500 ButtonHint %W \"$params(hint_%W)\"]
    set params(af_unpost) [after 4500 DelButtonHint]
  }
  bind $w <Leave> {
    DelButtonHint
  }
}

proc HintButton {w bitmapfile cmd hint {selectparam {}} {paramname {}}} {
  global params
  frame $w -bd 1 -relief groove 
  button $w.b -bitmap @$params(icon_dir)/$bitmapfile -command $cmd -bd 1 \
    -pady 1 -relief flat
  grid $w.b -row 0 -column 0 -sticky ns
  if {$selectparam != {}} {
    button $w.s -bitmap @$params(icon_dir)/down2.ico -bd 1 \
      -command "SelectAction $w $selectparam" -relief flat
    bind $w.b <Button-3> "selectparams $selectparam"
    grid $w.s -row 0 -column 1 -sticky e -ipady 0
    bind $w.s <Enter> {
      %W config -relief raised
    }
    bind $w.s <Leave> {
      %W config -relief flat
    }
  }
  if {$paramname != {}} {
    button $w.l -textvariable params($paramname) -font fixed -anchor w \
    -width 10 -command $cmd -bd 1 -pady 0 -padx 0 -relief flat
    grid $w.l -row 1 -column 0 -columnspan 2 -sticky w -ipady 0
  }
  set params(hint_$w) $hint
  BindButtonHint $w $hint
  BindButtonHint $w $hint
}

proc WaitHint {w s} {
  set x [expr round([winfo rootx $w]+[winfo width $w]*0.4)]
  set y [expr round([winfo rooty $w]+[winfo height $w]*0.4)]
  menu .wait -tearoff 0 -bg red -font 10x20 -fg white -bd 2 -relief raised
  .wait add command -label $s
  .wait post $x $y
}

proc DelWaitHint {} {
  catch {destroy .wait}
}

proc showbuttons {} {
  global gparams

  if {$gparams(showicons)} {
    catch {
      grid .h -row 0 -column 0 -sticky ew
    }
  } else {
    catch {
      grid forget .h
    }
  }
}

proc showprimary {} {
  global gparams

  if {$gparams(showprimary)} {
    catch {
      grid .p -row 1 -column 0 -sticky ew
    }
  } else {
    catch {
      grid forget .p
    }
  }
}

proc showterm {} {
  global gparams

  if {$gparams(showout)} {
    catch {
      grid .term -row 2 -column 0 -sticky ew
    }
  } else {
    catch {
      grid forget .term
    }
  }
}
# Toplevel window
# +----------------------------------------+
# | Menubar .m                             |
# +----------------------------------------+
# | |Hotkey|Select| .h                     |
# | |   Info      |                        |
# +----------------------------------------+
# | Primary File .p                        |
# +----------------------------------------+
# | Terminal .t (80x25)                    |
# |                                        |
# |                                        |
# |                                        |
# +----------------------------------------+
#

proc ide {} {
  global params gparams SK

  if [info exists gparams(pos)] {
    set pos $gparams(pos)
  } else {
    set pos +10+25
  }
  wm title . TeXShell
  wm iconbitmap . @$params(icon_dir)/tex.ico
  wm protocol . WM_DELETE_WINDOW Exit
  update idletasks
  wm withdraw .
  wm geometry . $pos 
  wm deiconify .
  # Regions
  frame .p -bd 1 -relief groove
  frame .h -bd 1 -relief groove
  text .term -width $gparams(termwidth) -height $gparams(termheight) \
    -font [list $gparams(font) $gparams(fontsize) $gparams(fontstyle)]
  grid .term -row 2 -column 0 -sticky nsew

  # Menubar
  menu .menubar -bd 1
  . config -menu .menubar
  foreach m {File Action Util Options} {
    set $m [menu .menubar.m$m -tearoff 0]
    .menubar add cascade -label $m -underline 0 -menu .menubar.m$m
  }
  set Help [menu .menubar.help -tearoff 0]
  .menubar add cascade -label Help -underline 0 -menu .menubar.help

  $File add command -label "Primary File..." -underline 0 \
    -accelerator $SK(primary) -command Primary
  $File add command -label "Edit Primary" -underline 1 \
    -accelerator $SK(editprim) -command EditPrim
  $File add command -label "Edit..." -underline 0 \
    -accelerator $SK(edit) \
    -command Edit
  $File add command -label "Structure..." -underline 0 -accelerator \
    $SK(project) -command Project
  $File add separator
  $File add command -label Exit -underline 1 -accelerator {Alt-X} \
    -command {Exit}

  $Action add command -label "Graphics" -accelerator $SK(graphic) \
    -command Graphic -underline 0
  $Action add command -label "Compose" -accelerator $SK(compose) \
    -command Compose -underline 0
  $Action add command -label "References" -accelerator $SK(ref) \
    -command Reference -underline 0
  $Action add command -label "View" -accelerator $SK(view) \
    -command View -underline 0
  $Action add command -label "Print" -accelerator $SK(print) \
    -command Print -underline 0
  $Action add command -label "Util" -accelerator $SK(util) \
    -command Util -underline 0
  $Action add command -label "Filter" -accelerator $SK(filter) \
    -command Filter -underline 0

  $Util add command -label "Kill Process" -underline 0 -command Kill  
  utilmenu $Util
  
  $Options add checkbutton -label "Show Toolbar" \
    -variable gparams(showicons) -command showbuttons -underline 5
  $Options add checkbutton -label "Show Primary" \
    -variable gparams(showprimary) -command showprimary -underline 5
  $Options add checkbutton -label "Show Output" -underline 0 \
    -variable gparams(showout) -command showterm
  $Options add separator
  $Options add command -label "Editor..." -accelerator {^F3} \
    -underline 0 -command {selectparams Edit}
  $Options add command -label "Graphics..." -accelerator {^F5} \
    -underline 0 -command {selectparams Graphic}
  $Options add command -label "Compose..." -accelerator {^F6} \
    -underline 0 -command {selectparams Compose}
  $Options add command -label "References..." -accelerator {^F7} \
    -underline 0 -command {selectparams Reference}
  $Options add command -label "View..." -accelerator {^F8} \
    -underline 0 -command {selectparams View}
  $Options add command -label "Print..." -accelerator {^F9} \
    -underline 2 -command {selectparams Print}
  $Options add command -label "Utils..." -accelerator {^F11} \
    -underline 0 -command {selectparams Util}
  $Options add command -label "Filter..." -accelerator {^F12} \
    -underline 0 -command {selectfilter}
  $Options add separator
  $Options add command -label "Global Settings..." \
    -underline 6 -command GlobalOptions
  $Options add command -label "Editor Settings..." \
    -underline 6 -command EditOptions
  $Options add command -label "Save as default" -underline 1 \
    -command {writeparams default}
  $Help add command -label "TeXShell..." -accelerator F1 -command {Help .}

  # Command Buttons
  #  proc HintButton {w bitmapfile cmd Edit selectparam paramname} 
  HintButton .h.fedit edit2.ico Edit Edit Edit Edit_name
  HintButton .h.fgraph graphic2.ico Graphic Graphics Graphic Graphic_name
  HintButton .h.fcompose tex2.ico Compose Compose Compose Compose_name
  HintButton .h.fref ref2.ico Reference Reference Reference Reference_name 
  HintButton .h.fview xdvi2.ico View View View View_name
  HintButton .h.fprint printer2.ico Print Print Print Print_name
  HintButton .h.futil cat2.ico Util Util Util Util_name
  HintButton .h.ffilter filter.ico Filter Filter Filter Filter_name
  HintButton .p.fhelp help2.ico {Help .} Help
  HintButton .p.fexit door2.ico Exit Exit
  pack .h.fedit .h.fgraph .h.fcompose .h.fref .h.fview .h.fprint \
    .h.futil .h.ffilter -fill both -side left -expand 1
  showbuttons
  showprimary

 # Primary file
  HintButton .p.bprimary primary.ico Primary "Primary File"
  label .p.d -textvariable params(Short_dir) -font fixed -bd 1 -relief sunken
  label .p.ls -text " / "
  label .p.f -textvariable params(Primary_file) -font fixed -bd 1 \
    -relief sunken
  HintButton .p.bstruct struct.ico Project Structure
  pack .p.bprimary .p.bstruct -side left -anchor n -fill y
  pack .p.d .p.ls .p.f -side left -padx 2 -pady 2 -fill y -anchor n
  pack .p.fexit -side right -anchor n -fill y
  pack .p.fhelp -side right -anchor n -fill y

  # Bindings
  GlobalBind
  bind .term <Button-1> "xfocus ."
  update

# Output window
  CreateTerm

  # Save dialog geometry
##  update
  # Save default window geometry

  update
  SetPos
  debug $params(dlg_geom)
  showterm
  focus -force .
}

proc GlobalBind {} {
  global B

  bind all $B(help) {Help %W}
  bind . $B(edit) {Edit}
  bind . $B(primary) {Primary}
  bind . $B(editprim) { EditPrim }
  bind . $B(project) {Project}
  bind . $B(graphic) {Graphic}
  bind . $B(compose) {Compose}
  bind . $B(ref) {Reference}
  bind . $B(view) {View}
  bind . $B(print) {Print}
  bind . $B(util) {Util}
  bind . $B(filter) {Filter}
  bind . $B(paredit) "selectparams Edit"
  bind . $B(pargraphic) "selectparams Graphic"
  bind . $B(parcompose) "selectparams Compose"
  bind . $B(parref) "selectparams Reference"
  bind . $B(parview) "selectparams View"
  bind . $B(parprint) "selectparams Print"
  bind . $B(parutil) "selectparams Util"
  bind . $B(parfilter) "selectfilter"
  bind . $B(selterm)  "xfocus ."
  bind . $B(exit) "Exit"
  bind . <Alt-Key> {
    switch %A {
      x -
      X { Exit }
    }
  }
  for {set i 1} {$i < 10} {incr i} {
    bind . $B(seled$i) "Edit $i"
  }
}
