#!/bin/sh
#
# Based on Alan Jeffrey's `fontstnd.tex', this script writes
# a .tex file which does the necessary work for a `one off' font
# (like Zapf Chancery)
#
# Sebastian Rahtz February 6th 1994
#                 March 15th 1994
#                 May 5th 1994
#----------------------------------------------------------------
# The user has to supply the LaTeX2e family name, and the
# base name of the font,
# (to which <raw encoding>.afm will be appended to find the metrics.
#
# The output is:
#  - two .fd files (one for T1, one for OT1)
#  - tfm and vf files
#  - a file psfonts.<family> to be appended to psfonts.map (for dvips)
# Intermediate files are deleted.
#-------------------------------------------------------------
# suffix of raw fonts being used. eg 0 for Adobe Standard, 8w for
# Windows ANSI etc
RAW=0
#RAW=8w
PF=psfonts
LAT=latin
EXTRA=
DOWNLOAD=
SL=
EXPERT=
while true; do
	case $1 in
	-download)   shift ; DOWNLOAD=y ;;
	-*) echo $0: illegal option - $1 1>&2; shift;;
	 *) break;;
	esac
done
F=`echo $1 | sed 's/\(...\).*/\1/'`
echo '\nonstopmode' > $$F.tex
echo '\input fontinst.sty' > $$F.tex
echo '\needsfontinstversion{1.321}' >> $$F.tex
echo '\let\IF\installfont' >> $$F.tex
#--------------------------------------------------------
# Create the TeX command file for fontinst
#--------------------------------------------------------
echo "\installfonts" >> $$F.tex
echo "\installfamily{T1}{"${F}"}{}" >> $$F.tex
echo "\installfamily{OT1}{"${F}"}{}" >> $$F.tex
#
# first, the T1 encoding set
echo "\IF{"$1"q}{"$1${RAW}","$LAT"}{T1}{T1}{"${F}"}{"$2"}{"$3"}{}" >> $$F.tex
#----------------------------------------------------
# second, the OT1 encoding set. 
echo "\IF{"$1"}{"$1${RAW}",psyr,latin}{OT1$4}{OT1}{"${F}"}{"$2"}{"$3"}{}" >> $$F.tex
echo "\endinstallfonts" >> $$F.tex
echo '\bye' >> $$F.tex
#--------------------------------------------------------
# now run TeX with the fontinst macros. could take a while.
# --------------------------------------------------------
tex $$F
#--------------------------------------------------------
# convert the ascii .pl and .vpl files to binary
#--------------------------------------------------------
for i in $1*.pl 
do 
 B=`basename $i .pl`  
 pltotf $B.pl $B.tfm   
done    
for i in $1*.vpl 
do 
 B=`basename $i .vpl` 
 vptovf $B.vpl $B.vf $B.tfm  
done
# ---------------------------------------------------
# make up psfonts.map entries
# ---------------------------------------------------
N=`grep FontName $1${RAW}.afm | sed 's/.* \([A-z0-9\-]*\).*/\1/'`
if test "$DOWNLOAD"x != x
then
 echo $1${RAW} $N "<"$1${RAW}.pfb >> ${PF}.${F}
else
 echo $1${RAW} $N >> ${PF}.${F}
fi
#
# and delete the temporary files
#
rm $$*.*
rm ${F}*.mtx ${F}*.pl 
rm ${F}*.vpl
#
FF=`grep FName $1${RAW}.afm | sed 's/.* \([A-z0-9]*\).*/\1/'`
if test -d ${F}
then
	cat ${PF}.${F} >> ${F}/${PF}.${F}
	rm ${PF}.${F}
else
	mkdir ${F}
	mv ${PF}.${F} ${F}
fi
mv ${F}*.tfm ${F}
mv ${F}*.vf ${F}
for i in *T1$F*.fd 
do
 if test -f ${F}/$i
 then
  grep -v endinput ${F}/$i > $$F.fd
  cat $$F.fd > ${F}/$i
  cat $i | sed '/sub \*/s/$/{}/' >> ${F}/$i
  rm $$F.fd
 else
  cat $i | sed '/sub \*/s/$/{}/' > ${F}/$i
 fi
 rm $i
done 
cat > ${F}/README <<ENDOFCAT
This set of metric files for the ${FF} font family was
created on `date` by Sebastian Rahtz
using Alan Jeffrey's fontinst program.
It consists of:
 + tfm files for use by TeX in old TeX encoding (eg ptmr.tfm)
     and new Cork TeX encoding (eg ptmrq.tfm)
 + vf (virtual font) files for dvi drivers (same names as above)
 + tfm files for the _raw_ fonts (unencoded) to use with the vf files
 + .fd (font description) files for use with LaTeX2e
 + a file psfonts.${F} which lists the raw font names and their
    full PostScript names. This can be added to eg the psfonts.map file
    of dvips to ensure that the driver recognizes the names as those
    of PostScript fonts
ENDOFCAT
