/***************************************************************************
** Although considerable effort has been expended to make this software   **
** correct and reliable, no warranty is implied; the author disclaims any **
** obligation or liability for damages, including but not limited to      **
** special, indirect, or consequential damages arising out of or in       **
** connection with the use or performance of this software.               **
***************************************************************************/

/*
 *	These routines build and/or manipulate VMS string descriptors
 *	and strings.
 */

#include descrip
#include ctype

Make_VMS_Descriptor (String, Descriptor)
char *String;
struct dsc$descriptor *Descriptor;
{
	auto   char *Ptr;

	for (Ptr = String; *Ptr != '\0'; Ptr++)
		;
	Set_VMS_Descriptor (String, Ptr-String, Descriptor);
}

Set_VMS_Descriptor (String, Size, Descriptor)
char *String;
unsigned short Size;
struct dsc$descriptor *Descriptor;
{
	auto   struct dsc$descriptor *Desc;

	Desc = Descriptor;
	Desc->dsc$b_class = DSC$K_CLASS_S;
	Desc->dsc$b_dtype = DSC$K_DTYPE_BU;
	Desc->dsc$w_length = Size;
	Desc->dsc$a_pointer = String;
}

Set_Dynamic_VMS_Descriptor (Descriptor)
struct dsc$descriptor *Descriptor;
{
	auto   struct dsc$descriptor *Desc;

	Desc = Descriptor;
	Desc->dsc$b_class = DSC$K_CLASS_D;
	Desc->dsc$b_dtype = DSC$K_DTYPE_BU;
	Desc->dsc$w_length = 0;
	Desc->dsc$a_pointer = 0;
}

/*
 *	The next two routines copy from string descriptors.
 */

unsigned short Copy_Desc_to_String (Desc, String, String_Size)
struct dsc$descriptor *Desc;
char *String;
unsigned short String_Size;
{
	auto   unsigned short Length;
	auto   char *End_Ptr, *Ptr1, *Ptr2;
	extern unsigned long Analyze_Descriptor();
	extern int Check_System_Status();

	Ptr2 = String;
	End_Ptr = &Ptr2[String_Size-1];
	if (Check_System_Status (Analyze_Descriptor (Desc, &Length, &Ptr1)) != 0)
		for (; Length > 0 && Ptr2 < End_Ptr; Length--)
			*Ptr2++ = *Ptr1++;
	*Ptr2 = '\0';
	return (Ptr2 - String);
}

Copy_Desc_to_Fixed_Desc (In_Desc, Out_Desc)
struct dsc$descriptor *In_Desc, *Out_Desc;
{
	auto   unsigned short Length;
	auto   char *Ptr;
	extern unsigned long Analyze_Descriptor();
	extern int Check_System_Status();

	if (Check_System_Status (Analyze_Descriptor (In_Desc, &Length, &Ptr)) == 0) {
		Length = 0;
		Ptr = 0;
	}
	Set_VMS_Descriptor (Ptr, Length, Out_Desc);
}

unsigned short Concat_String (String, String_Size, Count, Desc)
char *String;
unsigned short String_Size, Count;
struct dsc$descriptor *Desc;
{
	auto   struct dsc$descriptor **Desc_Ptr;
	auto   unsigned short Cnt, Size, Length;
	auto   char *Ptr;
	extern unsigned short Copy_Desc_to_String();

	Desc_Ptr = &Desc;
	Size = String_Size;
	Ptr = String;
	for (Cnt = Count; Cnt > 0; Cnt--) {
		Length = Copy_Desc_to_String (*Desc_Ptr++, Ptr, Size);
		Ptr = &Ptr[Length];
		Size -= Length;
	}
	return (Ptr - String);
}

Trim_String (Desc)
struct dsc$descriptor *Desc;
{
	auto   unsigned short Length;

	for (Length = Desc->dsc$w_length; Length > 0 && Desc->dsc$a_pointer[Length-1] == ' ';
	     Length--)
		;
	Desc->dsc$w_length = Length;
}

/*
 *	Compare_Keyword compares a keyword string to a test value and
 *	returns 0 if they do not match, 1 if they match within the minimum
 *	number of matching characters, and 2 if they match but without
 *	enough characters. The return value is negated if the test value
 *	begins with 'NO'. Unlike DCL rules, the keyword may not be
 *	misspelled after four characters.
 */

int Compare_Keyword (Test_Value, Key_Value, Min_Match, Max_Match, Negation_OK)
char *Test_Value, *Key_Value;
unsigned int Min_Match, Max_Match, Negation_OK;
{
	auto   char *Key_Ptr, *Test_Ptr;
	auto   int Negated, Indicator;

	Test_Ptr = Test_Value;
	Negated = 0;
	if (Negation_OK != 0 && *Test_Ptr == 'N' && *(Test_Ptr+1) == 'O') {
		Negated++;
		Test_Ptr += 2;
	}
	for (Key_Ptr = Key_Value; *Key_Ptr == *Test_Ptr; Key_Ptr++, Test_Ptr++)
		if (*Key_Ptr == '\0')	/* Exact match */
			return ((Negated == 0) ? 1 : -1);
	Indicator = 0;
	if (*Test_Ptr == '\0') {
		if (Test_Ptr - Test_Value >= Min_Match)
			Indicator = 1;
		else			/* Ambiguous */
			Indicator = 2;
		if (Negated != 0)
			Indicator = -Indicator;
	}
	return (Indicator);
}

/*
 *	Routine Read_String_Character reads the next character from
 *	a string descriptor and updates the descriptor to point to the
 *	remaining string:
 */

unsigned char Read_String_Character (Str_Desc)
struct dsc$descriptor *Str_Desc;
{
	auto   unsigned char c;

	if (Str_Desc->dsc$w_length == 0)
		c = '\0';
	else {
		Str_Desc->dsc$w_length--;
		c = *Str_Desc->dsc$a_pointer++;
	}
	return (c);
}

int String_At_EOS (Str_Desc)
struct dsc$descriptor *Str_Desc;
{
	return ((Str_Desc->dsc$w_length == 0) ? 1 : 0);
}

/*
 *	Routine Analyze_Descriptor serves as an interface to the rtl
 *	routine Str$Analyze_SDesc, which signals errors rather than
 *	returning an error code.
 */

unsigned long Analyze_Descriptor (Desc, Length_Ptr, Data_Ptr)
struct dsc$descriptor *Desc;
unsigned short *Length_Ptr;
char **Data_Ptr;
{
	extern unsigned long Lib$Sig_to_Ret(), Str$Analyze_SDesc();
	extern unsigned long Lib$Establish();
	globalvalue SS$_NORMAL;

	Lib$Establish (&Lib$Sig_to_Ret);
	Str$Analyze_SDesc (Desc, Length_Ptr, Data_Ptr);
	return (SS$_NORMAL);
}

/*
 *	stringcat and stringcpy are variants of strcat and strcpy
 *	that check for array bounds overflow:
 */

char *stringcat (Out, In, Max_Size)
char *Out, *In;
int Max_Size;
{
	auto   int Size;
	extern char *stringcpy();
	extern int strlen();

	Size = strlen (Out);
	stringcpy (&Out[Size], In, Max_Size - Size);
	return (Out);
}

char *stringcpy (Out, In, Max_Size)
char *Out, *In;
int Max_Size;
{
	auto   char *In_Ptr, *Out_Ptr;
	auto   int Count;

	Out_Ptr = Out;
	for (Count = Max_Size, In_Ptr = In; Count > 1 && *In_Ptr != '\0'; Count--)
		*Out_Ptr++ = *In_Ptr++;
	if (Count > 0)
		*Out_Ptr = '\0';
	return (Out);
}

/*
 *	Routine bcplcpy copies a counted string to a null-terminated
 *	string:
 */

char *bcplcpy (Out, In, Max_Size)
char *Out, *In;
int Max_Size;
{
	auto   char *In_Ptr, *Out_Ptr;
	auto   int Count;

	In_Ptr = In;
	Out_Ptr = Out;
	if ((Count = *In_Ptr++) > Max_Size-1)
		Count = Max_Size - 1;
	for (; Count > 0; Count--)
		*Out_Ptr++ = *In_Ptr++;
	*Out_Ptr = '\0';
	return (Out);
}

/*
 *	Routine 'fold' converts a string to lower case:
 */

char *fold (Str)
char *Str;
{
	auto   char *Ptr;
	auto   char c;

	for (Ptr = Str; (c = *Ptr) != '\0'; Ptr++)
		*Ptr = _tolower (c);
	return (Str);
}
