IMPLEMENTATION MODULE TektronixVDU;

(* Author:         Philip Taylor
   Implementation: University of Hamburg Modula-2 under VAX/VMS version 4
   Date Started:   November, 1988.

   Description:
   Implements the InitTektronix procedure that initializes the terminal 
   dependent routines and parameters used in DVItoVDU.
   The Tektronix has an Alphanumeric mode and a graphical mode.
   DVItoVDU assumes text lines on the screen start at 1 and increase
   downwards; MoveAbs does the necessary translation to TEK coordinates.

   In graphical mode, the Tektronix screen is 768 pixels high by 1024 wide.
   The bottom left pixel is the point (x=0,y=0). Note that x coordinates
   increase to the right and y coordinates increase up the screen.
   DVItoVDU uses a coordinate scheme in which horizontal (=h) coordinates
   also increase to the right but vertical (=v) coordinates increase DOWN the
   screen, i.e. the top left pixel on the screen is the point (h=0,v=0).
   This means that the Tektronix routines will have to do a simple translation 
   of the vertical coordinates passed by DVItoVDU.

*)

FROM VDUInterface IMPORT

   (* PROCEDURE variables: *)

   StartText,
   MoveToTextLine,
   ClearTextLine,
   ClearScreen,
   StartGraphics,
   LoadFont,
   ShowChar,
   ShowRectangle,
   ResetVDU,

   (* INTEGER variables: *)

   DVIstatusl,
   windowstatusl,
   messagel,
   commandl,
   bottoml,
   windowv,
   windowh,
   windowht,
   windowwd;

FROM TEK4010VDU IMPORT
   dragdown,
   SendXY,
   havesentxy,
   TEK4010ClearScreen,
   TEK4010StartText,
   TEK4010MoveToTextLine,
   TEK4010StartGraphics,
   TEK4010LoadFont,
   TEK4010ShowChar,
   TEK4010ShowRectangle;

FROM ScreenIO IMPORT
   WriteCard,
   Write;

(******************************************************************************)

PROCEDURE InitTektronix;

(* The dialog region will be the top 4 text lines in Alphanumeric mode:
      Line 1 = DVI status line,
      Line 2 = window status line,
      Line 3 = message line,
      Line 4 = command line.
   The window region will be text lines 5 to 35 in Alphanumeric mode.
*)

BEGIN
DVIstatusl    := 1;      (* DVItoVDU assumes top text line = 1 *)
windowstatusl := 2;
messagel      := 3;
commandl      := 4;
bottoml       := 35;     (* also number of text lines on Tektronix screen *)
(* The above values assume the Tektronix is in Alphanumeric mode;
   the following values assume it is in graphical mode.
   Note that windowv must be given a value using DVItoVDU's coordinate scheme
   where top left pixel is (0,0).
*)
windowv  := 110;          (* approx. height in TEK4010 pixels of 5 text lines;
                            i.e. 5 * 768/35 *)
windowh  := 0;
windowht := 767-windowv;
windowwd := 1024;

MoveToTextLine := TEK4010MoveToTextLine;
ClearTextLine  := TektronixClearTextLine; (* can't be done ... *)
ClearScreen    := TEK4010ClearScreen;
StartText      := TEK4010StartText;
StartGraphics  := TEK4010StartGraphics;
LoadFont       := TEK4010LoadFont;
ShowChar       := TEK4010ShowChar;
ShowRectangle  := TEK4010ShowRectangle;
ResetVDU       := TEK4010ClearScreen;

ClearScreen;
END InitTektronix;

(******************************************************************************)

PROCEDURE TektronixClearTextLine (line : CARDINAL);

BEGIN
MoveToTextLine (line);
END TektronixClearTextLine;

BEGIN
END TektronixVDU.
