#include "genwindow.h"
#define NULL 0
int curpage; /* The page currently displayed. */
static int downx = 0; /* The X,Y coordinates when a button last went */
		      /* down. */ 
static int downy = 0;
static int xscreen = 0;
static int yscreen = 0;
static DVIW dviw = NULL; /* The DVI window to display. */
char *curfilename ();
enum buttontype {quit, load, bottom, top, next, previous};
struct buttonrec {char *name; int width; int x; int y;
		  enum buttontype callout; };
static struct buttonrec buttons [] =
{{"Quit",     4, 31, 0, quit},
 {"Load",     4, 31, 1, load},
 {"Bottom",   8, 37, 0, bottom},
 {"Top",      8, 47, 0, top},
 {"Next",     8, 37, 1, next},
 {"Previous", 8, 47, 1, previous},
 {0}};

void redisplay ()
{
  if (dviw) {
    curpage = ShowDviPage (&dviw, curpage, xscreen, yscreen);
    show_slider (dviw -> pages);
    update_slider (curpage);
  } else {
    clearscreen ();
    show_slider (1);
  }
}

/* Reset page offset.  This does NOT refresh the screen, so the caller */
 /* should do it.*/ 
void reset_scroll ()
{
  xscreen = -RESOLUTION;
  yscreen = -RESOLUTION;
}

void load_proc ()
{
  reset_scroll ();
  dviw = ReOpenDvi (dviw, curfilename ());
  curpage = 1;
  redisplay ();
}

void next_proc ()
{
  reset_scroll ();
  curpage++;
  redisplay ();  
}

void previous_proc ()
{
  reset_scroll ();
  curpage --;
  redisplay ();  
}

void refresh_proc ()
{
  redisplay ();
}     

void top_proc ()
{
  reset_scroll ();
  redisplay ();
}

void bottom_proc ()
{
  xscreen = -RESOLUTION;
  /* The number 10 is below because pages are 8.5 x 11, and there is a */
  /* one inch margin between the top and the (0,0) dvi coordinate. */
  yscreen = (10 * RESOLUTION) - screen_height ();
  redisplay ();
}

void quit_proc ()
{
  exit (0);
}

void buttondown (x, y)
{
  downx = x;
  downy = y;
}

void buttonup (x, y)
{
  xscreen += downx - x;
  yscreen += downy - y;
  redisplay ();
}

/* This routine calls create_a_button once for each record in */
 /* buttonrec.  This allows us to only say once where each button is */
 /* for both the sunview and the X implementations. */
void create_buttons ()
{
  struct buttonrec *thisbutton;
  void (* callout) ();
  
  thisbutton = buttons;
  while (thisbutton -> name) {
    switch (thisbutton -> callout) {
    case quit:
      callout = quit_proc; break;
    case load:
      callout = load_proc; break;
    case bottom:
      callout = bottom_proc; break;
    case top:
      callout = top_proc; break;
    case next:
      callout = next_proc; break;
    case previous:
      callout = previous_proc; break;
    default:
      fprintf (stderr, "Lost miserably while creating buttons.\n");
      exit (1);
      break;
    }
    create_a_button (thisbutton -> name,
		     thisbutton -> width,
		     thisbutton -> x,
		     thisbutton -> y, callout);
    thisbutton ++;
  };
  return;
}

/* This routine should be called to move to page pagenum.*/
void goto_page (pagenum)
   int pagenum;
{
  reset_scroll ();
  curpage = pagenum;
  redisplay ();
}

