#include <stdio.h>
#define  RESOLUTION 118 /* This is pixels per inch. */
/* DVIW's have the following state information:*/
  struct dviw {
    char *filename; /* Name of the file being displayed. */
    int modtime; /* Last modification date of the file. */
    FILE *dvifp; /* DVI file pointer */
    long cpagep; /* Pointer to start of current page in the file */
    long ppagep; /* Pointer to previous page in the file */
    int pagenum; /* Number of the last page displayed, counting from 1. */
    int pages;   /* Total number of pages in the file. */
  };

typedef struct dviw *DVIW; 
#define NEWDVIW (DVIW)malloc (sizeof (struct dviw))

/*
A DVI window will have the following operations:

OpenDvi: Filename -> DVIW or NULL
   Opens a dvi window viewing a particular file.*/
DVIW OpenDvi ();
/*CloseDvi: DVIW -> .
   Closes a dvi window.  The text on the window is unaffected.  */
void CloseDvi ();
/*ReOpenDvi: DVIW X Filename -> DVIW
   Equivalent to:
   DVIW ReOpenDvi (olddvi, filename)
        DVIW olddvi;
	char *filename;
   {
      DVIW newdvi;
      int safepages;
      newdvi = OpenDvi (filename);
      if (newdvi == NULL) {
         CloseDvi (olddvi);
	 return (newdvi);
      } else {
         return (olddvi);
      }
   }
   except that the above isn't quite legal because we forbid having 
   multiple DVIW's open at once.*/
DVIW ReOpenDvi ();
/*ShowDviPage: DVIW X pagenum X xscroll X yscroll -> realpage
   Attempts to show page pagenum of the file associated with DVIW.
   Realpage will be different from pagenum if pagenum is not positive
   or the document does not have that many pages.*/
int ShowDviPage ();
/*Pages: DVIW -> pagecount
   Returns the total number of pages in an open DVIW.*/
int Pages ();

/* For now, we will forbid having several of these open for one process
at once.  However, it should be possible to open and close several
DVIW's in sequence without accumulating garbage in the address space.
(Unfortunately, this isn't true yet.) 
/* The routines used to display the file will be determined at load time.
Errors will be reported by calling showerror with the appropriate
string.  The window manipulating routines don't take the window as
argument, so the DVIW's don't have the windows as part of the state.
*/

