# Filter Mathematica psfix output to change fontsize and bounding box

# 2/1/1991 Dan Dill dan@chem.bu.edu
# Based on scheme developed by Cameron Smith cameron@midd.bitnet

# Developed with Mathematica 1.2.  May break with 2.0

# awk -f addBBoxpro.awk height fontsize asprat
#	height		is in "big points", 72 bp = 1 in
#	fontsixe	is in bp
#	asprat		is a decimal number

BEGIN { 
	height = ARGV[1]; ARGV[1] = ""		# Don't treat arg as input file
	fontsize = ARGV[2]; ARGV[2] = ""	# ..
	aspratio = ARGV[3]; ARGV[3] = ""	# ..
	width = int(height / aspratio)
}
/BoundingBox/ {$4 = width; $5 = height}
/^\/Mfontsize/ {$2 = fontsize}
/^\/M[lrtb]marg/ {$2 = 0}
/^\/Mwidth/ {$2 = width; $3 = ""; $4 = ""}
/^\/Mheight/ {$2 = height; $3 = ""; $4 = ""}
{print}


