(* 2/25/1991 Dan Dill dan@chem.bu.edu *)

(* See also PSTeX.m, which does *not* include the prolog in the file. *)

PSTeX::usage = "PSTeX[-graphics-, \"file\"].

Process a graphics object to a PostScript file for inclusion is a TeX document
(using \\psfig).  Quotes are required around the file name and suffix `.ps' is
added.  The graphic object is preprocessed through psfix to prepend the
Mathematica PostScript precedures to the file, so that it can be included in
the TeX document directly (for example, with \\psfig{figure=file.ps}).  The
height of the scaled graphic is PSTeXHeight (default 100) and the font size
is PSTeXFontsize (default 7), both in big points (72 bp per inch).  For
example,

\n
\n
\t PSTeX[myplot, \"p4/myplot\"]
\n
\n
  will convert the graphics object myplot to the PostScript file myplot.ps in
the subdirectory p4 of the current directory.

\n
\n
  Note: PSTeX yields a graphic scaled to height PSTeXHeight and without
centering or margins, and so is not generally suitable for printing.  Use
PSFile to produce a graphic in a file, centered and scaled to fill the whole
page."

PSTeX::file = "Graphics being processed (with prolog) to file \"`1`\".";

PSTeXFontsize = 7;
PSTeXHeight = 100;

PSTeX[g_, f_String] := Block[{filename},
	filename = StringJoin[f, ".ps"];
	Message[PSTeX::file, filename];
	Display[StringJoin[
		"! psfix",
		" | ",
		"addBBoxpro",
		" ",
		ToString[PSTeXHeight],
		" ",
		ToString[PSTeXFontsize],
		" > ",
		filename
		], g
	];
];
