(* 2/25/1991 Dan Dill dan@chem.bu.edu *)

(* This version assumes the Mathematica prolog file will be avilable in the
   printer.  The current prolog is mma.pro.1.2 and is specific to version 1.2
   of Mathematica.  It will change in version 2.0.  The fontsize (at
   PSTeXHeight) is set as PSTeXFontsize  to 7 bp (72 bp per inch).  PSTeXpro.m
   is a version of PSTeX that includes the prolog in the file, using psfix,
   and so should work unchanged in version 2.0. *)

PSTeX::usage = "PSTeX[-graphics-, \"file\"].  Process a graphics object to a
PostScript file for inclusion in a TeX document (using \\psfig).  Quotes are
required around the file name and suffix `.ps' is added.  The graphic object
is scaled and shifted so that it can be included in the TeX document directly
(for example, with \\psfig{figure=file.ps}).  The height and font size of the
scaled graphic are PSTeXHeight (default 100) and PSTeXFontsize in big points
(72 bp per inch). For example,
\n
\n
\t PSTeX[myplot, \"p4/myplot\"]
\n
\n
  will convert the graphics object myplot to the PostScript file myplot.ps in
the subdirectory p4 of the current directory.

\n
\n
  Notes: The Mathematica PostScript prolog is *not* included in the file and
the prolog must be downloaded before the file can be printed.  PSTeX yields a
graphic with PSTeXHeight and without centering or margins, and so is not
generally suitable for printing.  Use PSFile to produce a graphic in a file,
centered and scaled to fill the whole page."

PSTeX::file = "Graphics being processed (without prolog) to file \"`1`\".";
PSTeXHeight = 100;
PSTeXFontsize = 7;
PSTeX[g_, f_String] := Block[{filename},
	filename = StringJoin[f, ".ps"];
	Message[PSTeX::file, filename];
	Display[StringJoin[
		"! ",
		"addBBox",
		" ",
		ToString[PSTeXHeight],
		" ",
		ToString[PSTeXFontsize],
		" > ",
		filename
		], g];];
