%%
%% This is file `jj_game.cls',
%% generated with the docstrip utility.
%%
%% The original source files were:
%%
%% jj_game.dtx  (with options: `package')
%% 
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%% jj_game.sty package,                                 %%
%% Copyright (C) 2000-2001  D. P. Story                 %%
%%   dpstory@uakron.edu                                 %%
%%                                                      %%
%% This program can redistributed and/or modified under %%
%% the terms of the LaTeX Project Public License        %%
%% Distributed from CTAN archives in directory          %%
%% macros/latex/base/lppl.txt; either version 1 of the  %%
%% License, or (at your option) any later version.      %%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
\NeedsTeXFormat{LaTeX2e}[1997/12/01]
\ProvidesClass{jj_game}[2007/04/01 v3.0a jj_game Class (dps)]
\RequirePackage{xkeyval}
\newcounter{jjgdriver}
\DeclareOptionX{pdftex}{\setcounter{jjgdriver}{0}
    \def\jjgdriver{pdftex}\PassOptionsToPackage{pdftex}{web}}
\DeclareOptionX{dvips}{\setcounter{jjgdriver}{1}
    \def\jjgdriver{dvips}\PassOptionsToPackage{dvips}{web}}
\DeclareOptionX{dvipsone}{\setcounter{jjgdriver}{1}
    \def\jjgdriver{dvipsone}\PassOptionsToPackage{dvipsone}{web}}
\DeclareOptionX{dvipdfm}{\setcounter{jjgdriver}{2}
    \def\jjgdriver{dvipdfm}\PassOptionsToPackage{dvipdfm}{web}}
\DeclareOptionX*{\PassOptionsToClass{\CurrentOption}{article}}
\newif\ifdebug \debugfalse
\DeclareOptionX{debug}{\debugtrue}
\newif\iffinal \finalfalse
\DeclareOptionX{final}{\finaltrue}
\newif\ifdouble \doublefalse
\def\scaleFactor{1}
\DeclareOptionX{double}{\doubletrue\def\scaleFactor{2}}
\DeclareOptionX{pro}{\let\jjgInputProCode\jjg@InputProCode}
\def\jjg@InputProCode{\InputIfFileExists{jjgpro.def}%
    {\ClassWarning{jj_game}{Inputting code for pro option}
      \ClassWarningNoLine{jj_game}{AeB Pro required with uselayers option}}%
    {\ClassWarning{jjg_game}{Cannot find jjgpro.def.\MessageBreak
        Reinstall or refresh your file name database.}}}
\let\jjgInputProCode\relax
\AtEndOfClass{\jjgInputProCode}
\DeclareOptionX{forcredit}{\let\jjImportForCreditCode\jj@ImportForCreditCode}
\let\jjImportForCreditCode\relax
\def\jj@ImportForCreditCode{\@ifpackageloaded{aeb_pro}{\InputIfFileExists{jjcredit.def}
    {\ClassWarning{jj_game}{Inputting forcredit code}
    \ClassWarningNoLine{jj_game}{Don't forget to use \string\contestantName\MessageBreak
    and \string\gameboardPrintButton}}{\ClassWarning{jj_game}{Cannot find jjcredit.def}}}
    {\ClassWarningNoLine{jj_game}{The forcredit option requires the aeb_pro package}}}
\let\jjg@madedesignselection0
\define@choicekey+{jj_game.cls}{design}{jeopardy,florida,iceland,hornet,qatar,norway,germany,bahamas,spain,custom}{%
    \ifx\jjg@madedesignselection0\def\jj@design@choice{#1}\AtEndOfClass{\jjInputDesignChoice}\global\let\jjg@madedesignselection1\def\jjg@useddesign{design}\else
        \ClassWarning{jj_game}{Do not use both design and customdesign\MessageBreak at the same time.\MessageBreak
        Using the \jjg@useddesign\space selection}\fi}
{\ClassWarning{jj_game}{Bad choice for design, permissible values
   are jeopardy, florida ,iceland, hornet, qatar, norway, germany, bahamas, spain. Try again}}
\def\jjInputDesignChoice{%
    \InputIfFileExists{design_\jj@design@choice.def}%
    {\ClassWarning{jj_game}{Inputting design choice \jj@design@choice}}%
    {\ClassWarning{jj_game}{Cannot find the file design_\jj@design@choice.def}}%
}
\define@key{jj_game.cls}{customdesign}{%
    \ifx\jjg@madedesignselection0\def\jj@design@choice{#1}\AtEndOfClass{\jjInputDesignChoice}\global\let\jjg@madedesignselection1\def\jjg@useddesign{customdesign}\else
    \ClassWarning{jj_game}{Do not use both design and customdesign\MessageBreak at the same time.\MessageBreak
    Using the \jjg@useddesign\space selection}\fi}
\DeclareOptionX{nodesigngraphics}{\let\jjgdesigngraphics\endinput}
\let\jjgdesigngraphics\relax
\define@choicekey+{jj_game.cls}{lang}[\val\nr]{english,german}
{\xdef\jjLangOpt{\nr}}{\ClassWarning{jj_game}
    {Bad choice for lang, permissible values are english and german.
     Try again.}}
\def\jjLangOpt{0}


\InputIfFileExists{jj_game.cfg}{}{}

\ProcessOptionsX

\LoadClass{article}
\RequirePackage[\jjgdriver,usetemplates,dvipsnames]{web}
\RequirePackage[\jjgdriver,execJS]{eforms}
\RequirePackage{verbatim}
\RequirePackage{comment}
\iffinal
    \def\JJinitSetup{%
        \hypersetup{%
            pdfmenubar=false,
            pdftoolbar=false,
            pdffitwindow=true,
            pdfcenterwindow=true,
            pdfwindowui=false%
        }
    }
\else
    \let\JJinitSetup\relax
\fi
\AtEndOfClass{\JJinitSetup}
\ifcase\jjLangOpt\relax
    \includecomment{JJLangEnglish}
    \excludecomment{JJLangGerman}
\or
    \includecomment{JJLangGerman}
    \excludecomment{JJLangEnglish}
    \AtEndOfClass{\germanLocalization}
\fi
\@ifundefined{jjImportForCreditCode}
    {\excludecomment{JJForCredit}}
    {\includecomment{JJForCredit}}
\def\germanLocalization{%
    \currencyHeading{\bfseries For~\EUR\theCurrencyAmt:}%
    \correctText{Richtig!}\incorrectText{Falsch!}%
    \def\jb@sepStyle{2}\def\jb@currStyle{0}%
    \def\APScore@Currency@def{"\string\\u20ac"}%
    \printButtonCaption{Drucken}%
    \printButtonLabel{Diese Seite drucken}%
    \contestentNameLabel{Student}%
    \timestampLabel{Zeitstempel}%
    \timeStampFormat{dd/mm/yy, H:MM:ss.}%
    \enterNamePlease{Bitte geben Sie Ihren Namen auf
        der ersten Seite ein, bevor Sie das Spiel beginnen!}
   \def\jb@Score{"Punkte "}
    \illegalAccessMsg{Sie haben gespickelt! Bitte w\string\344hlen Sie erst eine Frage vom Spielbrett,
    bevor Sie umbl\string\344ttern - diese Antwort wird nicht gewertet! \string\326ffnen Sie das
    PDF erneut und spielen Sie dieses Mal ohne zu spickeln.}
    \illegalAnswerTwiceMsg{\string\304ndern Ihrer Antwort ist nicht erlaubt!}

}
\definecolor{defaultfillCells}{rgb}{0.98,0.92,0.73}
\def\defaultfillCells{defaultfillCells}
\definecolor{defaultfillBanner}{rgb}{0.5,0,0.5}
\def\defaultfillBanner{defaultfillBanner}
\definecolor{defaulttextBanner}{rgb}{1,1,0} % yellow
\def\defaulttextBanner{defaulttextBanner}
\definecolor{defaulttextBoard}{rgb}{1,1,0} % yellow
\def\defaulttextBoard{defaulttextBoard}
\definecolor{defaultfillInstructions}{rgb}{0.98,0.92,0.73}
\def\defaultfillInstructions{defaultfillInstructions}
\definecolor{defaultfillGameBoard}{rgb}{1,0.8,0.6}
\def\defaultfillGameBoard{defaultfillGameBoard}
\definecolor{defaultfillQuestions}{rgb}{1,0.8,0.6}
\def\defaultfillQuestions{defaultfillQuestions}
\def\defaultDollarColorAmt{blue}
\def\defaultLinkColor{webgreen}
\definecolor{jj_banner_bg}{named}{defaultfillBanner}
\definecolor{jj_banner_txt}{named}{defaulttextBanner}
\def\jj@transparent{transparent}
\newcommand{\bannerTextFont}{\sffamily\huge}
\def\bannerTextColor{\ifx\textBanner\jj@transparent
    \else\color{\textBanner}\fi}
\def\titleBanner#1{\def\@titleBanner{#1}}
\titleBanner{You are the Winner!}
\def\insertJJTitleBanner{\newpage\jb@Banner{\@titleBanner}}
\newcommand{\includeFootBanner}{%
    \renewcommand{\@oddfoot}
    {%
        \ifnum\thepage=1\relax
        \colorbox{jj_banner_bg}{\makebox[\linewidth-2\fboxsep]{%
        \href{http://faculty.owc.edu/math/storyd}%
        {\textcolor{jj_banner_txt}{\webauthor \copyright\ \the\year}}\hfill
        \textcolor{jj_banner_txt}{\webuniversity}}}\else\hfil\fi
    }
}
\newdimen\jb@paperheight
\newdimen\jb@tmpdimb
\jb@paperheight=\paperheight
\newdimen\@Leftmargin   \@Leftmargin=0cm
\newdimen\@Rightmargin  \@Rightmargin=0cm
\newdimen\@Topmargin    \@Topmargin=0in
\newdimen\@Bottommargin \@Bottommargin=0in
\parindent0pt
\setlength\headheight{0pt}
\setlength\headsep   {0pt}
\setlength\footskip  {0pt}
\hoffset=0pt
\voffset=0pt
\pagestyle{empty}
\def\InitLayout{%
  \setlength{\textwidth}{\paperwidth}
  \addtolength{\textwidth}{-\@Leftmargin}
  \addtolength{\textwidth}{-\@Rightmargin}
  \setlength{\textheight}{\paperheight}
  \addtolength{\textheight}{-\@Topmargin}
  \addtolength{\textheight}{-\@Bottommargin}
  \addtolength{\textheight}{-\headheight}
  \addtolength{\textheight}{-\headsep}
  \addtolength{\textheight}{-\footskip}
  \setlength{\oddsidemargin}{\@Leftmargin}
  \addtolength{\oddsidemargin}{-1in}
  \setlength{\evensidemargin}{\@Leftmargin}
  \addtolength{\evensidemargin}{-1in}
  \setlength{\topmargin}{\@Topmargin}
  \addtolength{\topmargin}{-1in}
  \setlength{\textscreenwidth}{\paperwidth}
}
\def\screensize#1#2{%
    \paperheight=#1%
    \paperwidth=#2
    \web@set@paper
    \InitLayout
}
\def\marginsize#1#2#3#4{%
    \@Leftmargin=#1
    \@Rightmargin=#2
    \@Topmargin=#3
    \@Bottommargin=#4
    \InitLayout
}
\marginsize{.25in}{.25in}{.25in}{.25in}
\newcount\rownum \rownum=1        % These registers keep track of the row and
\newcount\colnum \colnum=0        % column of the quizboard
\newcount\corMsgnum \corMsgnum=0  % These registers keep track of the error
\newcount\errMsgnum \errMsgnum=0  % messages
\newcount\jb@n
\newcount\jb@m
\newtoks\jb@rowtoks
\newcounter{newletter}
\newdimen\cellHeight \cellHeight=1in
\newdimen\cellWidth  \cellWidth=.5in
\newdimen\tablewidth
\newdimen\tableheight
\newcount\numCategories \numCategories=5
\newcount\numQuestions  \numQuestions=5
\newdimen\rulewidth     \rulewidth=1bp
\newdimen\extraHeight   \extraHeight=.2in
\newdimen\extraWidth    \extraWidth=0pt
\def\calcPaperSize{%
    \tablewidth=\numCategories\cellWidth
    \advance\tablewidth by \rulewidth
    \advance\tablewidth by \numCategories\rulewidth
    \paperwidth=\tablewidth
    \advance\paperwidth by\@Leftmargin  % two times margin
    \advance\paperwidth by\@Rightmargin % two times margin
    \advance\paperwidth by2\extraWidth  % need more width
    \tableheight=\numQuestions\cellHeight
    \advance\tableheight by\cellHeight % banner
    \advance\tableheight by2\rulewidth % two rules for banner
    \advance\tableheight by\numQuestions\rulewidth
    \paperheight=\tableheight
    \advance\paperheight by\cellHeight % score
    \advance\paperheight by\@Topmargin
    \advance\paperheight by\@Bottommargin
    \advance\paperheight by\topskip
    \advance\paperheight by\extraHeight
    \screensize{\paperheight}{\paperwidth}
}
\def\verbatimwrite{\bgroup\catcode``=0 \@bsphack
  \let\do\@makeother\dospecials
  \catcode`\^^M\active \catcode`\^^I=12
  \def\verbatim@processline{%
    \immediate\write\verbatim@out
      {\the\verbatim@line}}%
  \verbatim@start}
\def\endverbatimwrite{\@esphack\egroup}
\newtoks\params \params={}
\newtoks\jb@tmptoks \jb@tmptoks={}
\def\@pickswitch#1#2\\{\def\argi{#1}\params={#2#1}}
\def\@parseParameters#1: #2,{\@ifnextchar\end
  {\jj@@parseParameters{#1}{#2}\@gobble}
  {\@ckforComma{#1}{#2}}
}
\def\@ckforComma#1#2{\@ifnextchar,
  {\jj@@parseParameters{#1}{#2}\@gobbletwo}
  {\jj@@parseParameters{#1}{#2}\setparams\@parseParameters}
}
\def\jj@@parseParameters#1#2{\let\next=\relax
  \expandafter\@pickswitch\the\params\\
  \def\jb@tmp{\end}
  \ifx\argi\jb@tmp
     \def\jb@tmp{\csname#2\endcsname}
     \def\jb@temp{\csname novalue\endcsname}
     \ifx\jb@temp\jb@tmp\else
        \message{^^J\expandafter\string\csname\processMacro\endcsname:
        The parameter pair '#1: #2' is undefined. Using the default value,
        if possible.^^J}
     \fi
  \else
     \jb@tmptoks=\expandafter{\csname\prefix#1\endcsname}%
     \edef\jb@tmp{\the\jb@tmptoks}%
     \ifx\jb@tmp\argi
        \csname @jb#1\endcsname{#2}%
     \else
        \def\next{\jj@@parseParameters{#1}{#2}}%
     \fi
  \fi
\next}
\def\jb@linkColor{\defaultLinkColor}

\def\jj@setChoice#1#2{% this choice, default
    \ifx#1\@empty#2\else#1\fi}
\def\jj@updateChoice#1#2{%  this choice, current choice
    \ifx#1\@empty\xdef#1{#2}\else\xdef#2{#1}\fi}
\def\DeclareColors#1{%
    \begingroup
    \def\processMacro{DeclareColors}
    \def\prefix{jb@}
    % Load parameters to test against
    \def\setparams{\params={\jb@fillCells\jb@fillBanner\jb@textBanner%
                            \jb@textBoard\jb@fillInstructions\jb@fillGameBoard%
                            \jb@fillQuestions\jb@dollarColor\jb@linkColor\end}}
    \setparams
    % define their default values /TiRo 20 Tf 0 0 1 rg
    \def\@jbfillCells##1{\gdef\jb@fillCells{##1}}\let\jb@fillCells\@empty
    \def\@jbfillBanner##1{\gdef\jb@fillBanner{##1}}\let\jb@fillBanner\@empty
    \def\@jbtextBanner##1{\gdef\jb@textBanner{##1}}\let\jb@textBanner\@empty
    \def\@jbtextBoard##1{\gdef\jb@textBoard{##1}}\let\jb@textBoard\@empty
    \def\@jbfillInstructions##1{\gdef\jb@fillInstructions{##1}}\let\jb@fillInstructions\@empty
    \def\@jbfillGameBoard##1{\gdef\jb@fillGameBoard{##1}}\let\jb@fillGameBoard\@empty
    \def\@jbfillQuestions##1{\gdef\jb@fillQuestions{##1}}\let\jb@fillQuestions\@empty
    \def\@jbdollarColor##1{\gdef\jb@dollarColor{##1}}\let\jb@dollarColor\@empty
    \def\@jblinkColor##1{\gdef\jb@linkColor{##1}}
    \ifx#1*\else
        % insert a dummy argument to avoid spurious space and ...
        %   parse the named parameters
        \@parseParameters dummy: novalue, #1,\end
    \fi
    \jj@updateChoice{\jb@fillCells}{\fillCells}%
    \jj@updateChoice{\jb@fillBanner}{\fillBanner}%
    \jj@updateChoice{\jb@textBanner}{\textBanner}%
    \jj@updateChoice{\jb@textBoard}{\textBoard}%
    \jj@updateChoice{\jb@fillInstructions}{\fillInstructions}%
    \jj@updateChoice{\jb@fillGameBoard}{\fillGameBoard}%
    \jj@updateChoice{\jb@fillQuestions}{\fillQuestions}%
    \jj@updateChoice{\jb@dollarColor}{\dollarColor}%
    % The macro that will actually set the values
    \xdef\fillCells{\jj@setChoice{\jb@fillCells}{\defaultfillCells}}%
    \xdef\fillBanner{\jj@setChoice{\jb@fillBanner}{\defaultfillBanner}}%
    \xdef\textBanner{\jj@setChoice{\jb@textBanner}{\defaulttextBanner}}%
    \xdef\textBoard{\jj@setChoice{\jb@textBoard}{\defaulttextBoard}}%
    \xdef\fillInstructions{\jj@setChoice{\jb@fillInstructions}{\defaultfillInstructions}}%
    \xdef\fillGameBoard{\jj@setChoice{\jb@fillGameBoard}{\defaultfillGameBoard}}%
    \xdef\fillQuestions{\jj@setChoice{\jb@fillQuestions}{\defaultfillQuestions}}%
    \xdef\dollarColor{\jj@setChoice{\jb@dollarColor}{\defaultDollarColorAmt}}%
    \xdef\@linkcolor{\jb@linkColor}%
    \endgroup
}
\let\fillCells\@empty
\let\fillBanner\@empty
\let\textBanner\@empty
\let\textBoard\@empty
\let\fillInstructions\@empty
\let\fillGameBoard\@empty
\let\fillQuestions\@empty
\let\dollarColor\@empty
\DeclareColors*
\def\APDollar#1{%
    \begingroup
    \def\processMacro{APDollar}
    \def\prefix{jb@}
    % Load parameters to test against
    \def\setparams{\params={\jb@Font\jb@Size\jb@TextColor%
                            \jb@BorderColor\jb@FillColor\end}}
    \setparams
    % define their default values /TiRo 20 Tf 0 0 1 rg
    \def\@jbFont##1{\def\jb@Font{##1}}\let\jb@Font\@empty                       %\@jbFont{TiRo}
    \def\@jbSize##1{\def\jb@Size{##1}}\let\jb@Size\@empty                       %\@jbSize{20}
    \def\@jbTextColor##1{\def\jb@TextColor{##1}}\let\jb@TextColor\@empty        %\@jbTextColor{0 0 1}
    \def\@jbBorderColor##1{\def\jb@BorderColor{##1}}\let\jb@BorderColor\@empty  %\@jbBorderColor{0 0 0}
    \def\@jbFillColor##1{\def\jb@FillColor{##1}}\let\jb@FillColor\@empty        %\@jbFillColor{1 0.35 1}
    \ifx#1*\else
        % insert a dummy argument to avoid spurious space and ...
        %   parse the named parameters
        \@parseParameters dummy: novalue, #1,\end
    \fi
    \jj@updateChoice{\jb@Font}{\APDollar@Font}%
    \jj@updateChoice{\jb@Size}{\APDollar@Size}%
    \jj@updateChoice{\jb@TextColor}{\APDollar@TextColor}%
    \jj@updateChoice{\jb@BorderColor}{\APDollar@BorderColor}%
    \jj@updateChoice{\jb@FillColor}{\APDollar@FillColor}%
    % The macro that will actually set the values
    \xdef\APD@llar{/\jj@setChoice{\jb@Font}{\APDollar@Font@def}%
    \space\jj@setChoice{\jb@Size}{\APDollar@Size@def}\space Tf \jj@setChoice{\jb@TextColor}{\APDollar@TextColor@def}\space rg}
    \ifx\jb@BorderColor\jj@transparent\gdef\APD@llarBorder{}\else
    \xdef\APD@llarBorder{\jj@setChoice{\jb@BorderColor}{\APDollar@BorderColor@def}}\fi
    \ifx\jb@FillColor\jj@transparent\gdef\APD@llarFill{}\else
    \xdef\APD@llarFill{\jj@setChoice{\jb@FillColor}{\APDollar@FillColor@def}}\fi
    \endgroup
}
\def\APDollar@Font@def{TiRo}
\def\APDollar@Size@def{20}
\def\APDollar@TextColor@def{0 0 1}
\def\APDollar@BorderColor@def{0 0 0}
\def\APDollar@FillColor@def{1 0.35 1}
\let\APDollar@Font\@empty
\let\APDollar@Size\@empty
\let\APDollar@TextColor\@empty
\let\APDollar@BorderColor\@empty
\let\APDollar@FillColor\@empty
\APDollar* %{Font: TiRo, Size: 20, TextColor: 0 0 1,
           %BorderColor: 0 0 0, FillColor: 1 .35 1}
\newcommand\EUR{%
{\sffamily C%
\makebox[0pt][l]{\kern-.70em\mbox{--}%
}%
\makebox[0pt][l]{\kern-.68em\raisebox{.25ex}{--}}}\,%
}
\def\APHidden#1{%
    \begingroup
    \def\processMacro{APHidden}
    \def\prefix{jb@}
    % Load parameters to test against
    \def\setparams{\params={\jb@Champion\jb@Font\jb@Size\jb@TextColor%
                            \jb@BorderColor\jb@FillColor\end}}
    \setparams
    % define their default values /TiRo 20 Tf 0 0 1 rg
    \def\@jbChampion##1{\gdef\jb@Champion{##1}}\let\jb@Champion\@empty              %\@jbChampion{You are a Champion!}
    \def\@jbFont##1{\def\jb@Font{##1}}\let\jb@Font\@empty                           %\@jbFont{TiRo}
    \def\@jbSize##1{\def\jb@Size{##1}}\let\jb@Size\@empty                           %\@jbSize{20}
    \def\@jbTextColor##1{\def\jb@TextColor{##1}}\let\jb@TextColor\@empty            %\@jbTextColor{0 0 1}
    \def\@jbBorderColor##1{\def\jb@BorderColor{##1}}\let\jb@BorderColor\@empty      %\@jbBorderColor{0 0 0}
    \def\@jbFillColor##1{\def\jb@FillColor{##1}}\let\jb@FillColor\@empty            %\@jbFillColor{0.98 0.92 0.73}
    \ifx#1*\else
        % insert a dummy argument to avoid spurious space and ...
        %   parse the named parameters
        \@parseParameters dummy: novalue, #1,\end
    \fi
    \jj@updateChoice{\jb@Font}{\APHidden@Font}%
    \jj@updateChoice{\jb@Size}{\APHidden@Size}%
    \jj@updateChoice{\jb@TextColor}{\APHidden@TextColor}%
    \jj@updateChoice{\jb@BorderColor}{\APHidden@BorderColor}%
    \jj@updateChoice{\jb@FillColor}{\APHidden@FillColor}%
    % The macro that will actually set the values
    \xdef\APHidd@n{/\jj@setChoice{\jb@Font}{\APHidden@Font@def}%
    \space\jj@setChoice{\jb@Size}{\APHidden@Size@def}\space Tf \jj@setChoice{\jb@TextColor}{\APHidden@TextColor@def}\space rg}
    \ifx\jb@BorderColor\jj@transparent\gdef\APHidd@nBorder{}\else
    \xdef\APHidd@nBorder{\jj@setChoice{\jb@BorderColor}{\APHidden@BorderColor@def}}\fi
    \ifx\jb@FillColor\jj@transparent\gdef\APHidd@nFill{}\else
    \xdef\APHidd@nFill{\jj@setChoice{\jb@FillColor}{\APHidden@FillColor}}\fi
    \endgroup
}
\def\APHidden@Font@def{TiRo}
\def\APHidden@Size@def{20}
\def\APHidden@TextColor@def{0 0 1}
\def\APHidden@BorderColor@def{0 0 0}
\def\APHidden@FillColor@def{0.98 0.92 0.73}
\let\APHidden@Font\@empty
\let\APHidden@Size\@empty
\let\APHidden@TextColor\@empty
\let\APHidden@BorderColor\@empty
\let\APHidden@FillColor\@empty
\APHidden* %{Champion: You are a Champion!, Font: TiRo, Size: 20,
           %TextColor: 0 0 1, BorderColor: 0 0 0, FillColor: 0.98 0.92 0.73}
\def\APRight#1{%
    \begingroup
    \def\processMacro{APRight}
    \def\prefix{jb@}
    % Load parameters to test against
    \def\setparams{\params={\jb@Font\jb@Size\jb@TextColor\jb@Message\end}}
    \setparams
    % define their default values /TiRo 20 Tf 0 0 1 rg
    \def\@jbFont##1{\def\jb@Font{##1}}\let\jb@Font\@empty                   %\@jbFont{TiRo}
    \def\@jbSize##1{\def\jb@Size{##1}}\let\jb@Size\@empty                   %\@jbSize{20}
    \def\@jbTextColor##1{\def\jb@TextColor{##1}}\let\jb@TextColor\@empty    %\@jbTextColor{0 0 1}
    \def\@jbMessage##1{\def\jb@Message{##1}}\let\jb@Message\@empty          %\@jbMessage{}
    \ifx#1*\else
        % insert a dummy argument to avoid spurious space and ...
        %   parse the named parameters
        \@parseParameters dummy: novalue, #1,\end
    \fi
    \jj@updateChoice{\jb@Font}{\APRight@Font}%
    \jj@updateChoice{\jb@Size}{\APRight@Size}%
    \jj@updateChoice{\jb@TextColor}{\APRight@TextColor}%
    \jj@updateChoice{\jb@Message}{\@APRightMsg}
    % The macro that will actually set the values
    \xdef\@APRight{/\jj@setChoice{\jb@Font}{\APRight@Font@def}%
    \space\jj@setChoice{\jb@Size}{\APRight@Size@def}\space Tf \jj@setChoice{\jb@TextColor}{\APRight@TextColor@def}\space rg}%
    \xdef\@APRightTextColor{\jj@setChoice{\jb@TextColor}{\APRight@TextColor@def}}%
    \xdef\@APRightMsg{\jj@setChoice{\jb@Message}{\@APRightMsg}}%
    \endgroup
}
\def\APRight@Font@def{TiRo}
\def\APRight@Size@def{20}
\def\APRight@TextColor@def{0 0 1}
\def\APRRight@Msg@def{Right!}
\let\APRight@Font\@empty
\let\APRight@Size\@empty
\let\APRight@TextColor\@empty
\def\correctText#1{\gdef\@APRightMsg{#1}}
\correctText{Right!}
\APRight*  %{Font: TiRo, Size: 20, TextColor: 0 0 1, Message: Right!}
\def\APWrong#1{%
    \begingroup
    \def\processMacro{APWrong}
    \def\prefix{jb@}
    % Load parameters to test against
    \def\setparams{\params={\jb@Font\jb@Size\jb@TextColor\jb@Message\end}}
    \setparams
    % define their default values /TiRo 20 Tf 0 0 1 rg
    \def\@jbFont##1{\def\jb@Font{##1}}\let\jb@Font\@empty                   %\@jbFont{TiRo}
    \def\@jbSize##1{\def\jb@Size{##1}}\let\jb@Size\@empty                   %\@jbSize{20}
    \def\@jbTextColor##1{\def\jb@TextColor{##1}}\let\jb@TextColor\@empty    %\@jbTextColor{1 0 0}
    \def\@jbMessage##1{\def\jb@Message{##1}}\let\jb@Message\@empty         %\@jbMessage{}
    \ifx#1*\else
        % insert a dummy argument to avoid spurious space and ...
        %   parse the named parameters
        \@parseParameters dummy: novalue, #1,\end
    \fi
    \jj@updateChoice{\jb@Font}{\APWrong@Font}%
    \jj@updateChoice{\jb@Size}{\APWrong@Size}%
    \jj@updateChoice{\jb@TextColor}{\APWrong@TextColor}%
    \jj@updateChoice{\jb@Message}{\@APWrongMsg}
    % The macro that will actually set the values
    \xdef\@APWrong{/\jj@setChoice{\jb@Font}{\APWrong@Font@def}%
    \space\jj@setChoice{\jb@Size}{\APWrong@Size@def}\space Tf \jj@setChoice{\jb@TextColor}{\APWrong@TextColor@def}\space rg}%
    \xdef\@APWrongTextColor{\jj@setChoice{\jb@TextColor}{\APWrong@TextColor@def}}%
    \xdef\@APWrongMsg{\jj@setChoice{\jb@Message}{\@APWrongMsg}}%
    \endgroup
}
\def\APWrong@Font@def{TiRo}
\def\APWrong@Size@def{20}
\def\APWrong@TextColor@def{0 0 1}
\def\APRRight@Msg@def{Wrong!}
\let\APWrong@Font\@empty
\let\APWrong@Size\@empty
\let\APWrong@TextColor\@empty
\def\incorrectText#1{\gdef\@APWrongMsg{#1}}
\incorrectText{Wrong!}
\APWrong* %{Font: TiRo, Size: 20, TextColor: 1 0 0, Message: Wrong!}
\def\GameDesign#1{%
    \begingroup
    \def\processMacro{CustomDesign}
    \def\prefix{jb@}
    % Load parameters to test against
    \global\numCategories = 0
    \def\setparams{\params={\jb@Cat\jb@CellWidth\jb@CellHeight%
    \jb@NumQuestions\jb@Goal\jb@GoalPercentage\jb@ExtraHeight\jb@ExtraWidth%
    \jb@Champion\end}}
    \setparams
    % define their default values
    \def\@jbCat##1{\global\advance\numCategories by1 \jb@Cat##1,}
    \def\@jbCellWidth##1{\global\cellWidth=##1}\@jbCellWidth{1in}
    \def\@jbCellHeight##1{\global\cellHeight=##1}\@jbCellHeight{.5in}
    \def\@jbNumQuestions##1{\global\numQuestions=##1}\@jbNumQuestions{5}
    \def\@jbGoal##1{\def\jb@Goal{##1}}\@jbGoal{3500}
    \def\@jbGoalPercentage##1{\def\jb@GoalPercentage{##1}}\@jbGoalPercentage{0}
    \def\@jbExtraHeight##1{\global\extraHeight=##1}\@jbExtraHeight{.2in}
    \def\@jbExtraWidth##1{\global\extraWidth=##1}\@jbExtraWidth{0pt}
    \def\@jbChampion##1{\gdef\jb@Champion{##1}}\@jbChampion{You are a Champion!}
    % The * argument is used to initialize all variables executing the
    % \parseParameters macro
    \ifx#1*\else
        % insert a dummy argument to avoid spurious space
        \@parseParameters dummy: novalue, #1,\end
        \ifdebug
            \typeout{^^JClass jj_game Info:}
            \typeout{Number of Categories: \the\numCategories}
            \typeout{Number of Questions per Category: \the\numQuestions^^J}
        \fi
        \jb@n = \numQuestions
        \advance\jb@n by 1
        \multiply\jb@n by\numQuestions
        \multiply\jb@n by50                 % total money/category
        \multiply\jb@n by\numCategories     % total money
        \ifdouble
            \multiply\jb@n by2              % total money, double jj
        \fi
        \ifdebug
            \typeout{Total Money: \the\jb@n}
        \fi
        % See if GoalPercentage differs from the default value
        \xdef\jb@tmp{\csname 0\endcsname}%
        \xdef\jb@temp{\csname\jb@GoalPercentage\endcsname}%
        \ifx\jb@tmp\jb@temp
        \else
            \ifdebug
                \typeout{Goal Percentage Specified: \jb@GoalPercentage}
            \fi
            \multiply\jb@n by\jb@GoalPercentage
            \divide\jb@n by100
            \@jbGoal{\the\jb@n}
        \fi
        \xdef\Goal{\jb@Goal}
        \ifdebug
            \typeout{Goal: \Goal^^J}
        \fi
    \fi
    \endgroup
    \ifx#1*\else\expandafter\calcPaperSize\fi
    \jjCancelOutAeBProCatalog
    \jjImportForCreditCode
}
\def\jjCancelOutAeBProCatalog{\iffinal\let\aeb@SetCatalog\@empty\fi}
\def\jb@Cat{%
\@ifnextchar[{\jb@item}{\jb@item[] }}%
\gdef\jb@item[#1] #2,{%
\expandafter\gdef\csname Category\the\numCategories\endcsname{\forpbx{#1#2}}%
\expandafter\gdef\csname category\the\numCategories\endcsname{#2}}%

\GameDesign*  %{CellWidth: 1in, CellHeight: .5in, NumQuestions: 5,
               %Goal: 3500, ExtraHeight: .2in, ExtraWidth: 0pt
               %Champion: You are a Champion!}
\def\jb@Score{""}
\def\jb@align@left{l}
\def\jb@align@center{c}
\def\jb@align@right{r}
\def\APScore#1{
    \begingroup
    \def\processMacro{APScore}
    \def\prefix{jb@}
    % Load parameters to test against
    \def\setparams{\params={\jb@Font\jb@Size\jb@TextColor%
                            \jb@BorderColor\jb@FillColor%
                            \jb@CellWidth\jb@CellHeight%
                            \jb@AutoPlacement\jb@Score\jb@Currency\jb@align\end}}
    \setparams
    % define their default values /TiRo 20 Tf 0 0 1 rg
    \def\@jbFont##1{\def\jb@Font{##1}}\let\jb@Font\@empty                               %\@jbFont{TiRo}
    \def\@jbSize##1{\def\jb@Size{##1}}\let\jb@Size\@empty                               %\@jbSize{20}
    \def\@jbTextColor##1{\def\jb@TextColor{##1}}\let\jb@TextColor\@empty                %\@jbTextColor{0 0 1}
    \def\@jbBorderColor##1{\def\jb@BorderColor{##1}}\let\jb@BorderColor\@empty          %\@jbBorderColor{0 0 0}
    \def\@jbFillColor##1{\def\jb@FillColor{##1}}\let\jb@FillColor\@empty                %\@jbFillColor{0.98 0.92 0.73}
    \def\@jbCellHeight##1{\def\jb@CellHeight{##1}}\let\jb@CellHeight\@empty             %\@jbCellHeight{\the\cellHeight}
    \def\@jbCellWidth##1{\def\jb@CellWidth{##1}}\let\jb@CellWidth\@empty                %\@jbCellWidth{\the\cellWidth}
    \def\@jbAutoPlacement##1{\gdef\jb@AutoPlacement{##1}}\let\jb@AutoPlacement\@empty   %\@jbAutoPlacement{true}
    \def\@jbScore##1{\gdef\jb@Score{##1}}\let\jb@Score\@empty                           %\@jbScore{""}
    \def\@jbCurrency##1{\gdef\jb@Currency{##1}}\let\jb@Currency\@empty                  %\@jbCurrency{"$"}
    \def\@jbalign##1{\gdef\jb@align{##1}}\let\jb@aligh\@empty                           %\@jbalign{r}%  l, c, r
    \ifx#1*\else
        % insert a dummy argument to avoid spurious space and ...
        %   parse the named parameters
        \@parseParameters dummy: novalue, #1,\end
    \fi
    \jj@updateChoice{\jb@Font}{\APScore@Font}%
    \jj@updateChoice{\jb@Size}{\APScore@Size}%
    \jj@updateChoice{\jb@TextColor}{\APScore@TextColor}%
    \jj@updateChoice{\jb@BorderColor}{\APScore@BorderColor}%
    \jj@updateChoice{\jb@FillColor}{\APScore@FillColor}%
    \jj@updateChoice{\jb@CellHeight}{\APScore@CellHeight}%
    \jj@updateChoice{\jb@CellWidth}{\APScore@CellWidth}%
    \jj@updateChoice{\jb@AutoPlacement}{\APScore@AutoPlacement}%
    \jj@updateChoice{\jb@Score}{\APScore@Score}%
    \jj@updateChoice{\jb@Currency}{\APScore@Currency}%
    \jj@updateChoice{\jb@align}{\APScore@align}%
    \xdef\jb@Score{\jj@setChoice{\jb@Score}{\APScore@Score@def}}%
    \xdef\jb@Currency{\jj@setChoice{\jb@Currency}{\APScore@Currency@def}}%
    % The macro that will actually set the values
    \xdef\@APScore{/\jj@setChoice{\jb@Font}{\APScore@Font@def}%
    \space\jj@setChoice{\jb@Size}{\APScore@Size@def}\space Tf \jj@setChoice{\jb@TextColor}{\APScore@TextColor@def}\space rg}%
    \ifx\jb@BorderColor\jj@transparent\gdef\@APScoreBorder{}\else
    \xdef\@APScoreBorder{\jj@setChoice{\jb@BorderColor}{\APScore@BorderColor@def}}\fi
    \ifx\jb@FillColor\jj@transparent\gdef\@APScoreFill{}\else
    \xdef\@APScoreFill{\jj@setChoice{\jb@FillColor}{\APScore@FillColor@def}}\fi
    \xdef\@APScorecellHeight{\jj@setChoice{\jb@CellHeight}{\APScore@CellHeight@def}}
    \xdef\@APScorecellWidth{\jj@setChoice{\jb@CellWidth}{\APScore@CellWidth@def}}
    \xdef\jb@align{\jj@setChoice{\jb@align}{\APScore@align@def}}
    \xdef\jb@tmp{\csname true\endcsname}%
    \xdef\jb@temp{\csname\jb@AutoPlacement\endcsname}%
    \ifx\jb@temp\jb@tmp
          \gdef\@PlaceScoreBoard{\@@PlaceScoreBoard}
          \gdef\PlaceScoreBoard##1{\message{^^J\expandafter\string\csname APScore\endcsname:
            `AutoPlacement: true', the use of \string\PlaceScoreBoard\space is not valid
            in this case!^^J^^J}}
    \else
          \gdef\@PlaceScoreBoard{\@@@PlaceScoreBoard\@gobble}%
    \fi
    \gdef\jb@Quad{2}
    \ifx\jb@align\jb@align@left\gdef\jb@Quad{0}
    \else\ifx\jb@align\jb@align@center\gdef\jb@Quad{1}
    \else\ifx\jb@align\jb@align@right\gdef\jb@Quad{2}
    \fi\fi\fi
    \endgroup
}
\def\@@PlaceScoreBoard#1{#1}
\long\def\PlaceScoreBoard#1{\def\@@@PlaceScoreBoard{#1}}
\PlaceScoreBoard{{\centering\vbox{\ScoreBoard}}}
\def\jb@align{r}
\def\APScore@Font@def{TiRo}
\def\APScore@Size@def{20}
\def\APScore@TextColor@def{0 0 1}
\def\APScore@BorderColor@def{0 0 0}
\def\APScore@FillColor@def{0.98 0.92 0.73}
\def\APScore@CellHeight@def{\the\cellHeight}
\def\APScore@CellWidth@def{\the\cellWidth}
\def\APScore@AutoPlacement@def{true}
\def\APScore@Score@def{""}
\def\APScore@Currency@def{""}
\def\APScore@align@def{r}
\let\APScore@Font\@empty
\let\APScore@Size\@empty
\let\APScore@TextColor\@empty
\let\APScore@BorderColor\@empty
\let\APScore@FillColor\@empty
\let\APScore@CellHeight\@empty
\let\APScore@CellWidth\@empty
\let\APScore@AutoPlacement\@empty
\let\APScore@Score\@empty
\let\APScore@Currency\@empty
\let\APScore@align\@empty
\APScore* %{Font: TiRo, Size: 20, TextColor: 0 0 1, BorderColor: 0 0 0,
          %FillColor: 0.98 0.92 0.73, CellHeight: \the\cellHeight,
          %CellWidth: \the\cellWidth, AutoPlacement: true,
          %Score: "Score: ", Currency: "$", align: r}
\def\Rect#1{\pdf@rect{\textcolor{\@linkcolor}{#1}}}
\def\({\noexpand\(}\def\){\noexpand\)} %\def\r{\noexpand\r}\def\n{\noexpand\n}
\def\Bbox#1#2{\vbox to#2{\hbox to#1{\hfill}\vfill}}
\def\hmark#1{\hypertarget{#1}{}}
\newcommand{\bannerTextControl}[1]{#1}
\def\jb@Banner#1{\vspace*{-\topskip}\hbox{\rlap{\ifx\fillBanner\jj@transparent\else\color{\fillBanner}\fi
\setbox0=\hbox{\bannerTextFont\strut}\jb@tmpdimb=\ht0
  \advance\jb@tmpdimb by6pt \jb@tmpdima=\dp0 \advance\jb@tmpdima by4pt
    {\ifx\fillBanner\jj@transparent\else\vrule height\jb@tmpdimb depth\jb@tmpdima width\textwidth\fi}}%
    \vbox{\noindent\centering\bannerTextFont\bannerTextColor\strut\bannerTextControl{#1}}}\bigskip}
\def\dollarAP{%
{\ifdouble\advance\rownum by\rownum\fi\xdef\@dollarAmt{\the\rownum00}}%
\ifcase\thejjgdriver
\rlap{\pdfstartlink user{ /Subtype /Widget
  /F 4 /T (\the\rownum\the\colnum)
  /FT /Btn /Ff 65540 /H /P /BS << /W 1 /S /S >>
  /DA (\APD@llar)
  /MK << /BC [\APD@llarBorder]\space %/BC [0.75 0.75 0.75]
         /BG [\APD@llarFill]\space
         /CA (\@dollarAmt)\space
         /AC (\@dollarAmt)\space
      >>
   /A << /Type /Action /S /GoTo /D (Q\the\rownum\the\colnum) \jjAdditionalCellJSActions >> }%
\Bbox{\cellWidth}{\cellHeight}\pdfendlink}%
\or
\rlap{\pdf@rect{\Bbox{\cellWidth}{\cellHeight}}}%
\literalps@out{%
[ /Subtype /Widget
  /Rect [pdf@llx pdf@lly pdf@urx pdf@ury]
  /F 4 /T (\the\rownum\the\colnum)
  /FT /Btn /Ff 65540 /H /P /BS << /W 1 /S /S >>
  /DA (\APD@llar)
  /MK << /BC [\APD@llarBorder]\space %/BC [0.75 0.75 0.75]
         /BG [\APD@llarFill]\space
         /CA (\@dollarAmt)\space
         /AC (\@dollarAmt)\space
      >>
   /A << /Type /Action /S /GoTo /D (Q\the\rownum\the\colnum) \jjAdditionalCellJSActions >>
/ANN pdfmark}%
\or
\setbox\pdfm@box=\hbox{\Bbox{\cellWidth}{\cellHeight}}%
\def\Fld@name{\the\rownum\the\colnum}%
\@pdfm@mark{ann @\Fld@name\space\dvipdfm@setdim
<<
    /Subtype /Widget
    /F 4 /T (\the\rownum\the\colnum)
    /FT /Btn /Ff 65540 /H /P /BS << /W 1 /S /S >>
    /DA (\APD@llar)
    /MK << /BC [\APD@llarBorder]\space %/BC [0.75 0.75 0.75]
         /BG [\APD@llarFill]\space
         /CA (\@dollarAmt)\space
         /AC (\@dollarAmt)\space
      >>
   /A << /Type /Action /S /GoTo /D (Q\the\rownum\the\colnum) \jjAdditionalCellJSActions >>
>>}\rlap{\unhbox\pdfm@box\relax}%
\@pdfm@mark{put @afields @\Fld@name}% record in @afields array
\fi
}%
\def\rightAP{%
\ifcase\thejjgdriver
\rlap{\pdfstartlink user{/Subtype /Widget
  /F 6 /T (\the\rownum\the\colnum R) % /F 6 : hidden and printable
  /FT /Btn /Ff 65540 /H /N
  /DA (\@APRight) /MK << /CA (\@APRightMsg) >> }%
\Bbox{\cellWidth}{\cellHeight}\pdfendlink}%
\or
\literalps@out{%
[ /Subtype /Widget /Rect [pdf@llx pdf@lly pdf@urx pdf@ury]
  /F 6 /T (\the\rownum\the\colnum R) % /F 6 : hidden and printable
  /FT /Btn /Ff 65540 /H /N
  /DA (\@APRight) /MK << /CA (\@APRightMsg) >>
/ANN pdfmark}%
\or
\setbox\pdfm@box=\hbox{\Bbox{\cellWidth}{\cellHeight}}%
\def\Fld@name{\the\rownum\the\colnum R}%
\hbox{\@pdfm@mark{ann @\Fld@name\space\dvipdfm@setdim
<<
  /Subtype /Widget
  /F 6 /T (\the\rownum\the\colnum R) % /F 6 : hidden and printable
  /FT /Btn /Ff 65540 /H /N
  /DA (\@APRight) /MK << /CA (\@APRightMsg) >>
>>}}\@pdfm@mark{put @afields @\Fld@name}% record in @afields array%
\fi}%
\def\wrongAP{%
\ifcase\thejjgdriver
\rlap{\pdfstartlink user{/Subtype /Widget
  /F 6 /T (\the\rownum\the\colnum W) % /F 6 : hidden and printable
  /FT /Btn /Ff 65540 /H /N
  /DA (\@APWrong) /MK << /CA (\@APWrongMsg) >> }%
\Bbox{\cellWidth}{\cellHeight}\pdfendlink}%
\or
\literalps@out{%
[ /Subtype /Widget /Rect [pdf@llx pdf@lly pdf@urx pdf@ury]
  /F 6 /T (\the\rownum\the\colnum W) % /F 6 : hidden and printable
  /FT /Btn /Ff 65540 /H /N
  /DA (\@APWrong) /MK << /CA (\@APWrongMsg) >>
/ANN pdfmark}%
\or
\setbox\pdfm@box=\hbox{\Bbox{\cellWidth}{\cellHeight}}%
\def\Fld@name{\the\rownum\the\colnum W}%
\hbox{\@pdfm@mark{ann @\Fld@name\space\dvipdfm@setdim
<<
  /Subtype /Widget
  /F 6 /T (\the\rownum\the\colnum W) % /F 6 : hidden and printable
  /FT /Btn /Ff 65540 /H /N
  /DA (\@APWrong) /MK << /CA (\@APWrongMsg) >>
>>}}\@pdfm@mark{put @afields @\Fld@name}% record in @afields array%
\fi}
\def\jb@nDec{0}
\def\jb@sepStyle{0}
\def\jb@negStyle{0}
\def\jb@currStyle{2}
\def\jb@Currency{""}
\def\jb@bCurrencyPrepend{true}
\newcommand{\prependCurrency}{\def\jb@bCurrencyPrepend{true}}
\newcommand{\appendCurrency}{\def\jb@bCurrencyPrepend{false}}
\def\ScoreBoard{%
\ifcase\thejjgdriver
\leavevmode\pdfstartlink user{/Subtype /Widget
  /T (Total)
  /FT /Tx /Ff 1 /H /N /F 4 /Q \jb@Quad
  /BS << /W 3 /S /I >>
  /MK << /BC [\@APScoreBorder] /BG [\@APScoreFill] >>
  /DA (\@APScore)
  /AA << /V << /S /JavaScript
                  /JS(event.target.textColor = event.value < 0 ?
                        "RGB \@APWrongTextColor".split(" ") :
                        "RGB \@APRightTextColor".split(" ");) >>
         /F << /S /JavaScript
                  /JS (AFNumber_Format\(\jb@nDec, \jb@sepStyle, \jb@negStyle, \jb@currStyle, \jb@Currency, \jb@bCurrencyPrepend\);
                       event.value = \jb@Score\space + event.value;) >>
      >> }%
\lower4bp\Bbox{\@APScorecellWidth}{\@APScorecellHeight}\pdfendlink
\or
\pdf@rect{\lower4bp\Bbox{\@APScorecellWidth}{\@APScorecellHeight}}%
\literalps@out{%
[ /Subtype /Widget /Rect [pdf@llx pdf@lly pdf@urx pdf@ury]
  /T (Total)
  /FT /Tx /Ff 1 /H /N /F 4 /Q \jb@Quad
  /BS << /W 3 /S /I >>
  /MK << /BC [\@APScoreBorder] /BG [\@APScoreFill] >> %0.98 0.92 0.73
  /DA (\@APScore)
  /AA << /V << /S /JavaScript
                  /JS(event.target.textColor = event.value < 0 ?
                        "RGB \@APWrongTextColor".split(" ") :
                        "RGB \@APRightTextColor".split(" ");) >>
         /F << /S /JavaScript
                  /JS (AFNumber_Format\(\jb@nDec, \jb@sepStyle, \jb@negStyle, \jb@currStyle, \jb@Currency, \jb@bCurrencyPrepend\);
                       event.value = \jb@Score\space + event.value;) >>
      >>
/ANN pdfmark}%
\or
\setbox\pdfm@box=\hbox{\lower4pt\Bbox{\@APScorecellWidth}{\@APScorecellHeight}}%
\def\Fld@name{Total}%
\leavevmode\@pdfm@mark{ann @\Fld@name\space\dvipdfm@setdim
<<
  /Subtype /Widget
  /T (Total)
  /FT /Tx /Ff 1 /H /N /F 4 /Q \jb@Quad
  /BS << /W 3 /S /I >>
  /MK << /BC [\@APScoreBorder] /BG [\@APScoreFill] >>
  /DA (\@APScore)
  /AA << /V << /S /JavaScript
                  /JS(event.target.textColor = event.value < 0 ?
                        "RGB \@APWrongTextColor".split(" ") :
                        "RGB \@APRightTextColor".split(" ");) >>
         /F << /S /JavaScript
                  /JS (AFNumber_Format\(\jb@nDec, \jb@sepStyle, \jb@negStyle, \jb@currStyle, \jb@Currency, \jb@bCurrencyPrepend\);
                       event.value = \jb@Score\space + event.value;) >>
      >>
>>}\unhbox\pdfm@box\relax %\raisebox{-4bp}{\unhbox\pdfm@box\relax}%
\@pdfm@mark{put @afields @\Fld@name}% record in @afields array
\fi}
\def\cell{\global\advance\colnum1 \ifnum\colnum>\numCategories
    \global\colnum=1 \global\advance\rownum1 \fi
    \moveleft.5\cellWidth\hbox{\dollarAP\rightAP\wrongAP}}
\def\bgb{\PoohBahBanner\smash{\rlap{\ifx\fillBanner\jj@transparent\else\color{\fillBanner}{%
  \vrule width\tablewidth height\cellHeight}\fi}}}
\def\bgc{\smash{\rlap{{\ifx\fillCells\jj@transparent\else\color{\fillCells}%
  \vrule width\tablewidth height\cellHeight\fi}}}}
\def\PoohBahBanner{%
\ifcase\thejjgdriver
\rlap{\advance\tablewidth-2bp\hskip1bp\pdfstartlink user{%
  /Subtype /Widget
  /T (GrandPoohbah)
  /FT /Tx /Ff 1 /H /N /Q 1 /F 6
  /BS << /W 3 /S /I >>
  /MK << /BC [\APHidd@nBorder] /BG [\APHidd@nFill] >>
  /DA (\APHidd@n)
  /DV (\jb@Champion)
  /V  (\jb@Champion)}%
\Bbox{\tablewidth}{\cellHeight}\pdfendlink}%\hskip1bp
\or
\smash{\advance\tablewidth-2bp
\rlap{\hskip1bp\pdf@rect{\Bbox{\tablewidth}{\cellHeight}}%
\literalps@out{%
[ /Subtype /Widget /Rect [pdf@llx pdf@lly pdf@urx pdf@ury]
  /T (GrandPoohbah)
  /FT /Tx /Ff 1 /H /N /Q 1 /F 6
  /BS << /W 3 /S /I >>
  /MK << /BC [\APHidd@nBorder] /BG [\APHidd@nFill] >>
  /DA (\APHidd@n)
  /DV (\jb@Champion)
  /V  (\jb@Champion)
/ANN pdfmark}}}%
\or
\setbox\pdfm@box=\hbox{\Bbox{\tablewidth}{\cellHeight}}%
\def\Fld@name{GrandPoohbah}%
\hbox{\@pdfm@mark{ann @\Fld@name\space\dvipdfm@setdim
<<
  /Subtype /Widget
  /T (GrandPoohbah)
  /FT /Tx /Ff 1 /H /N /Q 1 /F 6
  /BS << /W 3 /S /I >>
  /MK << /BC [\APHidd@nBorder] /BG [\APHidd@nFill] >>
  /DA (\APHidd@n)
  /DV (\jb@Champion)
  /V  (\jb@Champion)
>>}\rlap{\hskip1bp\unhbox\pdfm@box}}%
\@pdfm@mark{put @afields @\Fld@name}% record in @afields array
\fi}
\def\forpbx#1{\vbox to\cellHeight{%
  \hsize=\cellWidth\centering\vfill\strut\ifx\textBoard\jj@transparent\else\color{\textBoard}\fi#1\strut\vfill}}
\def\gameCategories{%
  \jb@n=0
  \jb@rowtoks={\bgb}%
  \loop\ifnum\jb@n<\numCategories\advance\jb@n by1
    \jb@tmptoks=\expandafter{\expandafter&\csname Category\the\jb@n\endcsname&}%
    \edef\jb@temp{\the\jb@rowtoks\the\jb@tmptoks}%
    \jb@rowtoks=\expandafter{\jb@temp}%
  \repeat
  \edef\jb@temp{\the\jb@rowtoks}%
  \jb@rowtoks=\expandafter{\jb@temp\cr\\ }%
\the\jb@rowtoks}

\long\def\oloop #1\orepeat{%
  \def\oiterate{#1\relax  % Extra \relax
               \expandafter\oiterate\fi
               }%
  \oiterate
  \let\outeriterate\relax
}
\let\orepeat=\fi
\def\gamebody{%
  \jb@rowtoks={}%
  \jb@m=\numQuestions
  \edef\jb@temp{}%
  \oloop\advance\jb@m-1\ifnum\jb@m>0
    \getrow
  \orepeat
  \the\jb@rowtoks}
\def\getrow{%
  \jb@n=\numCategories
  \edef\jb@temp{\the\jb@rowtoks}%
  \jb@rowtoks=\expandafter{\jb@temp\bgc}%
  \loop\advance\jb@n-1\ifnum\jb@n>0
    \edef\jb@temp{\the\jb@rowtoks}%
    \jb@rowtoks=\expandafter{\jb@temp&\cell&}%
  \repeat
  \edef\jb@temp{\the\jb@rowtoks}%
  \jb@rowtoks=\expandafter{\jb@temp\cr\\ }%
}
\def\GameBoard{\vspace*{-\topskip}%
\begingroup
  % set up \halign environment
  \tabskip0pt\offinterlineskip\parskip0pt\parindent0pt
  \def\\{\noalign{\hrule height\rulewidth}}%
  \hbox to\textwidth\bgroup\hfill
    \vbox\bgroup\hsize=\tablewidth\hmark{GameBoard}%
      \halign{##\vrule width\rulewidth
        &&\hbox to\cellWidth{\hss\vbox to\cellHeight{\vss##\vss}\hss}%
        &\vrule width\rulewidth##\cr\noalign{\hrule height\rulewidth}%
        % Begin entering data into the different cells
        \gameCategories
        \gamebody
      }%
    \egroup\hfill
  \egroup
\endgroup
\@PlaceScoreBoard{{\centering\vbox{\ScoreBoard}}}%
\par\JJ@afterGameBoardInsertion}
\let\JJ@afterGameBoardInsertion\@empty
\newcommand{\afterGameBoardInsertion}[1]{%
    \def\JJ@afterGameBoardInsertion{#1}}
\def\instructions
{%
    \instructionPageTemplate
    \ifx\fillInstructions\jj@transparent\else\textBgColor{\fillInstructions}\fi
    \jb@Banner{\@titleBanner}\par\parskip6pt
}
\def\endinstructions{\newpage}
\let\Question\relax
\def\Questions{\newpage\parskip0pt\relax\global\jb@n=0\relax
  \gameboardPageTemplate
  \ifx\fillGameBoard\jj@transparent\else\textBgColor{\fillGameBoard}\fi\GameBoard
  \newpage\ifx\fillQuestions\jj@transparent\else\textBgColor{\fillQuestions}\fi
  \rownum=0 \colnum=1 % initialize counters
  \questionPagesTemplate
}
\def\endQuestions{%
    \ifnum\jb@n=\numCategories\else
        \typeout{Number of categories is not correct!}
    \fi
    \newpage}
\def\Category#1{
    \def\currentCategory{#1}\global\advance\jb@n by1 \global\jb@m=0
    \ifdebug
    \typeout{^^JBegin Processing Category \the\jb@n: \currentCategory}
    \typeout{If '\currentCategory' is different from}
    \typeout{'\csname category\the\jb@n\endcsname',
            then your categories are out of order!}
    \fi}
\def\endCategory{
    \ifdebug
        \ifnum\jb@m=\numQuestions
        \else
            \typeout{In the '\currentCategory' category,
            the number of questions is not correct!}
        \fi
        \typeout{End Processing Category \the\jb@n:
        \the\jb@m\space of \the\numQuestions\space Questions}
    \fi
}
\let\jjAdditionalJSActions\@empty
\def\jjAdditionalCellJSActions{/Next <<\JS{var pushCell\the\rownum\the\colnum = true; makeNameReadOnly();}>>}
\let\bJJGInsertLayer\@empty
\let\eJJGInsertLayer\@empty
\def\theCurrencyAmt{{\count0=\the\rownum00\relax
    \multiply\count0by\scaleFactor\relax\the\count0\relax}}
\def\aboveCurrencySkip#1{\def\jj@aboveCurrencySkip{#1}}
\aboveCurrencySkip{0pt}
\newcommand{\currencyHeading}[1]{\def\jj@currencyHeading{#1}}
\currencyHeading{\bfseries For~\$\theCurrencyAmt:}
\def\Question{\newpage\global\advance\jb@m by1
  \global\advance\rownum1 \ifnum\rownum>\numQuestions \global\rownum=1
  \global\advance\colnum1 \fi
  \global\advance\corMsgnum1 \ifnum\corMsgnum=8 \global\corMsgnum=1 \fi
  \ifcase\thejjgdriver
    \immediate\pdfobj{<< /O << /H true /S /Hide /T (\the\rownum\the\colnum) \jjAdditionalJSActions >> >> }
    \edef\ThisPage{/AA \the\pdflastobj\space 0 R}
    \global\pdfpageattr=\expandafter{\ThisPage}%
  \or
    \literalps@out{%
         [ {ThisPage} << /AA << /O << /H true /S /Hide
            /T (\the\rownum\the\colnum) \jjAdditionalJSActions >> >> >>
        /PUT pdfmark}%
  \or
    \@pdfm@mark{put @thispage << /AA << /O << /H true /S /Hide
           /T (\the\rownum\the\colnum) \jjAdditionalJSActions >> >> >>}%
  \fi
  \jb@Banner{\csname category\the\colnum\endcsname}%
  \begingroup
  \vskip\jj@aboveCurrencySkip
  \parskip2pt
  \setcounter{newletter}{0}%
  \hmark{Q\the\rownum\the\colnum}\bJJGInsertLayer%
  \@ifnextchar[%
    {\let\Ans\Question@tabular
     \def\endQuestion{\end{tabular}%
     \eJJGInsertLayer\endgroup\newpage}\getBracArg}%
    {\let\Ans\Question@list\noindent%
     \textcolor{\dollarColor}{\jj@currencyHeading}\space\ignorespaces
     \def\endQuestion{\end{list}\eJJGInsertLayer\endgroup\newpage}}%
}
\def\getBracArg[#1]{\def\jb@numCols{#1}\noindent%
    \textcolor{\dollarColor}{\jj@currencyHeading}\space\ignorespaces}
\newlength{\jjgtmplength}
\newlength\jb@width \settowidth{\jb@width}{\normalfont(d)}
\newdimen\jb@tmpdima
\newlength\jb@tmplength
\providecommand\PBS[1]{\let\jb@temp=\\#1\let\\=\jb@temp}
\def\makelink#1{%
\ifcase\thejjgdriver
\leavevmode\pdfstartlink attr {/Border [0 0 0 ]} user {/Subtype /Link
    /A << /S /JavaScript /JS (qbrespond\(#1,\the\rownum,\the\colnum\))
    /Next << /S /GoTo /D (GameBoard) >> >> }\Hy@colorlink{\@linkcolor}%
\makebox[\jb@width]{\normalfont(\hfil\alph{newletter}\hfil)\hfill}\close@pdflink
\or
\makebox[\jb@width]%
   {\Rect{\normalfont(\hfil\alph{newletter}\hfil)\hfill}\literalps@out{%
    [ /Subtype /Link /Rect [pdf@llx pdf@lly pdf@urx pdf@ury]
      /Border [ 0 0 0 ]
      /Action << /S /JavaScript /JS (qbrespond\(#1,\the\rownum,\the\colnum\))
      /Next << /S /GoTo /D (GameBoard) >> >>
/ANN pdfmark}}%
\or
\@pdfm@mark{bann
<<
    /Border [0 0 0 ]
    /Subtype /Link
    /A << /S /JavaScript /JS (qbrespond\(#1,\the\rownum,\the\colnum\))
    /Next << /S /GoTo /D (GameBoard) >> >>
>>}\Hy@colorlink{\@linkcolor}%
   \makebox[\jb@width]{\normalfont(\hfil\alph{newletter}\hfil)\hfill}\hyper@linkend
\fi}

\def\Question@list{\begin{list}{}%
{\usecounter{newletter}
   \let\Ans=\JJ@Ans@list
   \settowidth{\jb@tmplength}{\normalfont(d)}%
   \settowidth{\labelwidth}{\normalfont(d)\enspace}%
   \setlength{\parsep}{0pt}\setlength{\itemindent}{0pt}%
   \setlength{\listparindent}{\parindent}%
   \setlength{\leftmargin}{\labelwidth}%
   \setlength{\labelsep}{0pt}%
}\Ans}%
\def\JJ@Ans@list#1{\stepcounter{newletter}\item[\makelink{#1}\hfill]}%

\def\Question@tabular{%
   \setcounter{newletter}{0}%
   \let\Ans=\JJ@Ans@tabular
   \jb@tmpdima=\linewidth \divide\jb@tmpdima by\jb@numCols
   \vskip\partopsep
   \noindent\normalbaselines\tabcolsep=0pt
   \begin{tabular}{*{\jb@numCols}{p{\jb@tmpdima}}}%
\Ans}
\def\JJ@Ans@tabular#1{\leavevmode\stepcounter{newletter}%
  \PBS\raggedright
  \settowidth{\jb@tmplength}{\normalfont(d)\enspace}%
  \hangindent=\jb@tmplength\hangafter=1%
  \makelink{#1}\enspace\ignorespaces
}
\newenvironment{oAnswer}
{%
    \gdef\oField{{oQ\the\rownum\the\colnum}}%
    \gdef\curr@quiz{{oQ\the\rownum\the\colnum}}%
    \def\currQuiz{{oQ\the\rownum\the\colnum}}%
    \let\@qzsolndest=\@empty
    \stepcounter{questionno}%
    \let\eqQuizType=s\gdef\eqPTs{1}\global\let\eqQT=\eq@na%
    \let\solution=\solution@sq
    \let\endsolution=\endsolution@sq
    \global\let\Ans=\Question@list
    \gdef\endQuestion{\endgroup\newpage}%

}{}
\def\JJ@@RespBoxMathActions
{%
    \AA{\AAKeystroke{if(event.willCommit) {\r\t
            var retn = \processJSfunc(\rbArgs,\compareJSfunc);\r
            if ( retn != null ) {\r\t
                qbrespond(retn,\the\rownum,\the\colnum)\r\t
                this.gotoNamedDest("GameBoard");\r
            }
        }}%
        \AAFormat{\eqFormatArg}%
        \AAOnFocus{\JS{var retn = null;}}%
    }
}

\def\JJ@@RespBoxTxtActions
{%
    \AA{\AAKeystroke{if(event.willCommit) {\r\t
        retn = ProcRespTxt(\rbTxtAlt);\r
        if ( retn != null ) {\r\t
            qbrespond(retn,\the\rownum,\the\colnum)\r\t
            this.gotoNamedDest("GameBoard");\r
        }
    }}%
    \AAOnFocus{\JS{var retn = null;}}
    }%
}
\def\redefineRespBoxActions{%
    \let\@@RespBoxMathActions\JJ@@RespBoxMathActions
        \let\@@RespBoxTxtActions\JJ@@RespBoxTxtActions}
\newcommand{\printButtonCaption}[1]{\def\jj@printButtonCaption{#1}}
\printButtonCaption{Print}
\newcommand{\printButtonLabel}[1]{\def\jj@printButtonLabel{#1}}
\printButtonLabel{Print this page:}
\newcommand{\contestentNameLabel}[1]{\def\jjg@contestentNameLabel{#1}}
\contestentNameLabel{Student:}
\newcommand{\timestampLabel}[1]{\def\jjg@timestampLabel{#1}}
\timestampLabel{Time stamp:}
\newcommand{\gameboardPrintButton}[1][]
{%
    \jj@printButtonLabel\space\pushButton[\CA{\jj@printButtonCaption}
    \A{\JS{%
        var pp = this.getPrintParams();\r
        pp.firstPage=this.pageNum;\r
        pp.lastPage=this.pageNum;\r
        pp.pageHandling = pp.constants.handling.shrink;\r
        var fv = pp.constants.flagValues;\r
        pp.flags |= (fv.suppressCenter | fv.suppressRotate);\r
        this.print(pp);}}#1]{printit}{}{11bp}\quad
        \jjg@contestentNameLabel\space\textField[\BC{}\Ff\FfReadOnly]{jjContestantNameprint}{1.5in}{11bp}\\[1ex]
        \jjg@timestampLabel\space\textField[\BC{}\Ff\FfReadOnly]{timestamp}{1.5in}{11bp}%
}%
\newcommand{\contestantName}[3][\BC{}\AA{\AAKeystroke{%
    if ( event.willCommit ) {\r\t
        var f = this.getField("jjContestantNameprint");\r\t
        if ( f != null ) f.value = event.value;\r
    }
    }}]{\textField[#1]{jjContestantName}{#2}{#3}}
\newcommand{\timeStampFormat}[1]{\def\jjTimeStampFormat{#1}}
\timeStampFormat{mm-dd-yy, H:MM:ss.}
\AtBeginDocument{\redefineRespBoxActions}
\newcommand{\enterNamePlease}[1]{\def\jjEnterNamePlease{#1}}
\enterNamePlease{Please, enter your name on the first
    page before you begin the game!}
\let\jjInstructionPageBG\relax
\let\jjGameBoardPageBG\relax
\let\jjQuestionPagesBG\relax
\newcommand{\defineInstructionPageGraphic}[1]{\def\jjInstructionPageBG{#1}}
\newcommand{\defineGameboardPageGraphic}[1]{\def\jjGameBoardPageBG{#1}}
\newcommand{\defineQuestionPagesGraphic}[1]{\def\jjQuestionPagesBG{#1}}
\newcommand{\instructionPageTemplate}{%
    \@ifundefined{jjInstructionPageBG}{}{%
    \edef\expand@templatename{\noexpand\template{\jjInstructionPageBG}}%
        \expand@templatename}}
\newcommand{\gameboardPageTemplate}{%
    \@ifundefined{jjGameBoardPageBG}{}{%
    \edef\expand@templatename{\noexpand\template{\jjGameBoardPageBG}}%
        \expand@templatename}}
\newcommand{\questionPagesTemplate}{%
    \@ifundefined{jjQuestionPagesBG}{}{%
    \edef\expand@templatename{\noexpand\template{\jjQuestionPagesBG}}%
        \expand@templatename}}
\newcommand{\illegalAccessMsg}[1]{\def\jjIllegalAccessMsg{#1}}
\illegalAccessMsg{You are peeking at this question. Choose a question from the game board first! You may want to start the game over now!}
\newcommand{\illegalAnswerTwiceMsg}[1]{\def\jjIllegalAnswerTwiceMsg{#1}}
\illegalAnswerTwiceMsg{Changing your answer is not allowed!}
\begin{insDLJS*}[qbrespond]{jjgdljs}
\begin{newsegment}{JJG: JavaScript to Control Jeopardy}
function qbrespond(ans,row,col)
{
    if ( eval("typeof pushCell"+row+col) == "undefined") {
        app.alert("\jjIllegalAccessMsg");
        return null;
    }
    var Total = this.getField("Total");
    var p = numQuestions*(col-1)+row-1;
    if (QAed.charAt(p)==0)
    {
        QAed = QAed.substring(0,p)+1+QAed.substring(p+1,totalQuestions);
        if (ans==1)
        {
            this.getField(""+row+col+'R').hidden=false;
            Total.value += \scaleFactor*row*100;
            app.alert(aCM[nCM],3);
            if (++nCM > 6) nCM=0;
        }
        else
        {
            this.getField(""+row+col+'W').hidden=false;
            var f = this.getField(""+row+col)
            Total.value -= \scaleFactor*row*100;
            app.alert(aEM[nEM],3);
            if (++nEM > 6) nEM=0;
        }
        if ((++NumQAed>=totalQuestions) && (Total.value>=Goal))
            this.getField("GrandPoohbah").hidden=false;}
    else
        app.alert("\jjIllegalAnswerTwiceMsg");
}
var tsfield = this.getField("timestamp");
if ( tsfield != null )
    tsfield.value = util.printd("\jjTimeStampFormat", new Date());
function makeNameReadOnly()
{
    var f = this.getField("jjContestantName");
    if ( (f != null) && !f.readonly ) f.readonly=true;
}
\end{newsegment}
\begin{newsegment}{JJG: Global Variables}
var numQuestions = \the\numQuestions;
var numCategories = \the\numCategories;
var Goal = \Goal;
var totalQuestions = numQuestions * numCategories;
var QAed = "";
for (var i=0; i< totalQuestions; i++) QAed +="0";
var nEM = 0;
var nCM = 0;
var NumQAed = 0;
\end{newsegment}
\begin{JJLangEnglish}
\begin{newsegment}{JJG: Arrays for Jeopardy for English}
var aCM = new Array
(
    "That's Right!  Way to go, Kiddo!",
    "Wonderfully Done! Congrats!",
    "Very Good! Keep up the good work!",
    "Good, good, good, good!",
    "Gee, you're smart! Try a harder one!",
    "You're pretty sharp! Continuez, s'il vous pla\356t!",
    "You're the tops! But wait...try another."
)
var aEM = new Array
(
    "That's wrong! Sorry. Try Again.",
    "Error again.  Don't guess, I'm watching!",
    "Please!  Please!  Work it out first!",
    "An error has insinuated itself into your calculations.\n"
   +"Recalibrate your thinking!",
    "Bah! Humbug!  You're haunted by Errors!",
    "Try again.  This time with order and method.",
    "Wrong again!  Use your little gray cells!"
)
\end{newsegment}
\end{JJLangEnglish}
\begin{JJLangGerman}
\begin{newsegment}{JJG: Arrays for Jeopardy for German}
var aCM = new Array
(
    "Richtig!  So ist's recht!",
    "Gut gemacht! Gratuliere!",
    "Sehr gut! Weiter so!",
    "Gut, gut, gut, gut!",
    "Du bist sehr clever! Jetzt versuch mal eine Schwierigere!",
    "Jawoll! Continuez, s'il vous pla\356t!",
    "Spitze! Auf geht's, zu einer weiteren Aufgabe!"
)
var aEM = new Array
(
    "Leider falsch!",
    "Schon wieder falsch!  Nicht raten!",
    "Bitte denk erst nach bevor Du auf die Antwort klickst!",
    "Ein Fehler hat sich eingeschlichen. Erst denken, dann ...!",
    "Ohje! So ein Quatsch!",
    "Versuch's nochmal.  Es ist noch nicht aller Tage Abend.",
    "Schon wieder falsch!  Nutz Deine kleine grauen Zellen!"
)
\end{newsegment}
\end{JJLangGerman}
\begin{JJForCredit}
\begin{newsegment}{JJG: JS to support forcredit}
var noNameError, fname;
function forCreditClosePage()
{
    fname = this.getField("jjContestantName");
    if ( fname != null ) {
        var JJjsCode = "if ( fname.value.replace(/\s*/g, '') == '' ) {"
            + " if ( typeof closingJJ == 'undefined' ) {"
            + " app.alert({cMsg: '\jjEnterNamePlease', cTitle: 'AcroTeX eDucation Bundle'});"
            + " this.pageNum = 0;"
            + " } } else { fname.readonly = true; }";
        noNameError = app.setTimeOut(JJjsCode, 15);
    }
}
\end{newsegment}
\end{JJForCredit}
\end{insDLJS*}
\endinput
%%
%% End of file `jj_game.cls'.
