/*
  This is the file coding.c of the CJK macro package ver. 4.1.3
  (20-Jun-1997).
*/


#include "coding.h"


void EUC_next_char(unsigned char *);
void Big5_next_char(unsigned char *);
void SJIS_next_char(unsigned char *);
void Unicode_next_char(unsigned char *);


/*@@*/

void get_next_char(cc, encoding)
  unsigned char *cc;
  int encoding;
{
  switch (encoding)
  {
  case EUC:
    EUC_next_char(cc);
    break;
  case BIG5:
    Big5_next_char(cc);
    break;
  case SJIS:
    SJIS_next_char(cc);
    break;
  case Unicode:
    Unicode_next_char(cc);
    break;
  }
}


void EUC_next_char(cc)
  unsigned char *cc;
{
  cc[1]++;
  if (cc[1] == 0xff)
  {
    cc[0]++;
    cc[1] = 0xa1;
  }
}


void Big5_next_char(cc)
  unsigned char *cc;
{
  cc[1]++;
  if (cc[1] == 0x7f)
    cc[1] = 0xa1;
  if (cc[1] == 0xff)
  {
    cc[0]++;
    cc[1] = 0x40;
  }
}


void SJIS_next_char(cc)
  unsigned char *cc;
{
  cc[1]++;
  if (cc[1] == 0x7f)
    cc[1] = 0x80;
  else if (cc[1] == 0xfd)
  {
    cc[0]++;
    cc[1] = 0x40;
  }
  if (cc[0] == 0xa0)
    cc[0] = 0xe0;
}


void Unicode_next_char(cc)
  unsigned char *cc;
{
  cc[1]++;
  if (cc[1] == 0)
    cc[0]++;
}


void JIS_to_SJIS(cc)
  unsigned char *cc;
{
  unsigned int index;

  index = (cc[0] - 0xa1) * (0xfe - 0xa1 + 1) + (cc[1] - 0xa1);
  cc[0] = index / ((0x7e - 0x40 + 1) + (0xfc - 0x80 + 1));
  cc[1] = index % ((0x7e - 0x40 + 1) + (0xfc - 0x80 + 1));
  if (cc[0] < (0x9f - 0x81 + 1))
    cc[0] += 0x81;
  else
    cc[0] += 0xe0 - (0x9f - 0x81 + 1);
  if (cc[1] < (0x7e - 0x40 + 1))
    cc[1] += 0x40;
  else
    cc[1] += 0x80 - (0x7E - 0x40 + 1);
}


/* end of coding.c */
