%
% Identification
\NeedsTeXFormat{LaTeX2e}
\ProvidesClass{sample}[1999/02/22 v0.9a sample class]
%
% Option Declaration
\DeclareOption*{\PassOptionsToClass{\CurrentOption}{article}}
%
% Option Processing
\ProcessOptions\relax
%
% Loading Files
\PassOptionsToPackage{a5paper}{typearea}
\LoadClass[a5paper]{article}
\RequirePackage{array}
\RequirePackage{booktabs}
\RequirePackage{caption2}
\RequirePackage{fancyhdr}
\RequirePackage{german}
\RequirePackage{mdwlist}
\RequirePackage{sabon}
\RequirePackage{trennung}
\RequirePackage{units}
\RequirePackage{url}
\RequirePackage[T1]{fontenc}
\RequirePackage[latin1]{inputenc}
\RequirePackage[nops]{titlesec}
\RequirePackage[DIV11]{typearea}
%
% Einzugbereinigung
\newlength{\mainboxwidth}
\newlength{\maingap}
\newlength{\mainmargin}
\newlength{\tabindent}
\setlength{\maingap}{0.5em}
\settowidth{\mainboxwidth}{\Large\itshape 88}
\setlength{\mainmargin}{\mainboxwidth}
\addtolength{\mainmargin}{\maingap}
\setlength{\tabindent}{1.7em}
%
% Bibliografie
\renewenvironment{thebibliography}[1]{%
  \section{\refname}%
  \list{}{%
    \setlength{\labelwidth}{0em}%
    \setlength{\leftmargin}{\mainmargin}%
    \setlength{\itemindent}{-\leftmargin}%
    \usecounter{enumiv}%
  }%
}{%
  \endlist
}
%
% Druckvermerk
\newenvironment{druckvermerk}{%
  \clearpage
  \thispagestyle{empty}%
  \vspace*{\fill}%
  \begin{basedescript}{%
    \desclabelwidth{\mainboxwidth}%
    \setlength{\topsep}{0ex}%
    \setlength{\partopsep}{0ex}%
    \desclabelstyle{\nextlinelabel}%
    \renewcommand{\makelabel}[1]{\itshape##1}%
  }%
}{%
  \end{basedescript}%
}
%
% Gleitobjektparameter
\renewcommand{\floatpagefraction}{0.8}
\setlength{\belowcaptionskip}{\abovecaptionskip}
%
% Glossar
\newcommand{\glossar}[1]{\emph{#1}}
%
% Listenbehandlung
\setlength{\labelsep}{\maingap}
\renewcommand*\descriptionlabel[1]{\hspace{\labelsep}\itshape#1}
\renewcommand\labelitemi{\textendash}
\setlength{\leftmargini}{\mainmargin}
%
% Titelei
\newenvironment{titelei}{%
  \newcommand{\derautor}{}%
  \newcommand{\autor}[1]{%
    \renewcommand{\derautor}{##1}%
  }%
  \newcommand{\derkurzautor}{}%
  \newcommand{\kurzautor}[1]{%
    \renewcommand{\derkurzautor}{##1}%
  }%
  \newcommand{\derkurztitel}{}%
  \newcommand{\kurztitel}[1]{%
    \renewcommand{\derkurztitel}{##1}%
  }%
  \newcommand{\dasjahr}{}%
  \newcommand{\jahr}[1]{%
    \renewcommand{\dasjahr}{##1}%
  }%
  \newcommand{\derort}{}%
  \newcommand{\ort}[1]{%
    \renewcommand{\derort}{##1}%
  }%
  \newcommand{\dertitel}{}%
  \newcommand{\titel}[1]{%
    \renewcommand{\dertitel}{##1}%
  }%
}{%
  \setlength{\parindent}{\mainmargin}%
  \derkurzautor~\textperiodcentered~\emph{\derkurztitel}%
  \thispagestyle{empty}%
  \clearpage
  \derautor
  \par
  \bigskip
  \Large\emph{\dertitel}%
  \par
  \vfill
  \normalsize\derort~\textperiodcentered~\dasjahr
  \thispagestyle{empty}%
  \clearpage
}
%
% Untergliederung
\newcommand{\backmatter}{\clearpage\appendix\bibliographystyle{sample}}
\newcommand{\frontmatter}{\pagestyle{plain}}
\newcommand{\mainmatter}{\clearpage}
%
% Verzeichnisse
\renewcommand{\l@section}{\@dottedtocline{1}{0em}{\mainmargin}}
\let\l@table\l@section
\renewcommand{\numberline}[1]{\makebox[\@tempdima][r]{#1\hspace{\maingap}}}
%
% array.sty
\newcolumntype{d}[1]{>{\raggedleft\hspace{0pt}}p{#1}}
\newcolumntype{n}{l}
\newcolumntype{N}{l}
\newcolumntype{v}[1]{>{\raggedright\hspace{0pt}}p{#1}}
\newcolumntype{V}[1]{>{\raggedright\hspace{0pt}}p{#1}}
%
% booktabs.sty
\setlength{\heavyrulewidth}{0.07em}
\setlength{\cmidrulewidth}{0.02em}
%
% caption2.sty
\renewcommand\onelinecaption[2]{%
  \sbox\captionbox{#1}%
  \hspace{\mainmargin}%
  \usebox{\captionbox}%
  \par
}
\renewcommand{\captionfont}{\itshape}
%
% fancyhdr.sty
\AtBeginDocument{\pagestyle{fancy}}
\fancypagestyle{plain}{%
  \renewcommand{\headrulewidth}{0ex}%
  \fancyhf{}%
  \fancyfoot[L]{\hspace{\mainmargin}\thepage}%
}
%
% titlesec.sty
\renewcommand{\bottomtitlespace}{3\baselineskip}
\titleformat{name=\section}[hang]{\Large\itshape}{%
    \makebox[\mainboxwidth]{\hfill\thesection}%
  }{\maingap}{}
\titleformat{name=\section,numberless}[hang]{\Large\itshape}{}{\mainmargin}{}
%
% url.sty
\renewcommand{\UrlFont}{\itshape}
