#include <math.h>
#include <cstdarg>
#include <iostream>
#include <fstream>
#include <string>
#include <sstream>
#include <iomanip>
using namespace std;
#include "w2lfunctions.h"

char const*default_output_file = "";
ofstream output_file;

class w2l_decimal_point_t
{
    static char m_decimal_point_h;
public:
    static void set_decimal_point(char i_point_h){ m_decimal_point_h = i_point_h; }
    static char get_decimal_point_rh(void) { return m_decimal_point_h;}
};
char w2l_decimal_point_t::m_decimal_point_h = ',';

class w2l_num_facet_t : public numpunct<char>, protected w2l_decimal_point_t
{
    protected:
        char do_decimal_point() const { return get_decimal_point_rh(); }
};

w2l_num_facet_t* w2l_num_facet_ps= new w2l_num_facet_t;

locale   w2l_locale_num(locale::classic(),w2l_num_facet_ps);

class w2l_money_facet_t : public moneypunct<char>, protected w2l_decimal_point_t
{
    int m_frac_count_i;
    protected:
        char do_decimal_point() const { return get_decimal_point_rh(); }
        int do_frac_digits() const { return m_frac_count_i; }
    public :
        void set_frac_digits(unsigned int i_fc_i){m_frac_count_i = i_fc_i; }
};

w2l_money_facet_t* w2l_money_facet_ps= new w2l_money_facet_t;

locale   w2l_locale_money(locale::classic(),w2l_money_facet_ps);


void w2ldefault_output(char const*i_default_output_file)
{
    default_output_file = i_default_output_file;
}

int w2l_exe_agument(int ac,char const*av[])
{


    if(ac >= 2)
    {
        default_output_file = av[1];
    }
    output_file.open(default_output_file);
    output_file.imbue(w2l_locale_num);
    if(output_file.fail())
    {
        cerr <<"ERROR: Can't open file \""<<default_output_file<<'"';
        return -1;
    }


    return 0;
}

void w2ldecimal_point(char const point)
{
    w2l_decimal_point_t::set_decimal_point(point);
}

void w2lnewboolean(w2lbool const var_val,char const*var_name)
{
    output_file<<"\\newboolean{"<<var_name<<"}\\setboolean{"<<var_name<<"}{"
        <<(char const*)(var_val ? "true":"false")<<'}'<<endl;
}
void w2lnewcommand(w2lfloat const var_val,char const*var_name,char const*var_format)
{
    output_file<<"\\newcommand{\\"<<var_name<<"}{";
    if(*var_format == '\0')
    {
        output_file<<var_val<<'}'<<endl;
    }
    else
    {

        unsigned int vf_len_ui = strlen(var_format);
        unsigned int vf_pos_decimal_point;
        // get decimal point position
        for(vf_pos_decimal_point = 0;vf_pos_decimal_point <vf_len_ui;++vf_pos_decimal_point)
        {
            if(var_format[vf_pos_decimal_point] == w2l_decimal_point_t::get_decimal_point_rh())
                break;
        }
        // count number of digits after point
        int frac_count_i = 0;
        for(unsigned int i = vf_pos_decimal_point+1;i <vf_len_ui;++i)
        {
            if(var_format[i] == '0')
                ++frac_count_i;
        }


        double int_val;
        if(var_val < 0)
            int_val = ceil(var_val);
        else
            int_val = floor(var_val);

        output_file<<noshowpoint<<int_val;
        double frac_val =  var_val- int_val;
        if(frac_count_i>0)
        {
            output_file<<w2l_decimal_point_t::get_decimal_point_rh();

            do
            {
                frac_val *= 10;
                double digit = floor(frac_val);
                output_file<<digit;
                output_file<<digit;
                frac_val -= digit;
            }
            while(--frac_count_i > 0);
        }
        output_file<<"}"<<endl;

    }


}

w2lfloat w2lmod(w2lfloat const dividend,w2lfloat const divisor)
{
    w2lfloat ret = 1.0;
    if(divisor == 0.0)
    {
        output_file<<"%W2L/w2lmod:division by zero"<<endl;
    }
    else
    {
        ret = dividend;
        w2lfloat q = dividend/divisor;
        w2lfloat s;
        if(q < 0)
        {
            s  = -1.0;
            q   = -q;
        }
        else
        {
            s = 1.0;
        }

        q= floor(q)*s;

        ret -= q*divisor;
    }

    return ret;
}

w2lfloat w2lround(w2lfloat const val,w2lfloat const post_point_digit_count)
{
    w2lfloat ret;
    w2lfloat pow10 = w2lpower(10,post_point_digit_count);
    ret = floor(val*pow10+0.5)/pow10;
    return ret;
}

w2lfloat w2lproduct(unsigned int const arg_count,...)
{
    va_list vl;
    va_start(vl,arg_count);
    w2lfloat ret = 1.0;
    for(unsigned int i = 1;i <= arg_count;++i)
    {
        w2lfloat next = va_arg(vl,w2lfloat);
        ret *= next;
    }
    va_end(vl);

    return ret;
}

w2lfloat w2laverage(unsigned int const arg_count,...)
{
    va_list vl;
    va_start(vl,arg_count);
    w2lfloat ret = 0.0;
    for(unsigned int i = 1;i <= arg_count;++i)
    {
        w2lfloat next = va_arg(vl,w2lfloat);
        ret += next;
    }
    va_end(vl);
    if(arg_count != 0)
        ret /= arg_count;

    return ret;
}

w2lfloat w2lint(w2lfloat const x)
{
    if(x<0.0)
        return -floor(-x);
    else
        return floor(x);
}

w2lfloat w2labs(w2lfloat const x)
{
    return fabs(x);
}

w2lfloat w2lpower(w2lfloat const to_be_raised,w2lfloat const to_power)
{
    w2lfloat ret = 1.0;
    if(to_be_raised == 0.0)
        ret  =0.0;
    else if(to_be_raised < 0.0)
    {
        output_file<<"%W2L/w2lpower: raising negative number to power"<<endl;
    }
    else
        ret = exp(log(to_be_raised)*to_power);

    return ret;
}
