// File          : UnicodePanel.java
// Description   : Panel for selecting character by its unicode value
// Date          : 6th February 2006
// Author        : Nicola L.C. Talbot
//                 http://theoval.cmp.uea.ac.uk/~nlct/

/*
    Copyright (C) 2006 Nicola L.C. Talbot

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
*/
package uk.ac.uea.cmp.nlct.jpgfdraw.dialog;

import java.awt.*;
import java.awt.event.*;
import java.awt.geom.*;
import java.awt.font.*;
import java.awt.image.*;
import java.beans.*;

import javax.swing.*;
import javax.swing.event.*;
import javax.swing.text.*;

import uk.ac.uea.cmp.nlct.jdr.*;

import uk.ac.uea.cmp.nlct.jdrresources.*;
import uk.ac.uea.cmp.nlct.jdrresources.numfield.*;

/**
 * Panel for selecting character from its unicode value.
 * @author Nicola L C Talbot
 */

public class UnicodePanel extends JPanel
   implements ActionListener
{
   public UnicodePanel(SymbolSelectorListener symbolListener,
                       CharacterSelector charSelector)
   {
      super(new BorderLayout());

      listener = symbolListener;
      selector = charSelector;

      samplePanel = new SampleCharPanel(this);

      add(samplePanel, "Center");

      JPanel topPanel = new JPanel();

      JLabel unicodeLabel = new JLabel(
         JDRResources.getString("symbol.unicode"));
      unicodeLabel.setDisplayedMnemonic(
         JDRResources.getChar("symbol.unicode.mnemonic"));

      topPanel.add(unicodeLabel);

      unicodeField = new HexField(0);
      unicodeField.setToolTipText(
         JDRResources.getString("tooltip.unicode_value"));

      unicodeField.getDocument().addDocumentListener(
          new TextFieldSampleListener(samplePanel));
      unicodeLabel.setLabelFor(unicodeField);

      topPanel.add(unicodeField);

      selectButton = new JButton(JDRResources.getString("symbol.select"));
      selectButton.setMnemonic(
         JDRResources.getChar("symbol.select.mnemonic"));
      selectButton.addActionListener(this);
      selectButton.setActionCommand("selectsymbol");
      selectButton.setToolTipText(
         JDRResources.getString("tooltip.unicode_select"));

      topPanel.add(selectButton);

      add(topPanel, "North");

   }

   public boolean unicodeFieldHasFocus()
   {
      return unicodeField.hasFocus();
   }

   public void actionPerformed(ActionEvent evt)
   {
      String action = evt.getActionCommand();

      if (action == null) return;

      if (action.equals("selectsymbol"))
      {
         selector.insertChar(getSymbol());
      }

   }

   public void setSymbol(int hexValue)
   {
      unicodeField.setValue(hexValue);
   }

   public void setHexString(String hexString)
   {
      unicodeField.setText(hexString);
   }

   public char getSymbol()
   {
      return (char)unicodeField.getValue();
   }

   public SymbolSelectorListener getSymbolSelectorListener()
   {
      return listener;
   }

   public RenderingHints getSymbolRenderingHints()
   {
      return listener.getRenderingHints();
   }

   public Font getSymbolFont()
   {
      return listener.getSymbolButtonFont();
   }

   private SymbolSelectorListener listener;
   private CharacterSelector selector;

   private HexField unicodeField;
   private JButton selectButton;
   private SampleCharPanel samplePanel;
}
