// File          : TeXSettingsPanel.java
// Description   : Panel for configuring TeX settings
// Date          : 6th February 2006
// Last Modified : 12th July 2008
// Author        : Nicola L.C. Talbot
//                 http://theoval.cmp.uea.ac.uk/~nlct/

/*
    Copyright (C) 2006 Nicola L.C. Talbot

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
*/
package uk.ac.uea.cmp.nlct.jpgfdraw.dialog;

import java.awt.*;
import java.awt.event.*;

import javax.swing.*;
import javax.swing.event.*;
import javax.swing.border.*;

import uk.ac.uea.cmp.nlct.jdr.*;
import uk.ac.uea.cmp.nlct.jdrresources.*;
import uk.ac.uea.cmp.nlct.jpgfdraw.*;

/**
 * Panel for configuring TeX settings.
 * @author Nicola L C Talbot
 */
public class TeXSettingsPanel extends Box
   implements ItemListener
{
   public TeXSettingsPanel()
   {
      super(BoxLayout.Y_AXIS);

      Box b2 = Box.createHorizontalBox();
      b2.setAlignmentX(Component.LEFT_ALIGNMENT);
      add(b2);

      JLabel label = new JLabel(
         JDRResources.getString("texsettings.label"));
      label.setDisplayedMnemonic(
         JDRResources.getChar("texsettings.label.mnemonic"));

      label.setAlignmentX(Component.LEFT_ALIGNMENT);
      b2.add(label);

      b2.add(Box.createHorizontalStrut(10));

      //sizeBox = new JComboBox<Integer>(availableSizes);// Java7
      sizeBox = new JComboBox(availableSizes);
      sizeBox.addItemListener(this);
      label.setLabelFor(sizeBox);
      b2.add(sizeBox);
      sizeBox.setAlignmentX(Component.LEFT_ALIGNMENT);

      b2.add(Box.createHorizontalGlue());

      add(Box.createVerticalStrut(10));

      updateImageBox = new JCheckBox(
         JDRResources.getString("texsettings.update"), true);
      updateImageBox.setMnemonic(
         JDRResources.getChar("texsettings.update.mnemonic"));

      updateImageBox.setSelected(
         JpgfDraw.isLaTeXFontUpdateEnabled());

      updateImageBox.setAlignmentX(Component.LEFT_ALIGNMENT);
      add(updateImageBox);

      add(Box.createVerticalStrut(10));

      JTextArea textarea = new JTextArea(
         JDRResources.getString("texsettings.note"));
      textarea.setEditable(false);
      textarea.setOpaque(false);

      textarea.setAlignmentX(Component.LEFT_ALIGNMENT);

      add(textarea);
      add(Box.createVerticalStrut(10));

      example = new JLabel("\\documentclass[10pt]{article}");
      example.setAlignmentX(Component.LEFT_ALIGNMENT);
      add(example);

   }

   public void initialise(JDRFrame frame)
   {
      int normalSize = frame.getNormalSize();

      for (int i = 0; i < availableSizes.length; i++)
      {
         if (availableSizes[i].intValue() == normalSize)
         {
            sizeBox.setSelectedIndex(i);
            break;
         }
      }

      updateExample(normalSize);
   }

   public void updateExample(int normalsize)
   {
      if (normalsize >= 10 && normalsize <= 12)
      {
         example.setText(
            "\\documentclass["+normalsize+"pt]{article}");
      }
      else if (normalsize >= 24)
      {
         example.setText("\\documentclass{a0poster}");
      }
      else
      {
         example.setText(
            "\\documentclass["+normalsize+"pt]{extarticle}");
      }
   }

   public void itemStateChanged(ItemEvent e)
   {
      int normalsize = ((Integer)sizeBox.getSelectedItem()).intValue();
      updateExample(normalsize);
   }

   public void okay(JDRFrame frame)
   {
      int normalsize = ((Integer)sizeBox.getSelectedItem()).intValue();
      frame.setNormalSize(normalsize);

      if (updateImageBox.isSelected())
      {
         frame.updateLaTeXFontSize();
      }

      JpgfDraw.setLaTeXFontUpdate(getLaTeXFontUpdate());
   }

   public boolean getLaTeXFontUpdate()
   {
      return updateImageBox.isSelected();
   }

   public void setLaTeXFontUpdate(boolean update)
   {
      updateImageBox.setSelected(update);
   }

   //private JComboBox<Integer> sizeBox; // Java7
   private JComboBox sizeBox;
   private JLabel example;

   private static final Integer[] availableSizes = new Integer[]
         {
            new Integer(25),
            new Integer(20),
            new Integer(17),
            new Integer(14),
            new Integer(12),
            new Integer(11),
            new Integer(10),
            new Integer(9),
            new Integer(8)
         };

   private JCheckBox updateImageBox;
}
