// File          : TeXSettingsDialog.java
// Description   : Dialog for configuring TeX settings
// Date          : 6th February 2006
// Last Modified : 12th July 2008
// Author        : Nicola L.C. Talbot
//                 http://theoval.cmp.uea.ac.uk/~nlct/

/*
    Copyright (C) 2006 Nicola L.C. Talbot

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
*/
package uk.ac.uea.cmp.nlct.jpgfdraw.dialog;

import java.awt.*;
import java.awt.event.*;

import javax.swing.*;
import javax.swing.event.*;
import javax.swing.border.*;

import uk.ac.uea.cmp.nlct.jdr.*;

import uk.ac.uea.cmp.nlct.jdrresources.*;

import uk.ac.uea.cmp.nlct.jpgfdraw.*;

/**
 * Dialog for configuring TeX settings.
 * @author Nicola L C Talbot
 */

public class TeXSettingsDialog extends JDialog
   implements ActionListener
{
   public TeXSettingsDialog(JpgfDraw application)
   {
      super(application,
         JDRResources.getString("texsettings.title"), true);
      application_ = application;

      texSettings = new TeXSettingsPanel();

      getContentPane().add(texSettings, "Center");

      JPanel p2 = new JPanel();

      p2.add(JDRResources.createOkayButton(this));
      p2.add(JDRResources.createCancelButton(this));
      p2.add(JDRResources.createHelpButton("sec:normalsize"));

      getContentPane().add(p2, "South");

      pack();
      setLocationRelativeTo(application_);
   }

   public void display()
   {
      JDRFrame frame = application_.getCurrentFrame();

      display(frame);
   }

   public void display(JDRFrame frame)
   {
      if (frame != null)
      {
         texSettings.initialise(frame);
      }

      setVisible(true);
   }

   public void okay()
   {
      JDRFrame frame = application_.getCurrentFrame();

      texSettings.okay(frame);

      setVisible(false);
   }

   public void actionPerformed(ActionEvent e)
   {
      String action = e.getActionCommand();

      if (action == null) return;

      if (action.equals("okay"))
      {
         okay();
      } 
      else if (action.equals("cancel"))
      {
         setVisible(false);
      }
   }

   public String info()
   {
      String eol = System.getProperty("line.separator", "\n");

      String str = "";

      str += "TeXSettingsDialog:"+eol;
      str += "has focus: "+hasFocus()+eol;

      ActionMap actionMap = getRootPane().getActionMap();
      str += "action map: "+eol;

      Object[] allKeys = actionMap.allKeys();

      for (int i = 0; i < allKeys.length; i++)
      {
         str += "Key: "+allKeys[i]
             + " Action: "+actionMap.get(allKeys[i])+eol;
      }

      return str+eol;
   }

   private JpgfDraw application_;
   private TeXSettingsPanel texSettings;
}
