// File          : ScaleDialogBox.java
// Description   : Dialog box for scaling objects
// Date          : 1st February 2006
// Last Modified : 9th June 2008
// Author        : Nicola L.C. Talbot
//                 http://theoval.cmp.uea.ac.uk/~nlct/

/*
    Copyright (C) 2006 Nicola L.C. Talbot

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
*/
package uk.ac.uea.cmp.nlct.jpgfdraw.dialog;

import java.awt.*;
import java.awt.event.*;

import javax.swing.*;
import javax.swing.event.*;

import uk.ac.uea.cmp.nlct.jdr.*;

import uk.ac.uea.cmp.nlct.jdrresources.*;
import uk.ac.uea.cmp.nlct.jdrresources.numfield.*;

import uk.ac.uea.cmp.nlct.jpgfdraw.*;

/**
 * Dialog box for scaling objects.
 */

public class ScaleDialogBox extends JDialog
   implements ActionListener
{
   public ScaleDialogBox(JpgfDraw application)
   {
      super(application, JDRResources.getString("scale.title"), true);
      application_ = application;

      int width  = 300;
      int height = 150;
      setSize(width,height);
      setLocationRelativeTo(application);

      JPanel panel = new JPanel();

      panel.setLayout(new GridLayout(3,2));

      ButtonGroup bg = new ButtonGroup();

      scaleXButton = new JRadioButton(JDRResources.getString("scale.x"));
      scaleXButton.setMnemonic(JDRResources.getChar("scale.x.mnemonic"));
      bg.add(scaleXButton);
      panel.add(scaleXButton);
      scaleXButton.addActionListener(new ActionListener()
        {
           public void actionPerformed(ActionEvent evt)
           {
              scaleXField.setEnabled(true);
              scaleYField.setEnabled(false);
              scaleField.setEnabled(false);
              scaleXField.requestFocusInWindow();
           }
        });

      scaleXField = new DoubleField(1.0F);
      panel.add(scaleXField);

      scaleYButton = new JRadioButton(JDRResources.getString("scale.y"));
      scaleYButton.setMnemonic(JDRResources.getChar("scale.y.mnemonic"));
      bg.add(scaleYButton);
      panel.add(scaleYButton);

      scaleYButton.addActionListener(new ActionListener()
        {
           public void actionPerformed(ActionEvent evt)
           {
              scaleXField.setEnabled(false);
              scaleYField.setEnabled(true);
              scaleField.setEnabled(false);
              scaleYField.requestFocusInWindow();
           }
        });

      scaleYField = new DoubleField(1.0F);
      panel.add(scaleYField);

      scaleButton = new JRadioButton(JDRResources.getString("scale.both"),
         true);
      scaleButton.setMnemonic(JDRResources.getChar("scale.both.mnemonic"));
      bg.add(scaleButton);
      panel.add(scaleButton);

      scaleButton.addActionListener(new ActionListener()
        {
           public void actionPerformed(ActionEvent evt)
           {
              scaleXField.setEnabled(false);
              scaleYField.setEnabled(false);
              scaleField.setEnabled(true);
              scaleField.requestFocusInWindow();
           }
        });

      scaleField = new DoubleField(1.0F);
      panel.add(scaleField);

      scaleXField.setEnabled(false);
      scaleYField.setEnabled(false);
      scaleField.setEnabled(true);

      scaleField.requestFocusInWindow();

      getContentPane().add(panel, "Center");

      JPanel p2 = new JPanel();

      p2.add(JDRResources.createOkayButton(this));
      p2.add(JDRResources.createCancelButton(this));
      p2.add(JDRResources.createHelpButton("sec:scale"));

      getContentPane().add(p2, "South");
   }

   public void display()
   {
      if (scaleXButton.isSelected())
      {
         scaleXField.requestFocusInWindow();
      }
      else if (scaleYButton.isSelected())
      {
         scaleYField.requestFocusInWindow();
      }
      else
      {
         scaleField.requestFocusInWindow();
      }

      setVisible(true);
   }

   public void actionPerformed(ActionEvent evt)
   {
      String action = evt.getActionCommand();

      if (action == null) return;

      if (action.equals("okay"))
      {
         okay();
      }
      else if (action.equals("cancel"))
      {
         setVisible(false);
      }
   }

   public void okay()
   {
      setVisible(false);
      JDRFrame mainPanel = application_.getCurrentFrame();

      if (scaleXButton.isSelected())
      {
         mainPanel.scaleXSelectedPaths(scaleXField.getValue());
      }
      else if (scaleYButton.isSelected())
      {
         mainPanel.scaleYSelectedPaths(scaleYField.getValue());
      }
      else
      {
         mainPanel.scaleSelectedPaths(scaleField.getValue());
      }
   }

   public String info()
   {
      String eol = System.getProperty("line.separator", "\n");

      String str = "";

      str += "RotateDialogBox:"+eol;
      str += "has focus: "+hasFocus()+eol;
      str += "scale x field has focus: "+scaleXField.hasFocus()+eol;
      str += "scale y field has focus: "+scaleYField.hasFocus()+eol;
      str += "scale field has focus: "+scaleField.hasFocus()+eol;
      str += "scale x button has focus: "+scaleXButton.hasFocus()+eol;
      str += "scale y button has focus: "+scaleYButton.hasFocus()+eol;
      str += "scale button has focus: "+scaleButton.hasFocus()+eol;

      ActionMap actionMap = getRootPane().getActionMap();
      str += "action map: "+eol;

      Object[] allKeys = actionMap.allKeys();

      for (int i = 0; i < allKeys.length; i++)
      {
         str += "Key: "+allKeys[i]+" Action: "+actionMap.get(allKeys[i])+eol;
      }

      return str+eol;
   }

   private DoubleField scaleXField, scaleYField, scaleField;
   private JpgfDraw application_;
   private JRadioButton scaleXButton, scaleYButton, scaleButton;
}
