// File          : SampleTextPanel.java
// Description   : Panel for displaying sample text
// Date          : 6th February 2006
// Last Modified : 31 August 2008
// Author        : Nicola L.C. Talbot
//                 http://theoval.cmp.uea.ac.uk/~nlct/

/*
    Copyright (C) 2006 Nicola L.C. Talbot

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
*/
package uk.ac.uea.cmp.nlct.jpgfdraw.dialog;

import java.awt.*;
import java.awt.event.*;
import java.awt.geom.*;
import java.awt.font.*;

import javax.swing.*;
import javax.swing.event.*;
import javax.swing.text.*;
import javax.swing.border.*;

import uk.ac.uea.cmp.nlct.jdr.*;

import uk.ac.uea.cmp.nlct.jdrresources.*;
import uk.ac.uea.cmp.nlct.jdrresources.numfield.*;

/**
 * Panel for displaying sample text.
 * @author Nicola L C Talbot
 */

public class SampleTextPanel extends JPanel implements SamplePanel
{
   public SampleTextPanel(JDRSelector chooserPanel)
   {
      this(chooserPanel, false);
   }

   public SampleTextPanel(JDRSelector chooserPanel, boolean showAnchor)
   {
      super();
      setBackground(Color.white);

      this.showAnchor = showAnchor;

      BevelBorder border = new BevelBorder(BevelBorder.LOWERED,
         new Color(154,154,154), Color.darkGray);

      setBorder(border);

      panel = chooserPanel;

      sampleText = new JDRText();

      matrix = new double[]{1, 0, 0, 1, 0, 0};
   }

   public String getSampleText()
   {
      return panel.getSampleText();
   }

   public void paintComponent(Graphics g)
   {
      super.paintComponent(g);

      String text = sampleText.getText();

      if (text == null || text.length() == 0)
      {
         return;
      }

      Graphics2D g2 = (Graphics2D)g;

      updateStyle(g2);

      Dimension dim = getSize();

      RenderingHints oldHints = g2.getRenderingHints();
      g2.setRenderingHints(panel.getRenderingHints());

      double norm = JDRUnit.getNormalizingFactor();

      matrix[0] = norm;
      matrix[3] = norm;

      sampleText.setTransformation(matrix);

      BBox box = sampleText.getBBox();

      // Shift so that it's centred

      sampleText.setPosition((0.5*dim.width-box.getMidX()),
                             (0.5*dim.height-box.getMidY()));

      if (showAnchor)
      {
         sampleText.drawWithAnchors(g2, Color.red);
      }
      else
      {
         sampleText.draw(g2);
      }

      g2.setRenderingHints(oldHints);
   }

   public void updateSamples()
   {
      Graphics g2 = getGraphics();

      updateStyle(g2);

      if (g2 != null)
      {
         g2.dispose();

         validate();
         repaint();
      }
   }

   protected void updateStyle(Graphics g2)
   {
      try
      {
         sampleText.setText(g2, getSampleText());

         sampleText.setTextPaint(panel.getTextPaint());
         sampleText.setFontFamily(g2, panel.getFontName());
         sampleText.setFontSize(g2, panel.getFontSize());
         sampleText.setFontSeries(g2, panel.getFontSeries());
         sampleText.setFontShape(g2, panel.getFontShape());
         sampleText.setHAlign(panel.getHalign());
         sampleText.setVAlign(panel.getValign());
      }
      catch (InvalidFormatException e)
      {
      }
   }

   public BBox getBBox()
   {
      return sampleText.getBBox();
   }

   public Dimension getPreferredSize()
   {
      if (panel == null || sampleText == null)
      {
         return super.getPreferredSize();
      }

      BBox box = getBBox();

      double norm = JDRUnit.getNormalizingFactor();

      return new Dimension((int)Math.ceil(box.getWidth()*norm)+20,
         (int)Math.ceil(box.getHeight()*norm)+20);
   }

   private JDRSelector panel;
   private JDRText sampleText;

   private double[] matrix;

   private boolean showAnchor = false;
}
