// File        : RectangularCoordPanel.java
// Description : Panel for entering rectangular coordinates
// Date        : 2012-03-05
// Author      : Nicola L. C. Talbot
//               http://theoval.cmp.uea.ac.uk/~nlct/

/*
    Copyright (C) 2006 Nicola L.C. Talbot

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */

package uk.ac.uea.cmp.nlct.jpgfdraw.dialog;

import java.awt.*;

import javax.swing.*;

import uk.ac.uea.cmp.nlct.jdr.*;
import uk.ac.uea.cmp.nlct.jdrresources.*;
import uk.ac.uea.cmp.nlct.jdrresources.numfield.*;

import uk.ac.uea.cmp.nlct.jpgfdraw.*;

public class RectangularCoordPanel extends JPanel implements CoordPanel
{
   public RectangularCoordPanel()
   {
      super();

      xPanel = new NonNegativeLengthPanel(
         JDRResources.getString("coordinates.x")+" ",
         JDRResources.getChar("coordinates.x.mnemonic"));
      add(xPanel);


      yPanel = new NonNegativeLengthPanel(
         JDRResources.getString("coordinates.y")+" ",
         JDRResources.getChar("coordinates.y.mnemonic"));
      add(yPanel);

      setName(JDRResources.getString("grid.rectangular"));
   }

   public void requestCoordFocus()
   {
      xPanel.getTextField().requestFocusInWindow();
   }

   public void setCoords(double x, double y, JDRUnit unit, JDRPaper paper)
   {
      setUnit(unit);
      xPanel.setBpValue(Math.round(x));
      yPanel.setBpValue(Math.round(y));
   }

   public void setUnit(JDRUnit unit)
   {
      xPanel.setUnit(unit);
      yPanel.setUnit(unit);
   }

   public double getXCoord()
   {
      return xPanel.getValue();
   }

   public double getYCoord()
   {
      return yPanel.getValue();
   }

   private NonNegativeLengthPanel xPanel, yPanel;
}
