// File          : RadialGradientDirectionPanel.java
// Description   : Panel for selecting radial gradient start location
// Date          : 6th February 2006
// Last Modified : 9th June 2008
// Author        : Nicola L.C. Talbot
//                 http://theoval.cmp.uea.ac.uk/~nlct/

/*
    Copyright (C) 2006 Nicola L.C. Talbot

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
*/
package uk.ac.uea.cmp.nlct.jpgfdraw.dialog;

import java.awt.*;
import java.awt.event.*;

import javax.swing.*;
import javax.swing.event.*;

import uk.ac.uea.cmp.nlct.jdr.*;

import uk.ac.uea.cmp.nlct.jdrresources.*;

/**
 * Panel for selecting radial gradient start location.
 * @author Nicola L C Talbot
 */

public class RadialGradientDirectionPanel extends JPanel
   implements ActionListener
{
   public RadialGradientDirectionPanel()
   {
      super();
      GridLayout layout = new GridLayout(3, 3, 0, 0);
      setLayout(layout);

      ButtonGroup directionGroup = new ButtonGroup();

      // NORTH-WEST
      gNorthWest = new DirectionButton(
         JDRResources.appIcon("radial.png"),
         JDRResources.appIcon("radial_sel.png"),
         JDRRadial.NORTH_WEST);
      directionGroup.add(gNorthWest);
      add(gNorthWest);
      gNorthWest.addActionListener(this);
      gNorthWest.setActionCommand("northwest");
      gNorthWest.setMnemonic('7');
      gNorthWest.setToolTipText(JDRResources.getString(
         "tooltip.direction.radial.northwest"));

      // NORTH
      gNorth = new DirectionButton(
         JDRResources.appIcon("radial.png"),
         JDRResources.appIcon("radial_sel.png"),
         JDRRadial.NORTH);
      directionGroup.add(gNorth);
      add(gNorth);
      gNorth.addActionListener(this);
      gNorth.setActionCommand("north");
      gNorth.setMnemonic('8');
      gNorth.setToolTipText(JDRResources.getString(
         "tooltip.direction.radial.north"));


      // NORTH-EAST
      gNorthEast = new DirectionButton(
         JDRResources.appIcon("radial.png"),
         JDRResources.appIcon("radial_sel.png"),
         JDRRadial.NORTH_EAST);
      directionGroup.add(gNorthEast);
      add(gNorthEast);
      gNorthEast.addActionListener(this);
      gNorthEast.setActionCommand("northeast");
      gNorthEast.setMnemonic('9');
      gNorthEast.setToolTipText(JDRResources.getString(
         "tooltip.direction.radial.northeast"));

      // WEST
      gWest = new DirectionButton(
         JDRResources.appIcon("radial.png"),
         JDRResources.appIcon("radial_sel.png"),
         JDRRadial.WEST);
      directionGroup.add(gWest);
      add(gWest);
      gWest.addActionListener(this);
      gWest.setActionCommand("west");
      gWest.setMnemonic('4');
      gWest.setToolTipText(JDRResources.getString(
         "tooltip.direction.radial.west"));

      // Centre
      gCenter = new DirectionButton(
         JDRResources.appIcon("radial.png"),
         JDRResources.appIcon("radial_sel.png"),
         JDRRadial.CENTER,
         true);
      directionGroup.add(gCenter);
      add(gCenter);
      gCenter.addActionListener(this);
      gCenter.setActionCommand("center");
      gradientDir = JDRRadial.CENTER;
      gCenter.setMnemonic('5');
      gCenter.setToolTipText(JDRResources.getString(
         "tooltip.direction.radial.centre"));

      // East
      gEast = new DirectionButton(
         JDRResources.appIcon("radial.png"),
         JDRResources.appIcon("radial_sel.png"),
         JDRRadial.EAST);
      directionGroup.add(gEast);
      add(gEast);
      gEast.addActionListener(this);
      gEast.setActionCommand("east");
      gEast.setMnemonic('6');
      gEast.setToolTipText(JDRResources.getString(
         "tooltip.direction.radial.east"));

      // SOUTH-WEST
      gSouthWest = new DirectionButton(
         JDRResources.appIcon("radial.png"),
         JDRResources.appIcon("radial_sel.png"),
         JDRRadial.SOUTH_WEST);
      directionGroup.add(gSouthWest);
      add(gSouthWest);
      gSouthWest.addActionListener(this);
      gSouthWest.setActionCommand("southwest");
      gSouthWest.setMnemonic('1');
      gSouthWest.setToolTipText(JDRResources.getString(
         "tooltip.direction.radial.southwest"));

      // SOUTH
      gSouth = new DirectionButton(
         JDRResources.appIcon("radial.png"),
         JDRResources.appIcon("radial_sel.png"),
         JDRRadial.SOUTH);
      directionGroup.add(gSouth);
      add(gSouth);
      gSouth.addActionListener(this);
      gSouth.setActionCommand("northwest");
      gSouth.setMnemonic('2');
      gSouth.setToolTipText(JDRResources.getString(
         "tooltip.direction.radial.south"));

      // SOUTH-EAST
      gSouthEast = new DirectionButton(
         JDRResources.appIcon("radial.png"),
         JDRResources.appIcon("radial_sel.png"),
         JDRRadial.SOUTH_EAST);
      directionGroup.add(gSouthEast);
      add(gSouthEast);
      gSouthEast.addActionListener(this);
      gSouthEast.setActionCommand("southeast");
      gSouthEast.setMnemonic('3');
      gSouthEast.setToolTipText(JDRResources.getString(
         "tooltip.direction.radial.southeast"));

      Dimension dim = gSouthEast.getPreferredSize();
      setMaximumSize(new Dimension(3*dim.width,3*dim.height));
   }

/*
   public void addActionListener(ActionListener listener)
   {
      gNorth.addActionListener(listener);
      gNorthEast.addActionListener(listener);
      gEast.addActionListener(listener);
      gSouthEast.addActionListener(listener);
      gSouth.addActionListener(listener);
      gSouthWest.addActionListener(listener);
      gWest.addActionListener(listener);
      gNorthWest.addActionListener(listener);
      gCenter.addActionListener(listener);
   }
*/

   public void setEnabled(boolean flag)
   {
      super.setEnabled(flag);
      gNorth.setEnabled(flag);
      gNorthEast.setEnabled(flag);
      gEast.setEnabled(flag);
      gSouthEast.setEnabled(flag);
      gSouth.setEnabled(flag);
      gSouthWest.setEnabled(flag);
      gWest.setEnabled(flag);
      gNorthWest.setEnabled(flag);
      gCenter.setEnabled(flag);
   }

   public void actionPerformed(ActionEvent e)
   {
      Object source = e.getSource();

      if (source instanceof DirectionButton)
      {
         gradientDir = ((DirectionButton)source).getDirection();
      }
   }

   public int getDirection()
   {
      return gradientDir;
   }

   public void setDirection(int direction)
   {
      gradientDir = direction;

      switch (gradientDir)
      {
         case JDRRadial.NORTH :
            gNorth.setSelected(true);
         break;
         case JDRRadial.SOUTH :
            gSouth.setSelected(true);
         break;
         case JDRRadial.EAST :
            gEast.setSelected(true);
         break;
         case JDRRadial.WEST :
            gWest.setSelected(true);
         break;
         case JDRRadial.NORTH_WEST :
            gNorthWest.setSelected(true);
         break;
         case JDRRadial.SOUTH_EAST :
            gSouthEast.setSelected(true);
         break;
         case JDRRadial.NORTH_EAST :
            gNorthEast.setSelected(true);
         break;
         case JDRRadial.SOUTH_WEST :
            gSouthWest.setSelected(true);
         break;
         case JDRRadial.CENTER :
            gCenter.setSelected(true);
      }
   }

   private int gradientDir;

   private DirectionButton gNorth, gSouth, gEast, gWest;
   private DirectionButton gNorthWest, gSouthEast;
   private DirectionButton gNorthEast, gSouthWest, gCenter;
}
