// File        : RadialCoordPanel.java
// Description : Panel for entering radial coordinates
// Date        : 2012-03-05
// Author      : Nicola L. C. Talbot
//               http://theoval.cmp.uea.ac.uk/~nlct/

/*
    Copyright (C) 2006 Nicola L.C. Talbot

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */

package uk.ac.uea.cmp.nlct.jpgfdraw.dialog;

import java.awt.*;

import javax.swing.*;

import uk.ac.uea.cmp.nlct.jdr.*;
import uk.ac.uea.cmp.nlct.jdrresources.*;
import uk.ac.uea.cmp.nlct.jdrresources.numfield.*;

import uk.ac.uea.cmp.nlct.jpgfdraw.*;

public class RadialCoordPanel extends JPanel implements CoordPanel
{
   public RadialCoordPanel()
   {
      super();

      radiusPanel = new NonNegativeLengthPanel(
         JDRResources.getString("coordinates.radius")+" ",
         JDRResources.getChar("coordinates.radius.mnemonic"));
      add(radiusPanel);

      anglePanel = new AnglePanel(
         JDRResources.getString("coordinates.angle")+" ",
         JDRResources.getChar("coordinates.angle.mnemonic")
      );

      add(anglePanel);

      setName(JDRResources.getString("grid.radial"));
   }

   public void requestCoordFocus()
   {
      radiusPanel.getTextField().requestFocusInWindow();
   }

   public void setCoords(double x, double y, JDRUnit unit, JDRPaper paper)
   {
      this.paper = paper;
      JDRRadialPoint p = new JDRRadialPoint();

      p.setLocation(unit.toBp(x)-0.5*paper.getWidth(),
                    unit.toBp(y)-0.5*paper.getHeight());

      radiusPanel.setUnit(unit);
      radiusPanel.setBpValue(p.getRadius());

      anglePanel.setValue(p.getAngle());
   }

   public double getXCoord()
   {
      return radiusPanel.getValue()*Math.cos(anglePanel.getRadians())
             + 0.5*paper.getWidth();
   }

   public double getYCoord()
   {
      return radiusPanel.getValue()*Math.sin(anglePanel.getRadians())
              + 0.5*paper.getHeight();
   }

   private NonNegativeLengthPanel radiusPanel;

   private AnglePanel anglePanel;

   private JDRPaper paper;
}
