// File          : MovePointDialog.java
// Description   : Dialog box for specifying co-ordinates
// Date          : 1st February 2006
// Last Modified : 9th June 2008
// Author        : Nicola L.C. Talbot
//                 http://theoval.cmp.uea.ac.uk/~nlct/

/*
    Copyright (C) 2006 Nicola L.C. Talbot

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
*/
package uk.ac.uea.cmp.nlct.jpgfdraw.dialog;

import java.awt.*;
import java.awt.event.*;

import javax.swing.*;
import javax.swing.event.*;
import javax.swing.border.*;

import uk.ac.uea.cmp.nlct.jdr.*;
import uk.ac.uea.cmp.nlct.jdrresources.*;
import uk.ac.uea.cmp.nlct.jdrresources.numfield.*;

import uk.ac.uea.cmp.nlct.jpgfdraw.*;

/**
 * Dialog box for specifying new co-ordinates for a control point.
 * @author Nicola L C Talbot
 */
public class MovePointDialog extends JDialog
   implements ActionListener
{
   public MovePointDialog(JDRFrame frame)
   {
      super(frame.getApplication(),
         JDRResources.getString("coordinates.title"), true);
      frame_ = frame;

      locationPane = new LocationPane();

      getContentPane().add(locationPane, "Center");

      JPanel p2 = new JPanel();

      p2.add(JDRResources.createOkayButton(this));
      p2.add(JDRResources.createCancelButton(this));

      getContentPane().add(p2, "South");
      pack();
      setLocationRelativeTo(frame);
   }

   public void display()
   {
      canvas = frame_.getCanvas();
      JDRPoint point = canvas.getSelectedPoint();

      locationPane.setCoords(point.x, point.y, frame_.getUnit(),
        frame_.getPaper(), frame_.getGrid());

      setVisible(true);
   }

   public void okay()
   {
      canvas.setSelectedPoint(locationPane.getXCoord(), 
         locationPane.getYCoord());
      setVisible(false);
   }

   public void actionPerformed(ActionEvent e)
   {
      String action = e.getActionCommand();

      if (action == null) return;

      if (action.equals("okay"))
      {
         okay();
      } 
      else if (action.equals("cancel"))
      {
         setVisible(false);
      }
   }

   public String info()
   {
      String eol = System.getProperty("line.separator", "\n");

      String str = "";

      str += "MovePointDialog:"+eol;
      str += "has focus: "+hasFocus()+eol;

      return str+eol;
   }

   private JDRCanvas canvas;
   private JDRFrame frame_;

   private LocationPane locationPane;
}
