// File          : MarginPanel.java
// Description   : Panel for specifying margins
// Date          : 6th February 2006
// Last Modified : 9th June 2008
// Author        : Nicola L.C. Talbot
//                 http://theoval.cmp.uea.ac.uk/~nlct/

/*
    Copyright (C) 2006 Nicola L.C. Talbot

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
*/
package uk.ac.uea.cmp.nlct.jpgfdraw.dialog;

import java.awt.*;
import java.awt.event.*;

import javax.swing.*;
import javax.swing.event.*;

import uk.ac.uea.cmp.nlct.jdr.*;

import uk.ac.uea.cmp.nlct.jdrresources.*;
import uk.ac.uea.cmp.nlct.jdrresources.numfield.*;

/**
 * Panel for specifying margins.
 * @author Nicola L C Talbot
 */

public class MarginPanel extends JPanel
{
   public MarginPanel()
   {
      super();

      setLayout(new GridBagLayout());
      GridBagConstraints gbc = new GridBagConstraints();

      gbc.gridwidth  = 1;
      gbc.gridheight = 1;
      gbc.gridx      = 0;
      gbc.gridy      = 0;
      gbc.weightx    = 100;
      gbc.weighty    = 100;
      gbc.anchor     = GridBagConstraints.EAST;

      label = new JLabel(JDRResources.getString("flowframe.margins"));
      add(label, gbc);

      gbc.gridx = 1;
      gbc.gridy = 1;

      leftText = new NonNegativeLengthPanel(
         JDRResources.getString("flowframe.margin.left"),
         JDRResources.getChar("flowframe.margin.left.mnemonic"));
      add(leftText, gbc);

      gbc.gridx = 2;

      rightText = new NonNegativeLengthPanel(
         JDRResources.getString("flowframe.margin.right"),
         JDRResources.getChar("flowframe.margin.right.mnemonic"));
      add(rightText, gbc);

      gbc.gridx = 1;
      gbc.gridy = 2;

      topText = new NonNegativeLengthPanel(
         JDRResources.getString("flowframe.margin.top"),
         JDRResources.getChar("flowframe.margin.top.mnemonic"));
      add(topText, gbc);

      gbc.gridx = 2;
      bottomText = new NonNegativeLengthPanel(
         JDRResources.getString("flowframe.margin.bottom"),
         JDRResources.getChar("flowframe.margin.bottom.mnemonic"));
      add(bottomText, gbc);
   }

   public void setUnit(JDRUnit unit)
   {
      leftText.setUnit(unit);
      rightText.setUnit(unit);
      topText.setUnit(unit);
      bottomText.setUnit(unit);
   }

   public void setMargins(double left, double right,
                          double top, double bottom)
   {
      leftText.setValue(left);
      rightText.setValue(right);
      topText.setValue(top);
      bottomText.setValue(bottom);
   }

   public double left()
   {
      return leftText.getValue();
   }

   public double right()
   {
      return rightText.getValue();
   }

   public double top()
   {
      return topText.getValue();
   }

   public double bottom()
   {
      return bottomText.getValue();
   }

   public void setEnabled(boolean flag)
   {
      label.setEnabled(flag);
      leftText.setEnabled(flag);
      rightText.setEnabled(flag);
      topText.setEnabled(flag);
      bottomText.setEnabled(flag);
   }

   private NonNegativeLengthPanel leftText, rightText, topText, bottomText;
   private JLabel label;
}
