// File          : LocationPaneBox.java
// Description   : Tabbed pane in which to specify new location
// Date          : 2012-03-06
// Author        : Nicola L.C. Talbot
//                 http://theoval.cmp.uea.ac.uk/~nlct/

/*
    Copyright (C) 2006 Nicola L.C. Talbot

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
*/
package uk.ac.uea.cmp.nlct.jpgfdraw.dialog;

import java.awt.*;
import java.awt.event.*;

import javax.swing.*;
import javax.swing.event.*;
import javax.swing.border.*;

import uk.ac.uea.cmp.nlct.jdr.*;
import uk.ac.uea.cmp.nlct.jdrresources.*;
import uk.ac.uea.cmp.nlct.jdrresources.numfield.*;

import uk.ac.uea.cmp.nlct.jpgfdraw.*;

/**
 * Tabbed pane in which to specify a new location.
 * @author Nicola L C Talbot
 */
public class LocationPane extends JTabbedPane
   implements ChangeListener
{
   public LocationPane()
   {
      super();

      rectCoordPanel = new RectangularCoordPanel();

      add(rectCoordPanel, RECTANGULAR);
      setMnemonicAt(RECTANGULAR,
         JDRResources.getChar("grid.rectangular.mnemonic"));

      radialCoordPanel = new RadialCoordPanel();

      add(radialCoordPanel, RADIAL);
      setMnemonicAt(RADIAL,
         JDRResources.getChar("grid.radial.mnemonic"));

      addChangeListener(this);
   }

   public void stateChanged(ChangeEvent evt)
   {
      int old = current;

      current = getSelectedIndex();

      if (current != old)
      {
         CoordPanel coordPanel = (CoordPanel)getComponentAt(old);

         double x = coordPanel.getXCoord();
         double y = coordPanel.getYCoord();

         coordPanel = (CoordPanel)getComponentAt(current);

         coordPanel.setCoords(x, y, unit, paper);
      }
   }

   public void setCoords(double x, double y, JDRUnit unit, JDRPaper paper,
      JDRGrid grid)
   {
      this.grid  = grid;
      this.paper = paper;
      this.unit  = unit;

      rectCoordPanel.setCoords(x, y, unit, paper);
      radialCoordPanel.setCoords(x, y, unit, paper);

      if (grid instanceof JDRRectangularGrid)
      {
         setSelectedComponent(rectCoordPanel);
         current = RECTANGULAR;
      }
      else if (grid instanceof JDRRadialGrid)
      {
         setSelectedComponent(radialCoordPanel);
         current = RADIAL;
      }

      getCoordPanel().requestCoordFocus();
   }

   public double getXCoord()
   {
      return getCoordPanel().getXCoord();
   }

   public double getYCoord()
   {
      return getCoordPanel().getYCoord();
   }

   public CoordPanel getCoordPanel()
   {
      return (CoordPanel)getSelectedComponent();
   }

   private RectangularCoordPanel rectCoordPanel;
   private RadialCoordPanel radialCoordPanel;

   private JDRGrid grid;
   private JDRPaper paper;
   private JDRUnit unit;

   private static final int RECTANGULAR = 0;
   private static final int RADIAL = 1;

   private int current=0;
}
