// File          : LinearGradientDirectionPanel.java
// Description   : Panel for selecting linear gradient direction
// Date          : 6th February 2006
// Last Modified : 9th June 2008
// Author        : Nicola L.C. Talbot
//                 http://theoval.cmp.uea.ac.uk/~nlct/

/*
    Copyright (C) 2006 Nicola L.C. Talbot

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
*/
package uk.ac.uea.cmp.nlct.jpgfdraw.dialog;

import java.awt.*;
import java.awt.event.*;

import javax.swing.*;
import javax.swing.event.*;

import uk.ac.uea.cmp.nlct.jdr.*;

import uk.ac.uea.cmp.nlct.jdrresources.*;

/**
 * Panel for selecting linear gradient direction.
 * @author Nicola L C Talbot
 */

public class LinearGradientDirectionPanel extends JPanel
   implements ActionListener
{
   public LinearGradientDirectionPanel()
   {
      super(new FlowLayout(FlowLayout.LEFT,0,0));

      ButtonGroup directionGroup = new ButtonGroup();

      gNorth = new DirectionButton(
         JDRResources.appIcon("north.png"),
         JDRResources.appIcon("north_sel.png"),
         JDRGradient.NORTH,
         true);

      gradientDir = JDRGradient.NORTH;
      directionGroup.add(gNorth);
      add(gNorth);
      gNorth.addActionListener(this);
      gNorth.setMnemonic('1');
      gNorth.setToolTipText(JDRResources.getString(
         "tooltip.direction.linear.north"));

      gNorthEast = new DirectionButton(
         JDRResources.appIcon("northeast.png"),
         JDRResources.appIcon("northeast_sel.png"),
         JDRGradient.NORTH_EAST);

      directionGroup.add(gNorthEast);
      add(gNorthEast);
      gNorthEast.addActionListener(this);
      gNorthEast.setMnemonic('2');
      gNorthEast.setToolTipText(JDRResources.getString(
         "tooltip.direction.linear.northeast"));

      gEast = new DirectionButton(
         JDRResources.appIcon("east.png"),
         JDRResources.appIcon("east_sel.png"),
         JDRGradient.EAST);

      directionGroup.add(gEast);
      add(gEast);
      gEast.addActionListener(this);
      gEast.setMnemonic('3');
      gEast.setToolTipText(JDRResources.getString(
         "tooltip.direction.linear.east"));

      gSouthEast = new DirectionButton(
         JDRResources.appIcon("southeast.png"),
         JDRResources.appIcon("southeast_sel.png"),
         JDRGradient.SOUTH_EAST);

      directionGroup.add(gSouthEast);
      add(gSouthEast);
      gSouthEast.addActionListener(this);
      gSouthEast.setMnemonic('4');
      gSouthEast.setToolTipText(JDRResources.getString(
         "tooltip.direction.linear.southeast"));

      gSouth = new DirectionButton(
         JDRResources.appIcon("south.png"),
         JDRResources.appIcon("south_sel.png"),
         JDRGradient.SOUTH);

      directionGroup.add(gSouth);
      add(gSouth);
      gSouth.addActionListener(this);
      gSouth.setMnemonic('5');
      gSouth.setToolTipText(JDRResources.getString(
         "tooltip.direction.linear.south"));

      gSouthWest = new DirectionButton(
         JDRResources.appIcon("southwest.png"),
         JDRResources.appIcon("southwest_sel.png"),
         JDRGradient.SOUTH_WEST);

      directionGroup.add(gSouthWest);
      add(gSouthWest);
      gSouthWest.addActionListener(this);
      gSouthWest.setMnemonic('6');
      gSouthWest.setToolTipText(JDRResources.getString(
         "tooltip.direction.linear.southwest"));

      gWest = new DirectionButton(
         JDRResources.appIcon("west.png"),
         JDRResources.appIcon("west_sel.png"),
         JDRGradient.WEST);

      directionGroup.add(gWest);
      add(gWest);
      gWest.addActionListener(this);
      gWest.setMnemonic('7');
      gWest.setToolTipText(JDRResources.getString(
         "tooltip.direction.linear.west"));

      gNorthWest = new DirectionButton(
         JDRResources.appIcon("northwest.png"),
         JDRResources.appIcon("northwest_sel.png"),
         JDRGradient.NORTH_WEST);

      directionGroup.add(gNorthWest);
      add(gNorthWest);
      gNorthWest.addActionListener(this);
      gNorthWest.setMnemonic('8');
      gNorthWest.setToolTipText(JDRResources.getString(
         "tooltip.direction.linear.northwest"));
   }

   public void addActionListener(ActionListener listener)
   {
      gNorth.addActionListener(listener);
      gNorthEast.addActionListener(listener);
      gEast.addActionListener(listener);
      gSouthEast.addActionListener(listener);
      gSouth.addActionListener(listener);
      gSouthWest.addActionListener(listener);
      gWest.addActionListener(listener);
      gNorthWest.addActionListener(listener);
   }

   public void setEnabled(boolean flag)
   {
      super.setEnabled(flag);
      gNorth.setEnabled(flag);
      gNorthEast.setEnabled(flag);
      gEast.setEnabled(flag);
      gSouthEast.setEnabled(flag);
      gSouth.setEnabled(flag);
      gSouthWest.setEnabled(flag);
      gWest.setEnabled(flag);
      gNorthWest.setEnabled(flag);
   }

   public void actionPerformed(ActionEvent e)
   {
      Object source = e.getSource();

      if (source instanceof DirectionButton)
      {
         gradientDir = ((DirectionButton)source).getDirection();
      }
   }

   public int getDirection()
   {
      return gradientDir;
   }

   public void setDirection(int direction)
   {
      gradientDir = direction;

      switch (gradientDir)
      {
         case JDRGradient.NORTH :
            gNorth.setSelected(true);
         break;
         case JDRGradient.SOUTH :
            gSouth.setSelected(true);
         break;
         case JDRGradient.EAST :
            gEast.setSelected(true);
         break;
         case JDRGradient.WEST :
            gWest.setSelected(true);
         break;
         case JDRGradient.NORTH_WEST :
            gNorthWest.setSelected(true);
         break;
         case JDRGradient.SOUTH_EAST :
            gSouthEast.setSelected(true);
         break;
         case JDRGradient.NORTH_EAST :
            gNorthEast.setSelected(true);
         break;
         case JDRGradient.SOUTH_WEST :
            gSouthWest.setSelected(true);
      }
   }

   private int gradientDir;

   private DirectionButton gNorth, gSouth, gEast, gWest;
   private DirectionButton gNorthWest, gSouthEast;
   private DirectionButton gNorthEast, gSouthWest;
}
