// File          : LineWidthPanel.java
// Description   : Panel to set line width
// Date          : 6th February 2006
// Last Modified : 9th June 2008
// Author        : Nicola L.C. Talbot
//                 http://theoval.cmp.uea.ac.uk/~nlct/

/*
    Copyright (C) 2006 Nicola L.C. Talbot

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
*/
package uk.ac.uea.cmp.nlct.jpgfdraw.dialog;

import java.awt.*;
import java.awt.event.*;

import javax.swing.*;
import javax.swing.event.*;

import uk.ac.uea.cmp.nlct.jdr.*;

import uk.ac.uea.cmp.nlct.jdrresources.*;
import uk.ac.uea.cmp.nlct.jdrresources.numfield.*;

import uk.ac.uea.cmp.nlct.jpgfdraw.*;
/**
 * Panel for setting line width.
 * @author Nicola L C Talbot
 */
public class LineWidthPanel extends JPanel
{
   public LineWidthPanel(JDRSelector selector)
   {
      super();

      selector_ = selector;

      // JDRLine thickness

      lineWidthPanel = new NonNegativeLengthPanel(
         JDRResources.getString("linestyle.thickness")+" ",
         JDRResources.getChar("linestyle.thickness.mnemonic"),
         selector_.getSamplePathPanel());
      lineWidthPanel.getTextField().setColumns(2);
      lineWidthPanel.getTextField().requestFocusInWindow();

      add(lineWidthPanel);

   }

   public JDRBasicStroke getStroke()
   {
      JDRFrame frame = selector_.application_.getCurrentFrame();

      JDRBasicStroke stroke;

      if (frame == null)
      {
         stroke = new JDRBasicStroke();
      }
      else
      {
         stroke = (JDRBasicStroke)frame.getSelectedStroke().clone();
      }

      try
      {
         stroke.setPenWidth(getPenWidth());
      }
      catch (Exception e)
      {
         JDRResources.internalError(null, e);
      }

      return stroke;
   }

   public void setStroke(JDRBasicStroke stroke)
   {
      setPenWidth(stroke.getPenWidth());
   }

   public double getPenWidth()
   {
      return lineWidthPanel.getValue();
   }

   public void setPenWidth(double width)
   {
      lineWidthPanel.setValue(width);
   }

   public void setDefaults()
   {
      setPenWidth(1.0);
   }

   // pen thickness
   private NonNegativeLengthPanel lineWidthPanel;

   private JDRSelector selector_;
}
