// File          : LineStyleSelector.java
// Description   : Dialog for setting line style
// Date          : 6th February 2006
// Last Modified : 13th August 2008
// Author        : Nicola L.C. Talbot
//                 http://theoval.cmp.uea.ac.uk/~nlct/

/*
    Copyright (C) 2006 Nicola L.C. Talbot

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
*/
package uk.ac.uea.cmp.nlct.jpgfdraw.dialog;

import java.awt.*;
import java.awt.event.*;

import javax.swing.*;
import javax.swing.event.*;
import javax.swing.border.*;

import uk.ac.uea.cmp.nlct.jdr.*;
import uk.ac.uea.cmp.nlct.jdr.marker.*;

import uk.ac.uea.cmp.nlct.jdrresources.*;

import uk.ac.uea.cmp.nlct.jpgfdraw.*;

/**
 * Dialog for setting line style.
 * @author Nicola L C Talbot
 */

public class LineStyleSelector extends JDRSelector
{
   public LineStyleSelector(JpgfDraw application)
   {
      super(application,JDRResources.getString("linestyle.title"),
            true,false);

      JpgfDraw.enableHelpOnButton(help, "sec:linestyle");

      // line style selection panel

      linestylePanel = new LineStylePanel(this);

      linestylePanel.setBorder(
         BorderFactory.createLoweredBevelBorder());
      setToMain(linestylePanel);

      pack();
      setLocationRelativeTo(application);
   }

   public void initialise()
   {
      JDRFrame mainPanel = application_.getCurrentFrame();
      setStroke(mainPanel.getSelectedStroke());
      super.initialise();
   }

   public void okay()
   {
      int joinStyle = linestylePanel.getJoinStyle();

      if (joinStyle == BasicStroke.JOIN_MITER
        && linestylePanel.getEnteredMitreLimit() < 1.0)
      {
         JDRResources.error(this,
            JDRResources.getString("error.invalid_mitre_limit"));
         return;
      }

      JDRFrame mainPanel = application_.getCurrentFrame();
      mainPanel.setSelectedStroke(getStroke());
      super.okay();
   }

   public JDRBasicStroke getStroke()
   {
      if (linestylePanel == null)
      {
         return null;
      }

      return linestylePanel.getStroke();
   }

   public void setStroke(JDRBasicStroke stroke)
   {
      linestylePanel.setStroke(stroke);
   }

   public void setDefaults()
   {
      linestylePanel.setDefaults();
   }

   public String info()
   {
      String eol = System.getProperty("line.separator", "\n");

      String str = "";

      str = "LineStyleSelector:"+eol;

      return str+super.info();
   }

   private LineStylePanel linestylePanel;
}
