// File          : JoinStylePanel.java
// Description   : Panel for selecting join style
// Date          : 6th February 2006
// Last Modified : 9th June 2008
// Author        : Nicola L.C. Talbot
//                 http://theoval.cmp.uea.ac.uk/~nlct/

/*
    Copyright (C) 2006 Nicola L.C. Talbot

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
*/
package uk.ac.uea.cmp.nlct.jpgfdraw.dialog;

import java.awt.*;
import java.awt.event.*;

import javax.swing.*;
import javax.swing.event.*;

import uk.ac.uea.cmp.nlct.jdr.*;

import uk.ac.uea.cmp.nlct.jdrresources.*;
import uk.ac.uea.cmp.nlct.jdrresources.numfield.*;

import uk.ac.uea.cmp.nlct.jpgfdraw.*;
/**
 * Panel for selecting join style.
 * @author Nicola L C Talbot
 */

public class JoinStylePanel extends JPanel implements ItemListener
{
   public JoinStylePanel(JDRSelector selector)
   {
      selector_ = selector;

      JLabel joinStylesLabel 
         = new JLabel(JDRResources.getString("linestyle.join"));
      add(joinStylesLabel);

      joinStylesLabel.setDisplayedMnemonic(
         JDRResources.getChar("linestyle.join.mnemonic"));

      String[] joinStyles = {
         JDRResources.getString("linestyle.join.mitre"),
         JDRResources.getString("linestyle.join.round"),
         JDRResources.getString("linestyle.join.bevel")};
      //joinStyleBox = new JComboBox<String>(joinStyles);// Java7
      joinStyleBox = new JComboBox(joinStyles);
      add(joinStyleBox);

      joinStyleBox.addItemListener(this);

      mitreLimitLabel 
         = new JLabel(JDRResources.getString("linestyle.mitre_limit"));
      mitreLimitLabel.setDisplayedMnemonic(
         JDRResources.getChar("linestyle.mitre_limit.mnemonic"));

      add(mitreLimitLabel);

      mitreLimitField = new NonNegativeDoubleField(10);
      mitreLimitLabel.setLabelFor(mitreLimitField);
      mitreLimitField.getDocument().addDocumentListener(
          new TextFieldSampleListener(
             selector_.getSamplePathPanel()));

      add(mitreLimitField);

   }

   public void itemStateChanged(ItemEvent e)
   {
      Object source = e.getSource();

      if (source == joinStyleBox)
      {
         boolean flag = (getJoinStyle() == BasicStroke.JOIN_MITER);

         mitreLimitLabel.setEnabled(flag);
         mitreLimitField.setEnabled(flag);
      }

      selector_.repaintSample();
   }

   public JDRBasicStroke getStroke()
   {
      JDRFrame frame = selector_.application_.getCurrentFrame();

      JDRBasicStroke stroke;

      if (frame == null)
      {
         stroke = new JDRBasicStroke();
      }
      else
      {
         stroke = (JDRBasicStroke)frame.getSelectedStroke().clone();
      }

      int style = getJoinStyle();

      try
      {
         stroke.setJoinStyle(style);
      }
      catch (InvalidJoinStyleException e)
      {
      }

      if (style == BasicStroke.JOIN_MITER)
      {
         try
         {
            stroke.setMitreLimit(getMitreLimit());
         }
         catch (InvalidMitreLimitException e)
         {
         }
      }

      return stroke;
   }

   public void setStroke(JDRBasicStroke stroke)
   {
      int style = stroke.getJoinStyle();
      setJoinStyle(style);

      if (style == BasicStroke.JOIN_MITER)
      {
         setMitreLimit(stroke.getMitreLimit());
      }
   }

   public int getJoinStyle()
   {
      return joinStyleBox.getSelectedIndex();
   }

   public void setJoinStyle(int style)
   {
      joinStyleBox.setSelectedIndex(style);
   }

   protected double getEnteredMitreLimit()
   {
      return mitreLimitField.getValue();
   }

   public double getMitreLimit()
   {
      double limit = mitreLimitField.getValue();

      return limit < 1 ? 1.0 : limit;
   }

   public void setMitreLimit(double limit)
   {
      mitreLimitField.setValue(limit < 1 ? 1.0 : limit);
   }

   public void setDefaults()
   {
      setJoinStyle(BasicStroke.JOIN_MITER);
      setMitreLimit(10.0f);
   }

   private JDRSelector selector_;

   //private JComboBox joinStyleBox;// Java7
   private JComboBox joinStyleBox;
   private JLabel mitreLimitLabel;
   private NonNegativeDoubleField mitreLimitField;
}
