// File          : GridSettings.java
// Description   : Dialog in which to specify the grid settings
// Date          : 1st February 2006
// Last Modified : 16th August 2010
// Author        : Nicola L.C. Talbot
//                 http://theoval.cmp.uea.ac.uk/~nlct/

/*
    Copyright (C) 2006 Nicola L.C. Talbot

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
*/
package uk.ac.uea.cmp.nlct.jpgfdraw.dialog;

import java.awt.*;
import java.awt.geom.*;
import java.awt.event.*;

import javax.swing.*;
import javax.swing.event.*;

import uk.ac.uea.cmp.nlct.jdr.*;
import uk.ac.uea.cmp.nlct.jdrresources.*;
import uk.ac.uea.cmp.nlct.jdrresources.numfield.*;

import uk.ac.uea.cmp.nlct.jpgfdraw.*;

/**
 * Dialog in which to specify grid settings.
 * @author Nicola L C Talbot
 */
public class GridSettings extends JDialog
   implements ActionListener
{
   public GridSettings(JpgfDraw application)
   {
      super(application, JDRResources.getString("grid.title"),
            true);
      application_ = application;

      rectangularGridPanel = new RectangularGridPanel();

      radialGridPanel = new RadialGridPanel();

      tabbedPane = new JTabbedPane();

      tabbedPane.addTab(JDRResources.getString("grid.rectangular"),
         null, rectangularGridPanel,
        JDRResources.getString("tooltip.grid.rectangular"));

      tabbedPane.setMnemonicAt(0,
         JDRResources.getChar("grid.rectangular.mnemonic"));

      tabbedPane.addTab(JDRResources.getString("grid.radial"),
         null, radialGridPanel,
         JDRResources.getString("tooltip.grid.radial"));

      tabbedPane.setMnemonicAt(1,
         JDRResources.getChar("grid.radial.mnemonic"));

      getContentPane().add(tabbedPane, "Center");

      JPanel p2 = new JPanel();

      p2.add(JDRResources.createOkayButton(this));
      p2.add(JDRResources.createCancelButton(this));
      p2.add(JDRResources.createHelpButton("sec:grid"));

      getContentPane().add(p2, "South");

      pack();
      setLocationRelativeTo(application_);
   }

   public void initialise()
   {
      mainPanel = application_.getCurrentFrame();

      JDRGrid grid = mainPanel.getGrid();

      GridPanel gridPanel;

      if (grid instanceof JDRRectangularGrid)
      {
         gridPanel = rectangularGridPanel;
      }
      else
      {
         gridPanel = radialGridPanel;
      }

      gridPanel.setGrid(grid);
      tabbedPane.setSelectedComponent(gridPanel);

      setVisible(true);

      gridPanel.requestDefaultFieldFocus();
   }

   public void okay()
   {
      JDRGrid grid = mainPanel.getGrid();

      GridPanel panel = (GridPanel)tabbedPane.getSelectedComponent();

      grid = panel.getGrid(grid);

      if (grid == null)
      {
         return;
      }

      mainPanel.setGrid(grid);

      setVisible(false);
   }

   public void actionPerformed(ActionEvent e)
   {
      String action = e.getActionCommand();

      if (action == null) return;

      if (action.equals("okay"))
      {
         okay();
      } 
      else if (action.equals("cancel"))
      {
         setVisible(false);
      }
   }

   private JpgfDraw application_;

   private JTabbedPane tabbedPane;

   private GridPanel rectangularGridPanel, radialGridPanel;

   private JDRFrame mainPanel = null;
}
