// File          : FontSizePanel.java
// Description   : Panel for selecting font size
// Date          : 6th February 2006
// Last Modified : 9th June 2008
// Author        : Nicola L.C. Talbot
//                 http://theoval.cmp.uea.ac.uk/~nlct/

/*
    Copyright (C) 2006 Nicola L.C. Talbot

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
*/
package uk.ac.uea.cmp.nlct.jpgfdraw.dialog;

import java.awt.*;
import java.awt.event.*;

import javax.swing.*;
import javax.swing.event.*;

import uk.ac.uea.cmp.nlct.jdr.*;

import uk.ac.uea.cmp.nlct.jdrresources.*;
import uk.ac.uea.cmp.nlct.jdrresources.numfield.*;

/**
 * Panel for selecting marker style.
 * @author Nicola L C Talbot
 */

public class FontSizePanel extends JPanel implements DocumentListener
{
   public FontSizePanel(JDRSelector selector)
   {
      super();

      selector_ = selector;
      latexFonts_ = new LaTeXFontBase(10);

      JLabel fontSizeLabel 
         = new JLabel(JDRResources.getString("font.size"));
      fontSizeLabel.setDisplayedMnemonic(
         JDRResources.getChar("font.size.mnemonic"));
      add(fontSizeLabel);

      fontSizePanel = new NonNegativeLengthPanel(
         selector_.getSampleTextPanel());
      fontSizePanel.getDocument().addDocumentListener(this);
      fontSizePanel.setValue(
         latexFonts_.getFontSize(LaTeXFontBase.NORMALSIZE));
      fontSizeLabel.setLabelFor(fontSizePanel.getTextField());
      fontSizePanel.getTextField().setColumns(3);

      add(fontSizePanel);

      //latexFontSize = new JComboBox<String>(// Java7
      latexFontSize = new JComboBox(
         new String[]
         {
            "\\tiny",
            "\\scriptsize",
            "\\footnotesize",
            "\\small",
            "\\normalsize",
            "\\large",
            "\\Large",
            "\\LARGE",
            "\\huge",
            "\\Huge",
            "\\veryHuge",
            "\\VeryHuge",
            "\\VERYHuge"
         }
      );
      latexFontSize.setToolTipText(
         JDRResources.getString("tooltip.latex_font_size"));
      latexFontSize.setEditable(true);
      add(latexFontSize);
   }

   public void setLaTeXFonts(LaTeXFontBase latexFonts)
   {
      latexFonts_ = latexFonts;

      fontSizePanel.setValue(
          latexFonts_.getFontSize(LaTeXFontBase.NORMALSIZE));
   }

   public void setNormalSize(int size)
   {
      fontSizePanel.setValue(size);
   }

   public void updateLaTeXSize()
   {
      String str = latexFonts_.getLaTeXCmd(fontSizePanel.getValue());
      if (latexFontSize != null) latexFontSize.setSelectedItem(str);
   }

   public void insertUpdate(DocumentEvent e)
   {
      updateLaTeXSize();
   }

   public void removeUpdate(DocumentEvent e)
   {
      updateLaTeXSize();
   }

   public void changedUpdate(DocumentEvent e)
   {
      updateLaTeXSize();
   }

   public int getFontSize()
   {
      return (int)fontSizePanel.getValue();
   }

   public void setFontSize(int size)
   {
      fontSizePanel.setValue(size);
   }

   public void setLaTeXFontSize(String size)
   {
      latexFontSize.setSelectedItem(size);
   }

   public String getLaTeXFontSize()
   {
      return (String)latexFontSize.getSelectedItem();
   }

   public void setDefaults()
   {
      setNormalSize(
          (int)latexFonts_.getFontSize(LaTeXFontBase.NORMALSIZE));
   }

   private JDRSelector selector_;

   // font size
   private NonNegativeLengthPanel fontSizePanel;
   //private JComboBox<String> latexFontSize; // Java7
   private JComboBox latexFontSize;

   private LaTeXFontBase latexFonts_;
}
