// File          : FontSeriesPanel.java
// Description   : Panel for selecting font series
// Date          : 6th February 2006
// Last Modified : 9th June 2008
// Author        : Nicola L.C. Talbot
//                 http://theoval.cmp.uea.ac.uk/~nlct/

/*
    Copyright (C) 2006 Nicola L.C. Talbot

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
*/
package uk.ac.uea.cmp.nlct.jpgfdraw.dialog;

import java.awt.*;
import java.awt.event.*;

import javax.swing.*;
import javax.swing.event.*;

import uk.ac.uea.cmp.nlct.jdr.*;

import uk.ac.uea.cmp.nlct.jdrresources.*;

/**
 * Panel for selecting font series.
 * @author Nicola L C Talbot
 */

public class FontSeriesPanel extends JPanel implements ItemListener
{
   public FontSeriesPanel(JDRSelector selector)
   {
      selector_ = selector;

      JLabel fontSeriesLabel 
         = new JLabel(JDRResources.getString("font.series"));
      fontSeriesLabel.setDisplayedMnemonic(
         JDRResources.getChar("font.series.mnemonic"));
      add(fontSeriesLabel);

      //fontSeries = new JComboBox<String>(// Java7
      fontSeries = new JComboBox(
         new String[] {JDRResources.getString("font.series.medium"),
                       JDRResources.getString("font.series.bold")});
      fontSeriesLabel.setLabelFor(fontSeries);
      add(fontSeries);

      fontSeries.addItemListener(this);

      //latexFontSeries = new JComboBox<String>(// Java7
      latexFontSeries = new JComboBox(
         new String[]
         {
            "\\mdseries",
            "\\bfseries"
         }
      );
      latexFontSeries.setToolTipText(
         JDRResources.getString("tooltip.latex_font_series"));
      latexFontSeries.setEditable(true);
      add(latexFontSeries);
   }

   public void itemStateChanged(ItemEvent evt)
   {
      Object source = evt.getSource();

      if (evt.getStateChange() == ItemEvent.SELECTED)
      {
         if (source == fontSeries)
         {
            int series = fontSeries.getSelectedIndex();
            latexFontSeries.setSelectedIndex(series);
         }

         selector_.repaintSample();
      }
   }

   public void setFontSeries(int series)
   {
      fontSeries.setSelectedIndex(series);
   }

   public int getFontSeries()
   {
      return fontSeries.getSelectedIndex();
   }

   public void setLaTeXFontSeries(String series)
   {
      latexFontSeries.setSelectedItem(series);
   }

   public String getLaTeXFontSeries()
   {
      return (String)latexFontSeries.getSelectedItem();
   }

   public void setDefaults()
   {
      setFontSeries(JDRFont.SERIES_MEDIUM);
   }

   private JDRSelector selector_;
   //private JComboBox<String> fontSeries, latexFontSeries;// Java7
   private JComboBox fontSeries, latexFontSeries;
}
