// File          : FontHAnchorPanel.java
// Description   : Panel for selecting font anchor
// Date          : 2nd July 2008
// Last Modified : 2nd July 2008
// Author        : Nicola L.C. Talbot
//                 http://theoval.cmp.uea.ac.uk/~nlct/

/*
    Copyright (C) 2006 Nicola L.C. Talbot

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
*/
package uk.ac.uea.cmp.nlct.jpgfdraw.dialog;

import java.awt.*;
import java.awt.event.*;

import javax.swing.*;
import javax.swing.event.*;

import uk.ac.uea.cmp.nlct.jdr.*;

import uk.ac.uea.cmp.nlct.jdrresources.*;
import uk.ac.uea.cmp.nlct.jdrresources.numfield.*;

/**
 * Panel for selecting font anchor (horizontal setting only).
 * @author Nicola L C Talbot
 */

public class FontHAnchorPanel extends JPanel
   implements ItemListener
{
   private FontHAnchorPanel()
   {
   }

   public FontHAnchorPanel(JDRSelector selector)
   {
      selector_ = selector;

      BoxLayout layout = new BoxLayout(this, BoxLayout.Y_AXIS);
      setLayout(layout);

      JPanel p1 = new JPanel();

      JLabel pgfTextLabel = new JLabel(
         JDRResources.getString("font.hanchor"));
      pgfTextLabel.setDisplayedMnemonic(
         JDRResources.getChar("font.hanchor.mnemonic"));

      p1.add(pgfTextLabel);

      //pgfHalign = new JComboBox<String>(// Java7
      pgfHalign = new JComboBox(
         new String[] {JDRResources.getString("font.anchor.left"),
                       JDRResources.getString("font.anchor.hcentre"),
                       JDRResources.getString("font.anchor.right")});

      pgfTextLabel.setLabelFor(pgfHalign);
      pgfHalign.addItemListener(this);

      p1.add(pgfHalign);

      add(p1);

      JTextField message = new JTextField(
         JDRResources.getString("font.anchor_message"));

      message.setEditable(false);
      message.setFocusable(false);
      message.setBorder(null);
      add(message);
   }

   public void itemStateChanged(ItemEvent evt)
   {
      Object source = evt.getSource();

      if (evt.getStateChange() == ItemEvent.SELECTED)
      {
         selector_.repaintSample();
      }
   }

   public void setHalign(int align)
   {
      pgfHalign.setSelectedIndex(align);
   }

   public int getHalign()
   {
      return pgfHalign.getSelectedIndex();
   }

   public void setDefaults()
   {
      setHalign(JDRText.PGF_HALIGN_LEFT);
   }

   //private JComboBox<String> pgfHalign; // Java 7
   private JComboBox pgfHalign;

   private JDRSelector selector_;
}
