// File          : FindByDescriptionDialogBox.java
// Description   : Dialog box for finding an object from its description
// Date          : 1st February 2006
// Last Modified : 9th June 2008
// Author        : Nicola L.C. Talbot
//                 http://theoval.cmp.uea.ac.uk/~nlct/

/*
    Copyright (C) 2006 Nicola L.C. Talbot

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
*/
package uk.ac.uea.cmp.nlct.jpgfdraw.dialog;

import java.awt.*;
import java.awt.event.*;

import javax.swing.*;
import javax.swing.event.*;
import javax.swing.border.*;

import uk.ac.uea.cmp.nlct.jdr.*;
import uk.ac.uea.cmp.nlct.jdrresources.*;

import uk.ac.uea.cmp.nlct.jpgfdraw.*;

/**
 * Dialog box for finding an object by its description.
 * @author Nicola L C Talbot
 */
public class FindByDescriptionDialogBox extends JDialog
   implements ActionListener
{
   public FindByDescriptionDialogBox(JpgfDraw application)
   {
      super(application, JDRResources.getString("findbydescription.title"),
            true);
      application_ = application;

      //descriptionModel = new DefaultComboBoxModel<String>(); //Java7
      //descriptionBox = new JComboBox<String>(descriptionModel); //Java7     
      descriptionModel = new DefaultComboBoxModel();
      descriptionBox = new JComboBox(descriptionModel);      

      getContentPane().add(descriptionBox, "Center");

      JPanel p2 = new JPanel();

      p2.add(JDRResources.createOkayButton(this));
      p2.add(JDRResources.createCancelButton(this));

      getContentPane().add(p2, "South");
      pack();
      Dimension dim = getSize();
      if (dim.width < 300)
      {
         dim.width = 300;
         setSize(dim);
      }
      setLocationRelativeTo(application);
   }

   public void initialise(boolean deselect)
   {
      mainPanel = application_.getCurrentFrame();
      descriptionModel.removeAllElements();
      paths = mainPanel.getAllPaths();
      deselect_ = deselect;

      for (int i = 0, n = paths.size(); i < n; i++)
      {
         JDRCompleteObject object = paths.get(i); 
         String description = "";

         if (!object.description.equals(""))
         {
            description = object.description;
         }
         else if (object.flowframe == null)
         {
            String tag = object.getClass().getName().toLowerCase()
               .substring(object.getClass().getPackage().getName().length()+4);

            description = JDRResources.getStringWithValue(
              "findbydescription." + tag,
               object.getDescriptionInfo());
         }
         else
         {
            switch (object.flowframe.getType())
            {
               case FlowFrame.STATIC:
                  description += JDRResources.getString("flowframe.static");
               break;
               case FlowFrame.FLOW:
                  description += JDRResources.getString("flowframe.flow");
               break;
               case FlowFrame.DYNAMIC:
                  description += JDRResources.getString("flowframe.dynamic");
               break;
            }
            description += " \""+object.flowframe.label+"\"";
         }

         descriptionModel.addElement(description);
      }
      descriptionBox.requestFocusInWindow();
      setVisible(true);
   }

   public void okay()
   {
      int i = descriptionBox.getSelectedIndex();
      if (deselect_)
      {
         mainPanel.deselectAll();
      }
      mainPanel.selectObjectAndScroll(paths.get(i));
      setVisible(false);
   }

   public void actionPerformed(ActionEvent e)
   {
      String action = e.getActionCommand();

      if (action == null) return;

      if (action.equals("okay"))
      {
         okay();
      } 
      else if (action.equals("cancel"))
      {
         setVisible(false);
      }
   }

   //private JComboBox<String> descriptionBox;// Java7
   //private DefaultComboBoxModel<String> descriptionModel;//Java7
   private JComboBox descriptionBox;
   private DefaultComboBoxModel descriptionModel;
   private JpgfDraw application_;
   private JDRFrame mainPanel = null;
   private JDRGroup paths;
   private boolean deselect_=true;
}
