// File          : FLFSetTypeblock.java
// Description   : Dialog for setting typeblock
// Date          : 6th February 2006
// Last Modified : 9th June 2008
// Author        : Nicola L.C. Talbot
//                 http://theoval.cmp.uea.ac.uk/~nlct/

/*
    Copyright (C) 2006 Nicola L.C. Talbot

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
*/
package uk.ac.uea.cmp.nlct.jpgfdraw.dialog;

import java.awt.*;
import java.awt.event.*;

import javax.swing.*;
import javax.swing.event.*;
import javax.swing.border.*;

import uk.ac.uea.cmp.nlct.jdr.*;

import uk.ac.uea.cmp.nlct.jdrresources.*;

import uk.ac.uea.cmp.nlct.jpgfdraw.*;

/**
 * Dialog for setting typeblock.
 * @author Nicola L C Talbot
 */

public class FLFSetTypeblock extends JDialog
   implements ActionListener
{
   public FLFSetTypeblock(JpgfDraw application)
   {
      super(application, JDRResources.getString("typeblock.title"),true);
      application_ = application;

      int width = 400;
      int height = 150;
      setSize(width,height);

      margins = new MarginPanel();

      getContentPane().add(margins, "Center");

      JPanel p2 = new JPanel();

      p2.add(JDRResources.createOkayButton(this));
      p2.add(JDRResources.createCancelButton(this));
      p2.add(JDRResources.createHelpButton("sec:typeblock"));

      getContentPane().add(p2, "South");

      setLocationRelativeTo(application);
   }

   public void initialise()
   {
      if (typeblock == null)
      {
         JDRFrame mainPanel = application_.getCurrentFrame();
         typeblock = mainPanel.getTypeblock();

         JDRUnit unit = mainPanel.getUnit();
         margins.setUnit(unit);
      }

      if (typeblock != null)
      {
         margins.setMargins(typeblock.left,
                            typeblock.right,
                            typeblock.top,
                            typeblock.bottom);
      }
      else
      {
         margins.setMargins(0.0f,0.0f,0.0f,0.0f);
      }
      setVisible(true);
   }

   public void okay()
   {
      JDRFrame mainPanel = application_.getCurrentFrame();
      setVisible(false);
      mainPanel.setTypeblock(margins.left(), margins.right(),
                             margins.top(), margins.bottom());
   }

   public void actionPerformed(ActionEvent evt)
   {
      String action = evt.getActionCommand();

      if (action == null) return;

      if (action.equals("okay"))
      {
         okay();
      }
      else if (action.equals("cancel"))
      {
         setVisible(false);
      }
   }

   private JpgfDraw application_;
   private MarginPanel margins;
   private FlowFrame typeblock;
}
