// File          : DisplayPageDialog.java
// Description   : Dialog to specify which pages to display
// Date          : 1st February 2006
// Last Modified : 9th June 2008
// Author        : Nicola L.C. Talbot
//                 http://theoval.cmp.uea.ac.uk/~nlct/

/*
    Copyright (C) 2006 Nicola L.C. Talbot

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
*/
package uk.ac.uea.cmp.nlct.jpgfdraw.dialog;

import java.awt.*;
import java.awt.event.*;

import javax.swing.*;
import javax.swing.event.*;
import javax.swing.border.*;

import uk.ac.uea.cmp.nlct.jdrresources.*;
import uk.ac.uea.cmp.nlct.jdrresources.numfield.*;

import uk.ac.uea.cmp.nlct.jpgfdraw.*;

/**
 * Display pages dialog box.
 * This dialog box is used to specify whether to show objects that
 * have flowframe data defined on: all pages, odd pages, even
 * pages or a specific page number.
 * @author Nicola L C Talbot
 */
public class DisplayPageDialog extends JDialog
   implements ActionListener
{
   public DisplayPageDialog(JpgfDraw application)
   {
      super(application,
            JDRResources.getString("displaypage.title"),true);
      application_ = application;

      JPanel p1 = new JPanel();
      p1.setLayout(new BoxLayout(p1, BoxLayout.PAGE_AXIS));
      p1.setAlignmentX(Component.LEFT_ALIGNMENT);

      JLabel label = new JLabel(
         JDRResources.getString("displaypage.label"));
      label.setAlignmentX(Component.LEFT_ALIGNMENT);
      p1.add(label);

      JPanel optionPanel = new JPanel();
      optionPanel.setAlignmentX(Component.LEFT_ALIGNMENT);
      p1.add(optionPanel);

      ButtonGroup group = new ButtonGroup();

      allButton = new JRadioButton(
         JDRResources.getString("displaypage.all"), true);

      allButton.setMnemonic(
         JDRResources.getChar("displaypage.all.mnemonic"));
      allButton.addActionListener(this);
      allButton.setActionCommand("disableuser");
      group.add(allButton);
      optionPanel.add(allButton);

      oddButton = new JRadioButton(
         JDRResources.getString("displaypage.odd"), false);
      oddButton.setMnemonic(
         JDRResources.getChar("displaypage.odd.mnemonic"));
      oddButton.addActionListener(this);
      oddButton.setActionCommand("disableuser");
      group.add(oddButton);
      optionPanel.add(oddButton);

      evenButton = new JRadioButton(
         JDRResources.getString("displaypage.even"), false);
      evenButton.setMnemonic(
         JDRResources.getChar("displaypage.even.mnemonic"));
      evenButton.addActionListener(this);
      evenButton.setActionCommand("disableuser");
      group.add(evenButton);
      optionPanel.add(evenButton);

      userButton = new JRadioButton(
         JDRResources.getString("displaypage.user"), false);
      userButton.setMnemonic(
         JDRResources.getChar("displaypage.user.mnemonic"));
      userButton.addActionListener(this);
      userButton.setActionCommand("enableuser");
      group.add(userButton);
      optionPanel.add(userButton);

      userBox = new NonNegativeIntField(1);
      optionPanel.add(userBox);

      JLabel noteLabel = new JLabel(
         JDRResources.getString("displaypage.note"));

      noteLabel.setAlignmentX(Component.LEFT_ALIGNMENT);
      p1.add(noteLabel);

      getContentPane().add(p1, "Center");

      JPanel p2 = new JPanel();

      p2.add(JDRResources.createOkayButton(this));
      p2.add(JDRResources.createCancelButton(this));
      p2.add(JDRResources.createHelpButton("sec:displaypage"));

      getContentPane().add(p2, "South");

      pack();
      setLocationRelativeTo(application_);
   }

   public void display()
   {
      mainPanel = application_.getCurrentFrame();

      switch (mainPanel.getDisplayPage())
      {
         case JDRCanvas.PAGES_ALL:
            allButton.setSelected(true);
            userBox.setEnabled(false);
            break;
         case JDRCanvas.PAGES_ODD:
            oddButton.setSelected(true);
            userBox.setEnabled(false);
            break;
         case JDRCanvas.PAGES_EVEN:
            evenButton.setSelected(true);
            userBox.setEnabled(false);
            break;
         default:
            userButton.setSelected(true);
            userBox.setEnabled(true);
            userBox.requestFocusInWindow();
      }

      setVisible(true);
   }

   public void okay()
   {
      if (allButton.isSelected())
      {
         mainPanel.setDisplayPage(JDRCanvas.PAGES_ALL);
      }
      else if (oddButton.isSelected())
      {
         mainPanel.setDisplayPage(JDRCanvas.PAGES_ODD);
      }
      else if (evenButton.isSelected())
      {
         mainPanel.setDisplayPage(JDRCanvas.PAGES_EVEN);
      }
      else
      {
         mainPanel.setDisplayPage(userBox.getValue());
      }
      setVisible(false);
   }

   public void actionPerformed(ActionEvent e)
   {
      String action = e.getActionCommand();

      if (action == null) return;

      if (action.equals("okay"))
      {
         okay();
      } 
      else if (action.equals("cancel"))
      {
         setVisible(false);
      }
      else if (action.equals("disableuser"))
      {
         userBox.setEnabled(false);
      }
      else if (action.equals("enableuser"))
      {
         userBox.setEnabled(true);
         userBox.requestFocusInWindow();
      }
   }

   public String info()
   {
      String eol = System.getProperty("line.separator", "\n");

      String str = "";

      str += "DisplayPageDialog:"+eol;
      str += "has focus: "+hasFocus()+eol;
      str += "user box has focus: "+userBox.hasFocus()+eol;
      str += "all button has focus: "+allButton.hasFocus()+eol;
      str += "odd button has focus: "+oddButton.hasFocus()+eol;
      str += "even button has focus: "+evenButton.hasFocus()+eol;
      str += "user button has focus: "+userButton.hasFocus()+eol;

      return str+eol;
   }

   private JpgfDraw application_;
   private NonNegativeIntField userBox;
   private JDRFrame mainPanel = null;

   private JRadioButton allButton, oddButton, evenButton, userButton;
}
