// File          : DiscardDialogBox.java
// Description   : Dialog box used to confirm discarding an image
// Date          : 1st February 2006
// Last Modified : 9th June 2008
// Author        : Nicola L.C. Talbot
//                 http://theoval.cmp.uea.ac.uk/~nlct/

/*
    Copyright (C) 2006 Nicola L.C. Talbot

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
*/
package uk.ac.uea.cmp.nlct.jpgfdraw.dialog;

import java.awt.*;
import java.awt.event.*;

import javax.swing.*;
import javax.swing.event.*;

import uk.ac.uea.cmp.nlct.jdr.*;

import uk.ac.uea.cmp.nlct.jdrresources.*;

import uk.ac.uea.cmp.nlct.jpgfdraw.*;

/**
 * Dialog box used to confirm discarding an image.
 */

public class DiscardDialogBox extends JDialog
   implements ActionListener
{
   public DiscardDialogBox(JpgfDraw application)
   {
      super(application, JDRResources.getString("discard.title"),true);
      application_ = application;

      int width  = 300;
      int height = 120;
      setSize(width,height);
      setLocationRelativeTo(application);

      //ImageIcon ic = new ImageIcon("Warn.gif");
      //getContentPane().add(new JLabel(ic), "West");

      JPanel p1 = new JPanel();
      
      p1.setLayout(new GridLayout(2,1));

      infoLabel = new JLabel("");

      p1.add(infoLabel);
      p1.add(new JLabel(JDRResources.getString("discard.image_not_saved")));

      getContentPane().add(p1, "Center");

      JPanel p2 = new JPanel();

      p2.add(JDRResources.createAppButton("save", this,
         KeyStroke.getKeyStroke(KeyEvent.VK_ENTER, 0),
         JDRResources.getString("discard.save")));

      p2.add(JDRResources.createAppButton("discard", this,
         null, JDRResources.getString("discard.discard")));

      p2.add(JDRResources.createCancelButton(this));

      getContentPane().add(p2, "South");
   }

   public void initialise()
   {
      try
      {
         JDRFrame frame = application_.getCurrentFrame();
         String filename = frame.getFilename();
         infoLabel.setText(
            JDRResources.getStringWithValue("discard.image",
               filename));
         setVisible(true);
      }
      catch (Exception e)
      {
         setVisible(false);
         JDRResources.internalError(application_,
            JDRResources.getString("error.fatal")+": "
            +e.getMessage(),e);
         System.exit(0);
      }
   }

   public void actionPerformed(ActionEvent evt)
   {
      String action = evt.getActionCommand();

      if (action == null) return;

      JDRFrame frame = application_.getCurrentFrame();

      if (action.equals("save"))
      {
         save(frame);
      }
      else if (action.equals("discard"))
      {
         // discard without saving
         frame.discardWithoutSaving();
         setVisible(false);
      }
      else if (action.equals("cancel"))
      {
         setVisible(false);
      }
   }

   public void save(JDRFrame frame)
   {
      // save it, then discard
      if (frame.saveAndDiscard())
      {
         setVisible(false);
      }
   }

   public String info()
   {
      String eol = System.getProperty("line.separator", "\n");

      String str = "";

      str += "DiscardDialog:"+eol;
      str += "has focus: "+hasFocus()+eol;

      return str+eol;
   }

   private JpgfDraw application_;
   private JLabel infoLabel;
}
