// File          : ColorRGBPanel.java
// Description   : Panel for selecting RGB paint
// Date          : 6th February 2006
// Last Modified : 6th July 2009
// Author        : Nicola L.C. Talbot
//                 http://theoval.cmp.uea.ac.uk/~nlct/

/*
    Copyright (C) 2006 Nicola L.C. Talbot

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
*/
package uk.ac.uea.cmp.nlct.jpgfdraw.dialog;

import java.awt.*;
import java.awt.event.*;

import javax.swing.*;
import javax.swing.event.*;

import uk.ac.uea.cmp.nlct.jdr.*;

import uk.ac.uea.cmp.nlct.jdrresources.*;
import uk.ac.uea.cmp.nlct.jdrresources.numfield.*;

/**
 * Panel for selecting RGB paint.
 * @author Nicola L C Talbot
 */

public class ColorRGBPanel extends JPanel
   implements AdjustmentListener,SingleColourSelector
{
   public ColorRGBPanel()
   {
      initialise();
   }

   public ColorRGBPanel(AdjustmentListener al)
   {
      initialise();
      addAdjustmentListener(al);
   }

   public void addAdjustmentListener(AdjustmentListener al)
   {
      redSB.addAdjustmentListener(al);
      greenSB.addAdjustmentListener(al);
      blueSB.addAdjustmentListener(al);
      alphaSB.addAdjustmentListener(al);
   }

   public void initialise()
   {
      setLayout(new GridBagLayout());
      GridBagConstraints constraints = new GridBagConstraints();
      constraints.weightx = 100;
      constraints.weighty = 100;
      constraints.gridx = 0;
      constraints.gridy = 0;
      constraints.gridwidth = 2;
      constraints.gridheight = 1;
      constraints.fill = GridBagConstraints.HORIZONTAL;

      JPanel sliders = new JPanel();
      add(sliders,constraints);

      sliders.setLayout(new GridBagLayout());
      GridBagConstraints gbc = new GridBagConstraints();
      gbc.weightx = 100;
      gbc.weighty = 100;
      gbc.fill = GridBagConstraints.BOTH;
      gbc.gridx = 0;
      gbc.gridy = 0;
      gbc.gridwidth = 1;
      gbc.gridheight = 1;
      redLabel = new JLabel(JDRResources.getString("colour.red"),
                            SwingConstants.RIGHT);
      sliders.add(redLabel, gbc);

      redSB = new JScrollBar(Adjustable.HORIZONTAL, 0,0,0,100);
      gbc.gridy = 0;
      gbc.gridx = 1;
      gbc.gridwidth = 4;
      gbc.gridheight = 1;
      sliders.add(redSB, gbc);
      gbc.gridx = 5;
      gbc.gridwidth = 1;
      gbc.fill = GridBagConstraints.NONE;
      gbc.anchor = GridBagConstraints.WEST;
      sliders.add(redText = new PercentageField(0), gbc);
      redText.getDocument().addDocumentListener(
          new TextFieldSBarListener(redText,redSB));

      redSB.setBlockIncrement(10);
      redSB.addAdjustmentListener(this);

      gbc.gridx = 0;
      gbc.gridy = 1;
      gbc.gridwidth = 1;
      gbc.gridheight = 1;
      gbc.fill = GridBagConstraints.BOTH;
      greenLabel = new JLabel(JDRResources.getString("colour.green"),
                              SwingConstants.RIGHT);
      sliders.add(greenLabel, gbc);
      gbc.gridx = 1;
      gbc.gridwidth = 3;
      greenSB = new JScrollBar(Adjustable.HORIZONTAL, 0,0,0,100);
      sliders.add(greenSB,gbc);
      gbc.gridx = 5;
      gbc.gridwidth = 1;
      gbc.fill = GridBagConstraints.NONE;
      sliders.add(greenText = new PercentageField(0),gbc);
      greenText.getDocument().addDocumentListener(
          new TextFieldSBarListener(greenText,greenSB));
      greenSB.setBlockIncrement(10);
      greenSB.addAdjustmentListener(this);

      gbc.gridx = 0;
      gbc.gridy = 2;
      gbc.fill = GridBagConstraints.BOTH;
      gbc.gridwidth = 1;
      gbc.gridheight = 1;
      blueLabel = new JLabel(JDRResources.getString("colour.blue"),
                             SwingConstants.RIGHT);
      sliders.add(blueLabel, gbc);
      gbc.gridx = 1;
      gbc.gridwidth = 4;
      blueSB = new JScrollBar(Adjustable.HORIZONTAL, 0,0,0,100);
      sliders.add(blueSB,gbc);
      gbc.gridx = 5;
      gbc.gridwidth = 1;
      gbc.fill = GridBagConstraints.NONE;
      sliders.add(blueText = new PercentageField(0),gbc);
      blueText.getDocument().addDocumentListener(
          new TextFieldSBarListener(blueText,blueSB));
      blueSB.setBlockIncrement(10);
      blueSB.addAdjustmentListener(this);

      gbc.gridx = 0;
      gbc.gridy = 3;
      gbc.gridwidth = 1;
      gbc.gridheight = 1;
      gbc.fill = GridBagConstraints.BOTH;
      alphaLabel = new JLabel(JDRResources.getString("colour.alpha"),
                              SwingConstants.RIGHT);
      sliders.add(alphaLabel, gbc);
      gbc.gridx = 1;
      gbc.gridwidth = 4;
      alphaSB = new JScrollBar(Adjustable.HORIZONTAL,100,0,0,100);
      sliders.add(alphaSB,gbc);
      gbc.gridx = 5;
      gbc.gridwidth = 1;
      gbc.fill = GridBagConstraints.NONE;
      sliders.add(alphaText = new PercentageField(100),gbc);
      alphaText.getDocument().addDocumentListener(
          new TextFieldSBarListener(alphaText,alphaSB));
      alphaSB.setBlockIncrement(10);
      alphaSB.addAdjustmentListener(this);
   }

   public boolean requestDefaultColourFocus()
   {
      return redText.requestFocusInWindow();
   }

   public void adjustmentValueChanged(AdjustmentEvent evt)
   {
      if (redText.getValue() != (redSB.getValue()))
         redText.setValue(redSB.getValue());

      if (greenText.getValue() != (greenSB.getValue()))
         greenText.setValue(greenSB.getValue());

      if (blueText.getValue() != (blueSB.getValue()))
         blueText.setValue(blueSB.getValue());

      if (alphaText.getValue() != (alphaSB.getValue()))
         alphaText.setValue(alphaSB.getValue());
   }

   public JDRPaint getPaint()
   {
      JDRColor c = null;

      try
      {
         c = new JDRColor(redSB.getValue()/100.0F,
                          greenSB.getValue()/100.0F,
                          blueSB.getValue()/100.0F,
                          alphaSB.getValue()/100.0F);
      }
      catch (InvalidFormatException ignore)
      {
      }

      return c;
   }

   public void setPaint(JDRPaint paint)
   {
      JDRColor c = paint.getJDRColor();

      redSB.setValue((int)Math.round((c.getRed()*100.0)));
      greenSB.setValue((int)Math.round((c.getGreen()*100.0)));
      blueSB.setValue((int)Math.round((c.getBlue()*100.0)));
      alphaSB.setValue((int)Math.round((c.getAlpha()*100.0)));
   }

   public void setEnabled(boolean flag)
   {
      redSB.setEnabled(flag);
      greenSB.setEnabled(flag);
      blueSB.setEnabled(flag);
      alphaSB.setEnabled(flag);
      redText.setEnabled(flag);
      greenText.setEnabled(flag);
      blueText.setEnabled(flag);
      alphaText.setEnabled(flag);
      redLabel.setEnabled(flag);
      greenLabel.setEnabled(flag);
      blueLabel.setEnabled(flag);
      alphaLabel.setEnabled(flag);
   }

   private JScrollBar redSB, greenSB, blueSB, alphaSB;
   private PercentageField redText, greenText, blueText, alphaText;
   private JLabel redLabel, greenLabel, blueLabel, alphaLabel;
}
