// File          : ColorButton.java
// Description   : Button representing a colour swatch
// Date          : 6th February 2006
// Last Modified : 9th June 2008
// Author        : Nicola L.C. Talbot
//                 http://theoval.cmp.uea.ac.uk/~nlct/

/*
    Copyright (C) 2006 Nicola L.C. Talbot

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
*/
package uk.ac.uea.cmp.nlct.jpgfdraw.dialog;

import java.awt.*;
import java.awt.event.*;
import java.awt.geom.*;

import javax.swing.*;
import javax.swing.event.*;

import uk.ac.uea.cmp.nlct.jdr.*;

import uk.ac.uea.cmp.nlct.jdrresources.*;

/**
 * Button representing colour swatch.
 * @author Nicola L C Talbot
 */

public class ColorButton extends JButton
{
    public ColorButton(Color color)
    {
       super("");
       paint = new JDRColor(color);
       setBackground(color);
    }

    public ColorButton(JDRPaint color)
    {
       super("");
       paint = color;
       setBackground(paint.getColor());
    }

    public Dimension getPreferredSize()
    {
       return dimension;
    }

    public Dimension getMaximumSize()
    {
       return dimension;
    }

    public Dimension getMinimumSize()
    {
       return dimension;
    }

    public Dimension getSize()
    {
       return dimension;
    }

    public JDRPaint getPaint()
    {
       return paint;
    }

    public void paintBorder(Graphics g)
    {
       Graphics2D g2 = (Graphics2D)g;
       if (!isFocusOwner())
       {
          g2.setColor(borderColor);
          g2.drawRect(0, 0, getWidth()-1, getHeight()-1);
       }
    }

    private JDRPaint paint;
    private static Color borderColor = new Color(160,160,160);
    private static Dimension dimension = new Dimension(30,30);
}
