// File          : ArrowStyleDialog.java
// Description   : Dialog for setting marker styles
// Date          : 6th February 2006
// Last Modified : 9th June 2008
// Author        : Nicola L.C. Talbot
//                 http://theoval.cmp.uea.ac.uk/~nlct/

/*
    Copyright (C) 2006 Nicola L.C. Talbot

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
*/
package uk.ac.uea.cmp.nlct.jpgfdraw.dialog;

import java.awt.*;
import java.awt.event.*;

import javax.swing.*;
import javax.swing.event.*;
import javax.swing.border.*;

import uk.ac.uea.cmp.nlct.jdr.*;
import uk.ac.uea.cmp.nlct.jdr.marker.*;

import uk.ac.uea.cmp.nlct.jdrresources.*;

import uk.ac.uea.cmp.nlct.jpgfdraw.*;

/**
 * Dialog for setting marker style. (Used by {@link LineStylePanel}.)
 * @see ArrowStyleSelector
 * @author Nicola L C Talbot
 */

public class ArrowStyleDialog extends JDialog
   implements ActionListener
{
   public ArrowStyleDialog(JDRSelector selector, int type)
   {
      super(selector, ArrowStylePanel.getTitle(type), true);
      selector_ = selector;

      setLayout(new BorderLayout());

      panel = new ArrowStylePanel(selector, type);
      panel.setBorder(BorderFactory.createLoweredBevelBorder());

      add(panel, BorderLayout.CENTER);

      JPanel p1 = new JPanel();
      p1.setBorder(BorderFactory.createEtchedBorder());

      add(p1, BorderLayout.SOUTH);

      p1.add(JDRResources.createOkayButton(this));
      p1.add(JDRResources.createCancelButton(this));
      p1.add(JDRResources.createHelpButton("sec:markers"));

      defaultButton = new JButton(
         JDRResources.getString("label.default"));
      defaultButton.setMnemonic(
         JDRResources.getChar("label.default.mnemonic"));
      defaultButton.addActionListener(this);
      defaultButton.setActionCommand("setdefaults");
      p1.add(defaultButton);

      pack();
      setLocationRelativeTo(selector);
   }

   public void init()
   {
      oldMarker = getMarker();

      setVisible(true);
   }

   public void actionPerformed(ActionEvent e)
   {
      String action = e.getActionCommand();

      if (action == null) return;

      if (action.equals("okay"))
      {
         okay();
      }
      else if (action.equals("cancel"))
      {
         cancel();
      }
      else if (action.equals("setdefaults"))
      {
         setDefaults();
      }
   }

   public void okay()
   {
      setVisible(false);
   }

   public void cancel()
   {
      setMarker(oldMarker);
      setVisible(false);
   }

   public String getDescription()
   {
      return panel.getDescription();
   }

   public void setMarker(JDRMarker marker)
   {
      panel.setMarker(marker);
   }

   public JDRMarker getMarker()
   {
      return panel.getMarker();
   }

   public void setDefaults()
   {
      panel.setDefaults();
      selector_.repaint();
   }

   public String info()
   {
      String eol = System.getProperty("line.separator", "\n");

      String str = "";

      str += "ArrowStyleDialog:"+eol;
      str += "has focus: "+hasFocus()+eol;
      str += "default has focus: "+defaultButton.hasFocus()+eol;
      str += "old marker: "+oldMarker+eol;

      return str+eol;
   }

   private JDRSelector selector_;
   private ArrowStylePanel panel;

   private JButton defaultButton;

   private JDRMarker oldMarker = new JDRMarker();
}
