// File          : TextAction.java
// Description   : Action for text objects
// Date          : 2012-03-14
// Author        : Nicola L.C. Talbot
//                 http://theoval.cmp.uea.ac.uk/~nlct/

/*
    Copyright (C) 2006 Nicola L.C. Talbot

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
*/
package uk.ac.uea.cmp.nlct.jpgfdraw;

import java.awt.event.*;
import javax.swing.*;

import uk.ac.uea.cmp.nlct.jdrresources.*;

public class TextAction extends JDRAction
{
   public TextAction(JpgfDraw application)
   {
      this.app = application;
   }

   public void actionPerformed(ActionEvent evt)
   {
      int id = getActionId();

      if (id == -1 && evt instanceof JDRActionEvent)
      {
         id = ((JDRActionEvent)evt).getActionId();
      }

      if (id == -1)
      {
         return;
      }

      switch (id)
      {
         case ACTION_EDIT:
            app.displayEditTextDialog();
         return;
         case ACTION_PAINT:
            app.displayTextPaintChooser();
         return;
         case ACTION_FAMILY:
            app.displayFontFamilyChooser();
         return;
         case ACTION_SIZE:
            app.displayFontSizeChooser();
         return;
         case ACTION_SHAPE:
            app.displayFontShapeChooser();
         return;
         case ACTION_SERIES:
            app.displayFontSeriesChooser();
         return;
         case ACTION_ANCHOR:
            app.displayFontAnchorChooser();
         return;
         case ACTION_HANCHOR:
            app.displayFontHAnchorChooser();
         return;
         case ACTION_VANCHOR:
            app.displayFontHAnchorChooser();
         return;
      }

   }

   public JDRMenuItem createEditItem()
   {
      JDRMenuItem item = new JDRMenuItem(
         JDRResources.getString("selectedtext.edit"),
         JDRResources.getChar("selectedtext.edit.mnemonic"));

      item.addActionListener(this);
      item.setActionId(ACTION_EDIT);

      return item;
   }

   public JDRMenuItem createPaintItem()
   {
      JDRMenuItem item = new JDRMenuItem(
         JDRResources.getString("selectedtext.colour"),
         JDRResources.getChar("selectedtext.colour.mnemonic"));

      item.addActionListener(this);
      item.setActionId(ACTION_PAINT);

      return item;
   }

   public JDRMenuItem createFamilyItem()
   {
      JDRMenuItem item = new JDRMenuItem(
         JDRResources.getString("selectedtext.family"),
         JDRResources.getChar("selectedtext.family.mnemonic"));

      item.addActionListener(this);
      item.setActionId(ACTION_FAMILY);

      return item;
   }

   public JDRMenuItem createSizeItem()
   {
      JDRMenuItem item = new JDRMenuItem(
         JDRResources.getString("selectedtext.size"),
         JDRResources.getChar("selectedtext.size.mnemonic"));

      item.addActionListener(this);
      item.setActionId(ACTION_SIZE);

      return item;
   }

   public JDRMenuItem createShapeItem()
   {
      JDRMenuItem item = new JDRMenuItem(
         JDRResources.getString("selectedtext.shape"),
         JDRResources.getChar("selectedtext.shape.mnemonic"));

      item.addActionListener(this);
      item.setActionId(ACTION_SHAPE);

      return item;
   }

   public JDRMenuItem createSeriesItem()
   {
      JDRMenuItem item = new JDRMenuItem(
         JDRResources.getString("selectedtext.series"),
         JDRResources.getChar("selectedtext.series.mnemonic"));

      item.addActionListener(this);
      item.setActionId(ACTION_SERIES);

      return item;
   }

   public JDRMenuItem createAnchorItem()
   {
      JDRMenuItem item = new JDRMenuItem(
         JDRResources.getString("edit.text.font.anchor.both"),
         JDRResources.getChar("edit.text.font.anchor.both.mnemonic"));

      item.addActionListener(this);
      item.setActionId(ACTION_ANCHOR);

      return item;
   }

   public JDRMenuItem createHAnchorItem()
   {
      JDRMenuItem item = new JDRMenuItem(
         JDRResources.getString("edit.text.font.anchor.horizontal"),
         JDRResources.getChar("edit.text.font.anchor.horizontal.mnemonic"));

      item.addActionListener(this);
      item.setActionId(ACTION_HANCHOR);

      return item;
   }

   public JDRMenuItem createVAnchorItem()
   {
      JDRMenuItem item = new JDRMenuItem(
         JDRResources.getString("edit.text.font.anchor.vertical"),
         JDRResources.getChar("edit.text.font.anchor.vertical.mnemonic"));

      item.addActionListener(this);
      item.setActionId(ACTION_VANCHOR);

      return item;
   }

   private JpgfDraw app;

   public static final int ACTION_EDIT    = 0;
   public static final int ACTION_PAINT   = 1;
   public static final int ACTION_FAMILY  = 2;
   public static final int ACTION_SIZE    = 3;
   public static final int ACTION_SHAPE   = 4;
   public static final int ACTION_SERIES  = 5;
   public static final int ACTION_ANCHOR  = 6;
   public static final int ACTION_HANCHOR = 7;
   public static final int ACTION_VANCHOR = 8;
}
