// File          : TeXAction.java
// Description   : TeX action (shapepar/parshape)
// Date          : 1st February 2006
// Last Modified : 9th June 2008
// Author        : Nicola L.C. Talbot
//                 http://theoval.cmp.uea.ac.uk/~nlct/

/*
    Copyright (C) 2006 Nicola L.C. Talbot

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
*/
package uk.ac.uea.cmp.nlct.jpgfdraw;

import java.awt.*;
import java.awt.event.*;

import javax.swing.*;
import javax.swing.event.*;

import uk.ac.uea.cmp.nlct.jdr.*;
import uk.ac.uea.cmp.nlct.jdrresources.*;

/**
 * Action associated with computing shapepar/parshape parameters.
 * @author Nicola L C Talbot
 */
public class TeXAction extends AbstractAction
{
   public TeXAction(JpgfDraw application, int act)
   {
      application_ = application;
      action = act;

      String frameTitle = "";

      String helpID = null;

      switch (action)
      {
         case PARSHAPE :
            putValue(Action.NAME, JDRResources.getString("tex.parshape"));
            frameTitle = JDRResources.getString("parshape.title");
            helpID = "sec:parshape";
         break;
         case SHAPEPAR :
            putValue(Action.NAME, JDRResources.getString("tex.shapepar"));
            frameTitle = JDRResources.getString("shapepar.title");
            helpID = "sec:shapepar";
         break;
      }

      dbox = new JDialog(application_, frameTitle, true);
      dbox.setSize(250,120);
      dbox.setLocationRelativeTo(application_);

      JPanel options = new JPanel();
      options.setLayout(new GridLayout(2,1));
      ButtonGroup group = new ButtonGroup();

      pathButton = new JRadioButton(
         JDRResources.getString("parshape.use_path"), true);
      options.add(pathButton);
      group.add(pathButton);

      outlineButton = new JRadioButton(
         JDRResources.getString("parshape.use_outline"));
      options.add(outlineButton);
      group.add(outlineButton);

      dbox.getContentPane().add(options, "Center");

      JPanel panel = new JPanel();

      panel.add(JDRResources.createOkayButton(this));
      panel.add(JDRResources.createCancelButton(this));
      panel.add(JDRResources.createHelpButton(helpID));

      dbox.getContentPane().add(panel, "South");
   }

   public void actionPerformed(ActionEvent evt)
   {
      String actionCommand = evt.getActionCommand();

      if (actionCommand == null) return;

      if (actionCommand.equals("okay"))
      {
         okay();
      }
      else if (actionCommand.equals("cancel"))
      {
         dbox.setVisible(false);
      }
      else if (actionCommand.equals("showparshapedialog"))
      {
         dbox.setVisible(true);
      }
   }

   public void okay()
   {
      boolean outline = outlineButton.isSelected();
      JDRFrame target = application_.getCurrentFrame();

      switch (action)
      {
         case PARSHAPE :
            target.parshape(outline);
         break;
         case SHAPEPAR :
            target.shapepar(outline);
         break;
      }

      dbox.setVisible(false);
   }

   public JDialog getDialog()
   {
      return dbox;
   }

   private JpgfDraw application_;
   private int action;
   public static final int PARSHAPE=0, SHAPEPAR=1;
   private JRadioButton outlineButton, pathButton;
   private JDialog dbox;
}

