// File          : StatusBar.java
// Description   : Status bar panel
// Date          : 1st February 2006
// Last Modified : 9th June 2008
// Author        : Nicola L.C. Talbot
//                 http://theoval.cmp.uea.ac.uk/~nlct/

/*
    Copyright (C) 2006 Nicola L.C. Talbot

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
*/
package uk.ac.uea.cmp.nlct.jpgfdraw;

import java.awt.*;

import javax.swing.*;
import javax.swing.border.*;

import uk.ac.uea.cmp.nlct.jdrresources.*;

/**
 * Status bar panel.
 * @author Nicola L C Talbot
 */
public class StatusBar extends JPanel
{
   public StatusBar(int width, int height)
   {
      super();

      JLabel tmp = new JLabel("000.0,000.0 bp ");
      posDim = tmp.getPreferredSize();
      
      tmp = new JLabel(JDRResources.getString("info.modified")+" ");
      modDim = tmp.getPreferredSize();

      tmp = null;

      pos = new JLabel()
      {
         public Dimension getPreferredSize()
         {
            return posDim;
         }

         public Dimension getSize()
         {
            return posDim;
         }

         public Dimension getMinimumSize()
         {
            return posDim;
         }

         public Dimension getMaximumSize()
         {
            return posDim;
         }
      };

      pos.setText(" ");

      modifiedLabel = new JLabel()
      {
         public Dimension getPreferredSize()
         {
            return modDim;
         }

         public Dimension getSize()
         {
            return modDim;
         }

         public Dimension getMinimumSize()
         {
            return modDim;
         }

         public Dimension getMaximumSize()
         {
            return modDim;
         }
      };

      modifiedLabel.setText(" ");

      lockIcon = JDRResources.appIcon("key.png");
      unlockIcon = JDRResources.appIcon("keycross.png");
      lockLabel = new JLabel(unlockIcon);

      infoField = new JTextField();
      infoField.setEditable(false);
      infoField.setFocusable(false);
      infoField.setDragEnabled(false);
      infoField.setHighlighter(null);

      setAlignmentX(Component.LEFT_ALIGNMENT);

      pos.setAlignmentX(Component.LEFT_ALIGNMENT);
      modifiedLabel.setAlignmentX(Component.LEFT_ALIGNMENT);
      lockLabel.setAlignmentX(Component.CENTER_ALIGNMENT);
      infoField.setAlignmentX(Component.LEFT_ALIGNMENT);

      BoxLayout layout = new BoxLayout(this, BoxLayout.X_AXIS);
      setLayout(layout);

      add(pos);
      add(modifiedLabel);
      add(lockLabel);
      add(infoField);

      setPreferredSize(new Dimension(width, height));
      setBorder(BorderFactory.createLoweredBevelBorder());

      pos.setBorder(BorderFactory.createLoweredBevelBorder());
      modifiedLabel.setBorder(
         BorderFactory.createLoweredBevelBorder());
      lockLabel.setBorder(BorderFactory.createLoweredBevelBorder());

      infoField.setBorder(null);

      infoField.setMinimumSize(new Dimension(0,0));
   }

   public void setInfo(String infoText)
   {
      infoField.setText(infoText);
      infoField.setCaretPosition(0);
   }

   public String getInfo()
   {
      return infoField.getText();
   }

   public void setLock(boolean lock)
   {
      if (lock)
      {
         lockLabel.setIcon(lockIcon);
      }
      else
      {
         lockLabel.setIcon(unlockIcon);
      }
   }

   public void setPosition(String positionText)
   {
      pos.setEnabled(true);
      pos.setText(positionText+" ");
   }

   public void setModified(boolean modified)
   {
      modifiedLabel.setEnabled(true);

      modifiedLabel.setText(modified ?
         JDRResources.getString("info.modified") : " ");
   }

   public void enableStatus()
   {
      pos.setEnabled(true);
      modifiedLabel.setEnabled(true);
      lockLabel.setEnabled(true);
   }

   /**
    * Indicates that no frames are selected. There may be
    * frames that are minimized or there may be no frames at all.
    * @param numFrames the number of frames that exist but are
    * not selected
    */
   public void noFramesSelected(int numFrames)
   {
      if (numFrames == 0)
      {
         setInfo(JDRResources.getString("info.no_frames"));
      }
      else
      {
         setInfo(JDRResources.getString("info.no_frames_selected"));
      }
      pos.setEnabled(false);
      modifiedLabel.setEnabled(false);
      lockLabel.setEnabled(false);
   }

   private JLabel pos, modifiedLabel, lockLabel;
   private JTextField infoField;
   private Icon lockIcon, unlockIcon;

   private Dimension posDim, modDim;
}
