// File          : SaveSvg.java
// Description   : Runnable to export to SVG.
// Date          : 14th July 2008
// Last Modified : 1 October 2009
// Author        : Nicola L.C. Talbot
//                 http://theoval.cmp.uea.ac.uk/~nlct/

/*
    Copyright (C) 2006 Nicola L.C. Talbot

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
*/
package uk.ac.uea.cmp.nlct.jpgfdraw;

import java.io.*;
import java.awt.*;
import javax.swing.*;

import uk.ac.uea.cmp.nlct.jdr.*;
import uk.ac.uea.cmp.nlct.jdr.io.*;
import uk.ac.uea.cmp.nlct.jdrresources.*;

/**
 * Runnable to export to SVG.
 */
public class SaveSvg implements Runnable
{
   private SaveSvg()
   {
   }

   public SaveSvg(JDRFrame frame, String filename, JDRGroup jdrImage)
   {
      jdrFrame = frame;
      fileName = filename;
      image = jdrImage;
   }

   public void run()
   {
      jdrFrame.setIoInProgress(true);

      Cursor oldCursor = jdrFrame.getCursor();
      jdrFrame.setCursor(
         Cursor.getPredefinedCursor(Cursor.WAIT_CURSOR));

      JpgfDraw app = jdrFrame.getApplication();

      app.showMessageFrame(
         JDRResources.getStringWithValue("info.saving", fileName));
      app.setStatusInfo(
         JDRResources.getStringWithValue("info.saving", fileName));

      PrintWriter out;

      try
      {
         out = new PrintWriter(new FileWriter(fileName));
      }
      catch (IOException e)
      {
         JDRResources.error(jdrFrame, new String[]
         {JDRResources.getStringWithValue("error.io.open", fileName),
          e.getMessage()});

         jdrFrame.setCursor(oldCursor);
         app.setTool(jdrFrame.currentTool());
         jdrFrame.setIoInProgress(false);
         app.hideMessageFrame();
         return;
      }

      try
      {
         SVG.save(image, fileName, out);
      }
      catch (IOException e)
      {
         JDRResources.error(jdrFrame,
         JDRResources.getString("error.io.save")+"\n"+
          e.getMessage(), e);
      }

      out.close();

      jdrFrame.setCursor(oldCursor);
      app.setTool(jdrFrame.currentTool());
      jdrFrame.setIoInProgress(false);
      app.hideMessageFrame();
   }

   private String fileName;
   private JDRGroup image;
   private JDRFrame jdrFrame;
}
