// File          : SavePgf.java
// Description   : Runnable to save image in thread.
// Date          : 14th July 2008
// Last Modified : 1 October 2009
// Author        : Nicola L.C. Talbot
//                 http://theoval.cmp.uea.ac.uk/~nlct/

/*
    Copyright (C) 2006 Nicola L.C. Talbot

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
*/
package uk.ac.uea.cmp.nlct.jpgfdraw;

import java.io.*;
import java.awt.*;
import javax.swing.*;

import uk.ac.uea.cmp.nlct.jdr.*;
import uk.ac.uea.cmp.nlct.jdr.io.*;
import uk.ac.uea.cmp.nlct.jdrresources.*;

/**
 * Runnable to save image in PGF format.
 */
public class SavePgf implements Runnable
{
   private SavePgf()
   {
   }

   public SavePgf(JDRFrame frame, String filename, JDRGroup jdrImage)
   {
      jdrFrame = frame;
      fileName = filename;
      image = jdrImage;
   }

   public void run()
   {
      jdrFrame.setIoInProgress(true);

      Cursor oldCursor = jdrFrame.getCursor();
      jdrFrame.setCursor(
         Cursor.getPredefinedCursor(Cursor.WAIT_CURSOR));

      JpgfDraw app = jdrFrame.getApplication();

      app.showMessageFrame(
         JDRResources.getStringWithValue("info.saving", fileName));
      app.setStatusInfo(
         JDRResources.getStringWithValue("info.saving", fileName));

      PrintWriter out;

      try
      {
         out = new PrintWriter(new FileWriter(fileName));
      }
      catch (IOException e)
      {
         JDRResources.error(jdrFrame, new String[]
         {JDRResources.getStringWithValue("error.io.open", fileName),
          e.getMessage()});

         jdrFrame.setCursor(oldCursor);
         app.setTool(jdrFrame.currentTool());
         jdrFrame.setIoInProgress(false);
         app.hideMessageFrame();
         return;
      }

      try
      {
         BBox box = image.getBBox();
         out.println("% "+jdrFrame.getFilename());
         PGF.save(image, out,
            JDRResources.getStringWithValue("tex.comment.created_by",
               new String[]{app.appName, app.version}));

      }
      catch (IOException e)
      {
         JDRResources.error(jdrFrame, new String[]
         {JDRResources.getString("error.io.save"),
          e.getMessage()});
      }

      out.close();

      jdrFrame.setCursor(oldCursor);
      app.setTool(jdrFrame.currentTool());
      jdrFrame.setIoInProgress(false);
      app.hideMessageFrame();
   }

   private String fileName;
   private float ajrVersion;
   private JDRGroup image;
   private JDRFrame jdrFrame;
   private CanvasSettings canvasSettings;
}
