// File          : SaveFlf.java
// Description   : Runnable to export flowfram data.
// Date          : 14th July 2008
// Last Modified : 1 October 2009
// Author        : Nicola L.C. Talbot
//                 http://theoval.cmp.uea.ac.uk/~nlct/

/*
    Copyright (C) 2006 Nicola L.C. Talbot

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
*/
package uk.ac.uea.cmp.nlct.jpgfdraw;

import java.io.*;
import java.awt.*;
import javax.swing.*;

import uk.ac.uea.cmp.nlct.jdr.*;
import uk.ac.uea.cmp.nlct.jdr.io.*;
import uk.ac.uea.cmp.nlct.jdrresources.*;

/**
 * Runnable to export flowfram data.
 */
public class SaveFlf implements Runnable
{
   private SaveFlf()
   {
   }

   public SaveFlf(JDRFrame frame, String filename, JDRGroup jdrImage)
   {
      jdrFrame = frame;
      fileName = filename;
      image = jdrImage;
   }

   public void run()
   {
      jdrFrame.setIoInProgress(true);

      Cursor oldCursor = jdrFrame.getCursor();
      jdrFrame.setCursor(
         Cursor.getPredefinedCursor(Cursor.WAIT_CURSOR));

      JpgfDraw app = jdrFrame.getApplication();

      app.showMessageFrame(
         JDRResources.getStringWithValue("info.saving", fileName));
      app.setStatusInfo(
         JDRResources.getStringWithValue("info.saving", fileName));

      try
      {
         FLF.save(image, fileName, jdrFrame.getPaper(),
            jdrFrame.getLaTeXFonts(),
            JDRResources.getStringWithValue("tex.comment.created_by",
               new String[]{app.appName, app.version}),
            jdrFrame.getFilename());

         if (!image.anyFlowFrameData())
         {
            JDRResources.warning(jdrFrame,
               JDRResources.getString("warning.no_flowframe_data"));
         }
      }
      catch (MissingTypeBlockException e)
      {
         JDRResources.error(jdrFrame,
            JDRResources.getString("error.no_typeblock"));
      }
      catch (MissplacedTypeBlockException e)
      {
         JDRResources.internalError(jdrFrame,
         JDRResources.getString("error.invalid_frame_type"), e);
      }
      catch (InvalidShapeException e)
      {
         JOptionPane.showMessageDialog(jdrFrame,
         new String[]
         {JDRResources.getString("error.parshape.convert"),
          e.getMessage()},
         JDRResources.getString("error.shape.incompatible"),
         JOptionPane.ERROR_MESSAGE);
      }
      catch (IOException e)
      {
         JDRResources.error(jdrFrame,
         JDRResources.getString("error.io.save")+"\n"+
          e.getMessage(), e);
      }

      jdrFrame.setCursor(oldCursor);
      app.setTool(jdrFrame.currentTool());
      jdrFrame.setIoInProgress(false);
      app.hideMessageFrame();
   }

   private String fileName;
   private JDRGroup image;
   private JDRFrame jdrFrame;
}
